/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.function;

import ai2.org.apache.poi.ss.formula.function.FunctionDataBuilder;
import ai2.org.apache.poi.ss.formula.function.FunctionMetadataRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

final class FunctionMetadataReader {
    private static final String METADATA_FILE_NAME = "functionMetadata.txt";
    private static final String ELLIPSIS = "...";
    private static final Pattern TAB_DELIM_PATTERN = Pattern.compile("\t");
    private static final Pattern SPACE_DELIM_PATTERN = Pattern.compile(" ");
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final String[] DIGIT_ENDING_FUNCTION_NAMES = new String[]{"LOG10", "ATAN2", "DAYS360", "SUMXMY2", "SUMX2MY2", "SUMX2PY2"};
    private static final Set<String> DIGIT_ENDING_FUNCTION_NAMES_SET = new HashSet<String>(Arrays.asList(DIGIT_ENDING_FUNCTION_NAMES));

    FunctionMetadataReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static FunctionMetadataRegistry createRegistry() {
        try {
            InputStream inputStream = FunctionMetadataReader.class.getResourceAsStream(METADATA_FILE_NAME);
            if (inputStream == null) {
                throw new RuntimeException("resource 'functionMetadata.txt' not found");
            }
            try {
                Object object;
                BufferedReader bufferedReader;
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new RuntimeException(unsupportedEncodingException);
                }
                try {
                    FunctionDataBuilder functionDataBuilder = new FunctionDataBuilder(400);
                    while ((object = bufferedReader.readLine()) != null) {
                        String string;
                        if (((String)object).length() < 1 || ((String)object).charAt(0) == '#' || (string = ((String)object).trim()).length() < 1) continue;
                        FunctionMetadataReader.processLine(functionDataBuilder, (String)object);
                    }
                    object = functionDataBuilder.build();
                }
                catch (Throwable throwable) {
                    bufferedReader.close();
                    throw throwable;
                }
                bufferedReader.close();
                return object;
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static void processLine(FunctionDataBuilder functionDataBuilder, String string) {
        String[] stringArray = TAB_DELIM_PATTERN.split(string, -2);
        if (stringArray.length != 8) {
            throw new RuntimeException("Bad line format '" + string + "' - expected 8 data fields");
        }
        int n = FunctionMetadataReader.parseInt(stringArray[0]);
        String string2 = stringArray[1];
        int n2 = FunctionMetadataReader.parseInt(stringArray[2]);
        int n3 = FunctionMetadataReader.parseInt(stringArray[3]);
        byte by = FunctionMetadataReader.parseReturnTypeCode(stringArray[4]);
        byte[] byArray = FunctionMetadataReader.parseOperandTypeCodes(stringArray[5]);
        boolean bl = stringArray[7].length() > 0;
        FunctionMetadataReader.validateFunctionName(string2);
        functionDataBuilder.add(n, string2, n2, n3, by, byArray, bl);
    }

    private static byte parseReturnTypeCode(String string) {
        if (string.length() == 0) {
            return 0;
        }
        return FunctionMetadataReader.parseOperandTypeCode(string);
    }

    private static byte[] parseOperandTypeCodes(String string) {
        int n;
        if (string.length() < 1) {
            return EMPTY_BYTE_ARRAY;
        }
        if (FunctionMetadataReader.isDash(string)) {
            return EMPTY_BYTE_ARRAY;
        }
        String[] stringArray = SPACE_DELIM_PATTERN.split(string);
        if (ELLIPSIS.equals(stringArray[(n = stringArray.length) - 1])) {
            --n;
        }
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = FunctionMetadataReader.parseOperandTypeCode(stringArray[i]);
        }
        return byArray;
    }

    private static boolean isDash(String string) {
        if (string.length() == 1) {
            switch (string.charAt(0)) {
                case '-': {
                    return true;
                }
            }
        }
        return false;
    }

    private static byte parseOperandTypeCode(String string) {
        if (string.length() != 1) {
            throw new RuntimeException("Bad operand type code format '" + string + "' expected single char");
        }
        switch (string.charAt(0)) {
            case 'V': {
                return 32;
            }
            case 'R': {
                return 0;
            }
            case 'A': {
                return 64;
            }
        }
        throw new IllegalArgumentException("Unexpected operand type code '" + string + "' (" + string.charAt(0) + ")");
    }

    private static void validateFunctionName(String string) {
        int n = string.length();
        int n2 = n - 1;
        if (!Character.isDigit(string.charAt(n2))) {
            return;
        }
        while (n2 >= 0 && Character.isDigit(string.charAt(n2))) {
            --n2;
        }
        if (DIGIT_ENDING_FUNCTION_NAMES_SET.contains(string)) {
            return;
        }
        throw new RuntimeException("Invalid function name '" + string + "' (is footnote number incorrectly appended)");
    }

    private static int parseInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException("Value '" + string + "' could not be parsed as an integer");
        }
    }
}

