/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.eval;

import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.EvaluationException;
import ai2.org.apache.poi.ss.formula.eval.NumberEval;
import ai2.org.apache.poi.ss.formula.eval.OperandResolver;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.Fixed2ArgFunction;
import ai2.org.apache.poi.ss.formula.functions.Function;

public abstract class TwoOperandNumericOperation
extends Fixed2ArgFunction {
    public static final Function AddEval = new TwoOperandNumericOperation(){

        protected double evaluate(double d, double d2) {
            return d + d2;
        }
    };
    public static final Function DivideEval = new TwoOperandNumericOperation(){

        protected double evaluate(double d, double d2) throws EvaluationException {
            if (d2 == 0.0) {
                throw new EvaluationException(ErrorEval.DIV_ZERO);
            }
            return d / d2;
        }
    };
    public static final Function MultiplyEval = new TwoOperandNumericOperation(){

        protected double evaluate(double d, double d2) {
            return d * d2;
        }
    };
    public static final Function PowerEval = new TwoOperandNumericOperation(){

        protected double evaluate(double d, double d2) {
            return Math.pow(d, d2);
        }
    };
    public static final Function SubtractEval = new SubtractEvalClass();

    protected final double singleOperandEvaluate(ValueEval valueEval, int n, int n2) throws EvaluationException {
        ValueEval valueEval2 = OperandResolver.getSingleValue(valueEval, n, n2);
        return OperandResolver.coerceValueToDouble(valueEval2);
    }

    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2) {
        double d;
        try {
            double d2 = this.singleOperandEvaluate(valueEval, n, n2);
            double d3 = this.singleOperandEvaluate(valueEval2, n, n2);
            d = this.evaluate(d2, d3);
            if (d == 0.0 && !(this instanceof SubtractEvalClass)) {
                return NumberEval.ZERO;
            }
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                return ErrorEval.NUM_ERROR;
            }
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
        return new NumberEval(d);
    }

    protected abstract double evaluate(double var1, double var3) throws EvaluationException;

    private static final class SubtractEvalClass
    extends TwoOperandNumericOperation {
        protected double evaluate(double d, double d2) {
            return d - d2;
        }
    }
}

