/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.eval;

import ai2.org.apache.poi.ss.formula.eval.AreaEval;
import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.EvaluationException;
import ai2.org.apache.poi.ss.formula.eval.RefEval;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.Fixed2ArgFunction;
import ai2.org.apache.poi.ss.formula.functions.Function;

public final class RangeEval
extends Fixed2ArgFunction {
    public static final Function instance = new RangeEval();

    private RangeEval() {
    }

    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2) {
        try {
            AreaEval areaEval = RangeEval.evaluateRef(valueEval);
            AreaEval areaEval2 = RangeEval.evaluateRef(valueEval2);
            return RangeEval.resolveRange(areaEval, areaEval2);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
    }

    private static AreaEval resolveRange(AreaEval areaEval, AreaEval areaEval2) {
        int n = areaEval.getFirstRow();
        int n2 = areaEval.getFirstColumn();
        int n3 = Math.min(n, areaEval2.getFirstRow());
        int n4 = Math.max(areaEval.getLastRow(), areaEval2.getLastRow());
        int n5 = Math.min(n2, areaEval2.getFirstColumn());
        int n6 = Math.max(areaEval.getLastColumn(), areaEval2.getLastColumn());
        return areaEval.offset(n3 - n, n4 - n, n5 - n2, n6 - n2);
    }

    private static AreaEval evaluateRef(ValueEval valueEval) throws EvaluationException {
        if (valueEval instanceof AreaEval) {
            return (AreaEval)valueEval;
        }
        if (valueEval instanceof RefEval) {
            return ((RefEval)valueEval).offset(0, 0, 0, 0);
        }
        if (valueEval instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)valueEval);
        }
        throw new IllegalArgumentException("Unexpected ref arg class (" + valueEval.getClass().getName() + ")");
    }
}

