/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.eval;

import ai2.org.apache.poi.ss.formula.eval.EvaluationException;
import ai2.org.apache.poi.ss.formula.eval.NumberEval;
import ai2.org.apache.poi.ss.formula.eval.OperandResolver;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.Fixed1ArgFunction;
import ai2.org.apache.poi.ss.formula.functions.Function;

public final class PercentEval
extends Fixed1ArgFunction {
    public static final Function instance = new PercentEval();

    private PercentEval() {
    }

    public ValueEval evaluate(int n, int n2, ValueEval valueEval) {
        double d;
        try {
            ValueEval valueEval2 = OperandResolver.getSingleValue(valueEval, n, n2);
            d = OperandResolver.coerceValueToDouble(valueEval2);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
        if (d == 0.0) {
            return NumberEval.ZERO;
        }
        return new NumberEval(d / 100.0);
    }
}

