/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.eval;

import ai2.org.apache.poi.ss.formula.SheetRange;
import ai2.org.apache.poi.ss.formula.eval.AreaEval;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.ptg.AreaI;

public abstract class AreaEvalBase
implements AreaEval {
    private final int _firstSheet;
    private final int _firstColumn;
    private final int _firstRow;
    private final int _lastSheet;
    private final int _lastColumn;
    private final int _lastRow;
    private final int _nColumns;
    private final int _nRows;

    protected AreaEvalBase(SheetRange sheetRange, int n, int n2, int n3, int n4) {
        this._firstColumn = n2;
        this._firstRow = n;
        this._lastColumn = n4;
        this._lastRow = n3;
        this._nColumns = this._lastColumn - this._firstColumn + 1;
        this._nRows = this._lastRow - this._firstRow + 1;
        if (sheetRange != null) {
            this._firstSheet = sheetRange.getFirstSheetIndex();
            this._lastSheet = sheetRange.getLastSheetIndex();
        } else {
            this._firstSheet = -1;
            this._lastSheet = -1;
        }
    }

    protected AreaEvalBase(int n, int n2, int n3, int n4) {
        this(null, n, n2, n3, n4);
    }

    protected AreaEvalBase(AreaI areaI) {
        this(areaI, null);
    }

    protected AreaEvalBase(AreaI areaI, SheetRange sheetRange) {
        this(sheetRange, areaI.getFirstRow(), areaI.getFirstColumn(), areaI.getLastRow(), areaI.getLastColumn());
    }

    public final int getFirstColumn() {
        return this._firstColumn;
    }

    public final int getFirstRow() {
        return this._firstRow;
    }

    public final int getLastColumn() {
        return this._lastColumn;
    }

    public final int getLastRow() {
        return this._lastRow;
    }

    public int getFirstSheetIndex() {
        return this._firstSheet;
    }

    public int getLastSheetIndex() {
        return this._lastSheet;
    }

    public final ValueEval getAbsoluteValue(int n, int n2) {
        int n3 = n - this._firstRow;
        int n4 = n2 - this._firstColumn;
        if (n3 < 0 || n3 >= this._nRows) {
            throw new IllegalArgumentException("Specified row index (" + n + ") is outside the allowed range (" + this._firstRow + ".." + this._lastRow + ")");
        }
        if (n4 < 0 || n4 >= this._nColumns) {
            throw new IllegalArgumentException("Specified column index (" + n2 + ") is outside the allowed range (" + this._firstColumn + ".." + n2 + ")");
        }
        return this.getRelativeValue(n3, n4);
    }

    public final boolean contains(int n, int n2) {
        return this._firstRow <= n && this._lastRow >= n && this._firstColumn <= n2 && this._lastColumn >= n2;
    }

    public final boolean containsRow(int n) {
        return this._firstRow <= n && this._lastRow >= n;
    }

    public final boolean containsColumn(int n) {
        return this._firstColumn <= n && this._lastColumn >= n;
    }

    public final boolean isColumn() {
        return this._firstColumn == this._lastColumn;
    }

    public final boolean isRow() {
        return this._firstRow == this._lastRow;
    }

    public int getHeight() {
        return this._lastRow - this._firstRow + 1;
    }

    public final ValueEval getValue(int n, int n2) {
        return this.getRelativeValue(n, n2);
    }

    public final ValueEval getValue(int n, int n2, int n3) {
        return this.getRelativeValue(n, n2, n3);
    }

    public abstract ValueEval getRelativeValue(int var1, int var2);

    public abstract ValueEval getRelativeValue(int var1, int var2, int var3);

    public int getWidth() {
        return this._lastColumn - this._firstColumn + 1;
    }

    public boolean isSubTotal(int n, int n2) {
        return false;
    }
}

