/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.atp;

import ai2.org.apache.poi.ss.formula.OperationEvaluationContext;
import ai2.org.apache.poi.ss.formula.eval.BoolEval;
import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.EvaluationException;
import ai2.org.apache.poi.ss.formula.eval.OperandResolver;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.FreeRefFunction;

final class ParityFunction
implements FreeRefFunction {
    public static final FreeRefFunction IS_EVEN = new ParityFunction(0);
    public static final FreeRefFunction IS_ODD = new ParityFunction(1);
    private final int _desiredParity;

    private ParityFunction(int n) {
        this._desiredParity = n;
    }

    public ValueEval evaluate(ValueEval[] valueEvalArray, OperationEvaluationContext operationEvaluationContext) {
        int n;
        if (valueEvalArray.length != 1) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            n = ParityFunction.evaluateArgParity(valueEvalArray[0], operationEvaluationContext.getRowIndex(), operationEvaluationContext.getColumnIndex());
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
        return BoolEval.valueOf(n == this._desiredParity);
    }

    private static int evaluateArgParity(ValueEval valueEval, int n, int n2) throws EvaluationException {
        ValueEval valueEval2 = OperandResolver.getSingleValue(valueEval, n, (short)n2);
        double d = OperandResolver.coerceValueToDouble(valueEval2);
        if (d < 0.0) {
            d = -d;
        }
        long l = (long)Math.floor(d);
        return (int)(l & 1L);
    }
}

