/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.atp;

import ai2.org.apache.poi.ss.formula.atp.DateParser;
import ai2.org.apache.poi.ss.formula.eval.AreaEvalBase;
import ai2.org.apache.poi.ss.formula.eval.EvaluationException;
import ai2.org.apache.poi.ss.formula.eval.OperandResolver;
import ai2.org.apache.poi.ss.formula.eval.StringEval;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.usermodel.DateUtil;
import java.util.ArrayList;
import java.util.Calendar;

final class ArgumentsEvaluator {
    public static final ArgumentsEvaluator instance = new ArgumentsEvaluator();

    private ArgumentsEvaluator() {
    }

    public double evaluateDateArg(ValueEval valueEval, int n, int n2) throws EvaluationException {
        ValueEval valueEval2 = OperandResolver.getSingleValue(valueEval, n, (short)n2);
        if (valueEval2 instanceof StringEval) {
            String string = ((StringEval)valueEval2).getStringValue();
            Double d = OperandResolver.parseDouble(string);
            if (d != null) {
                return d;
            }
            Calendar calendar = DateParser.parseDate(string);
            return DateUtil.getExcelDate(calendar, false);
        }
        return OperandResolver.coerceValueToDouble(valueEval2);
    }

    public double[] evaluateDatesArg(ValueEval valueEval, int n, int n2) throws EvaluationException {
        if (valueEval == null) {
            return new double[0];
        }
        if (valueEval instanceof StringEval) {
            return new double[]{this.evaluateDateArg(valueEval, n, n2)};
        }
        if (valueEval instanceof AreaEvalBase) {
            int n3;
            ArrayList<Double> arrayList = new ArrayList<Double>();
            AreaEvalBase areaEvalBase = (AreaEvalBase)valueEval;
            for (int i = areaEvalBase.getFirstRow(); i <= areaEvalBase.getLastRow(); ++i) {
                for (n3 = areaEvalBase.getFirstColumn(); n3 <= areaEvalBase.getLastColumn(); ++n3) {
                    arrayList.add(this.evaluateDateArg(areaEvalBase.getValue(i, n3), i, n3));
                }
            }
            double[] dArray = new double[arrayList.size()];
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                dArray[n3] = (Double)arrayList.get(n3);
            }
            return dArray;
        }
        return new double[]{OperandResolver.coerceValueToDouble(valueEval)};
    }

    public double evaluateNumberArg(ValueEval valueEval, int n, int n2) throws EvaluationException {
        if (valueEval == null) {
            return 0.0;
        }
        return OperandResolver.coerceValueToDouble(valueEval);
    }
}

