/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula;

import ai2.org.apache.poi.ss.formula.OperationEvaluationContext;
import ai2.org.apache.poi.ss.formula.eval.FunctionNameEval;
import ai2.org.apache.poi.ss.formula.eval.NotImplementedFunctionException;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.FreeRefFunction;

final class UserDefinedFunction
implements FreeRefFunction {
    public static final FreeRefFunction instance = new UserDefinedFunction();

    private UserDefinedFunction() {
    }

    public ValueEval evaluate(ValueEval[] valueEvalArray, OperationEvaluationContext operationEvaluationContext) {
        int n = valueEvalArray.length;
        if (n < 1) {
            throw new RuntimeException("function name argument missing");
        }
        ValueEval valueEval = valueEvalArray[0];
        if (!(valueEval instanceof FunctionNameEval)) {
            throw new RuntimeException("First argument should be a NameEval, but got (" + valueEval.getClass().getName() + ")");
        }
        String string = ((FunctionNameEval)valueEval).getFunctionName();
        FreeRefFunction freeRefFunction = operationEvaluationContext.findUserDefinedFunction(string);
        if (freeRefFunction == null) {
            throw new NotImplementedFunctionException(string);
        }
        int n2 = n - 1;
        ValueEval[] valueEvalArray2 = new ValueEval[n2];
        System.arraycopy(valueEvalArray, 1, valueEvalArray2, 0, n2);
        return freeRefFunction.evaluate(valueEvalArray2, operationEvaluationContext);
    }
}

