/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula;

import ai2.org.apache.poi.ss.formula.EvaluationCell;
import ai2.org.apache.poi.ss.formula.EvaluationSheet;
import ai2.org.apache.poi.ss.formula.EvaluationTracker;
import ai2.org.apache.poi.ss.formula.EvaluationWorkbook;
import ai2.org.apache.poi.ss.formula.WorkbookEvaluator;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.ptg.FuncVarPtg;
import ai2.org.apache.poi.ss.formula.ptg.Ptg;

final class SheetRefEvaluator {
    private final WorkbookEvaluator _bookEvaluator;
    private final EvaluationTracker _tracker;
    private final int _sheetIndex;
    private EvaluationSheet _sheet;

    public SheetRefEvaluator(WorkbookEvaluator workbookEvaluator, EvaluationTracker evaluationTracker, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid sheetIndex: " + n + ".");
        }
        this._bookEvaluator = workbookEvaluator;
        this._tracker = evaluationTracker;
        this._sheetIndex = n;
    }

    public String getSheetName() {
        return this._bookEvaluator.getSheetName(this._sheetIndex);
    }

    public ValueEval getEvalForCell(int n, int n2) {
        return this._bookEvaluator.evaluateReference(this.getSheet(), this._sheetIndex, n, n2, this._tracker);
    }

    private EvaluationSheet getSheet() {
        if (this._sheet == null) {
            this._sheet = this._bookEvaluator.getSheet(this._sheetIndex);
        }
        return this._sheet;
    }

    public boolean isSubTotal(int n, int n2) {
        boolean bl = false;
        EvaluationCell evaluationCell = this.getSheet().getCell(n, n2);
        if (evaluationCell != null && evaluationCell.getCellType() == 2) {
            EvaluationWorkbook evaluationWorkbook = this._bookEvaluator.getWorkbook();
            for (Ptg ptg : evaluationWorkbook.getFormulaTokens(evaluationCell)) {
                FuncVarPtg funcVarPtg;
                if (!(ptg instanceof FuncVarPtg) || !"SUBTOTAL".equals((funcVarPtg = (FuncVarPtg)ptg).getName())) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }
}

