/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula;

import ai2.org.apache.poi.ss.formula.SheetRange;
import ai2.org.apache.poi.ss.formula.SheetRefEvaluator;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;

final class SheetRangeEvaluator
implements SheetRange {
    private final int _firstSheetIndex;
    private final int _lastSheetIndex;
    private SheetRefEvaluator[] _sheetEvaluators;

    public SheetRangeEvaluator(int n, int n2, SheetRefEvaluator[] sheetRefEvaluatorArray) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid firstSheetIndex: " + n + ".");
        }
        if (n2 < n) {
            throw new IllegalArgumentException("Invalid lastSheetIndex: " + n2 + " for firstSheetIndex: " + n + ".");
        }
        this._firstSheetIndex = n;
        this._lastSheetIndex = n2;
        this._sheetEvaluators = sheetRefEvaluatorArray;
    }

    public SheetRangeEvaluator(int n, SheetRefEvaluator sheetRefEvaluator) {
        this(n, n, new SheetRefEvaluator[]{sheetRefEvaluator});
    }

    public SheetRefEvaluator getSheetEvaluator(int n) {
        if (n < this._firstSheetIndex || n > this._lastSheetIndex) {
            throw new IllegalArgumentException("Invalid SheetIndex: " + n + " - Outside range " + this._firstSheetIndex + " : " + this._lastSheetIndex);
        }
        return this._sheetEvaluators[n - this._firstSheetIndex];
    }

    public int getFirstSheetIndex() {
        return this._firstSheetIndex;
    }

    public int getLastSheetIndex() {
        return this._lastSheetIndex;
    }

    public String getSheetName(int n) {
        return this.getSheetEvaluator(n).getSheetName();
    }

    public String getSheetNameRange() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getSheetName(this._firstSheetIndex));
        if (this._firstSheetIndex != this._lastSheetIndex) {
            stringBuilder.append(':');
            stringBuilder.append(this.getSheetName(this._lastSheetIndex));
        }
        return stringBuilder.toString();
    }

    public ValueEval getEvalForCell(int n, int n2, int n3) {
        return this.getSheetEvaluator(n).getEvalForCell(n2, n3);
    }
}

