/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula;

import ai2.org.apache.poi.ss.SpreadsheetVersion;
import ai2.org.apache.poi.ss.formula.ptg.AreaPtg;
import ai2.org.apache.poi.ss.formula.ptg.AreaPtgBase;
import ai2.org.apache.poi.ss.formula.ptg.OperandPtg;
import ai2.org.apache.poi.ss.formula.ptg.Ptg;
import ai2.org.apache.poi.ss.formula.ptg.RefPtg;
import ai2.org.apache.poi.ss.formula.ptg.RefPtgBase;

public class SharedFormula {
    private final int _columnWrappingMask;
    private final int _rowWrappingMask;

    public SharedFormula(SpreadsheetVersion spreadsheetVersion) {
        this._columnWrappingMask = spreadsheetVersion.getLastColumnIndex();
        this._rowWrappingMask = spreadsheetVersion.getLastRowIndex();
    }

    public Ptg[] convertSharedFormulas(Ptg[] ptgArray, int n, int n2) {
        Ptg[] ptgArray2 = new Ptg[ptgArray.length];
        for (int i = 0; i < ptgArray.length; ++i) {
            OperandPtg operandPtg;
            Ptg ptg = ptgArray[i];
            byte by = -1;
            if (!ptg.isBaseToken()) {
                by = ptg.getPtgClass();
            }
            if (ptg instanceof RefPtgBase) {
                operandPtg = (RefPtgBase)ptg;
                ptg = new RefPtg(this.fixupRelativeRow(n, ((RefPtgBase)operandPtg).getRow(), ((RefPtgBase)operandPtg).isRowRelative()), this.fixupRelativeColumn(n2, ((RefPtgBase)operandPtg).getColumn(), ((RefPtgBase)operandPtg).isColRelative()), ((RefPtgBase)operandPtg).isRowRelative(), ((RefPtgBase)operandPtg).isColRelative());
                ptg.setClass(by);
            } else if (ptg instanceof AreaPtgBase) {
                operandPtg = (AreaPtgBase)ptg;
                ptg = new AreaPtg(this.fixupRelativeRow(n, ((AreaPtgBase)operandPtg).getFirstRow(), ((AreaPtgBase)operandPtg).isFirstRowRelative()), this.fixupRelativeRow(n, ((AreaPtgBase)operandPtg).getLastRow(), ((AreaPtgBase)operandPtg).isLastRowRelative()), this.fixupRelativeColumn(n2, ((AreaPtgBase)operandPtg).getFirstColumn(), ((AreaPtgBase)operandPtg).isFirstColRelative()), this.fixupRelativeColumn(n2, ((AreaPtgBase)operandPtg).getLastColumn(), ((AreaPtgBase)operandPtg).isLastColRelative()), ((AreaPtgBase)operandPtg).isFirstRowRelative(), ((AreaPtgBase)operandPtg).isLastRowRelative(), ((AreaPtgBase)operandPtg).isFirstColRelative(), ((AreaPtgBase)operandPtg).isLastColRelative());
                ptg.setClass(by);
            } else if (ptg instanceof OperandPtg) {
                ptg = ((OperandPtg)ptg).copy();
            }
            ptgArray2[i] = ptg;
        }
        return ptgArray2;
    }

    private int fixupRelativeColumn(int n, int n2, boolean bl) {
        if (bl) {
            return n2 + n & this._columnWrappingMask;
        }
        return n2;
    }

    private int fixupRelativeRow(int n, int n2, boolean bl) {
        if (bl) {
            return n2 + n & this._rowWrappingMask;
        }
        return n2;
    }
}

