/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula;

import ai2.org.apache.poi.ss.formula.ptg.ArrayPtg;
import ai2.org.apache.poi.ss.formula.ptg.AttrPtg;
import ai2.org.apache.poi.ss.formula.ptg.FuncVarPtg;
import ai2.org.apache.poi.ss.formula.ptg.MemAreaPtg;
import ai2.org.apache.poi.ss.formula.ptg.MemFuncPtg;
import ai2.org.apache.poi.ss.formula.ptg.Ptg;

final class ParseNode {
    public static final ParseNode[] EMPTY_ARRAY = new ParseNode[0];
    private final Ptg _token;
    private final ParseNode[] _children;
    private boolean _isIf;
    private final int _tokenCount;

    public ParseNode(Ptg ptg, ParseNode[] parseNodeArray) {
        if (ptg == null) {
            throw new IllegalArgumentException("token must not be null");
        }
        this._token = ptg;
        this._children = parseNodeArray;
        this._isIf = ParseNode.isIf(ptg);
        int n = 1;
        for (int i = 0; i < parseNodeArray.length; ++i) {
            n += parseNodeArray[i].getTokenCount();
        }
        if (this._isIf) {
            n += parseNodeArray.length;
        }
        this._tokenCount = n;
    }

    public ParseNode(Ptg ptg) {
        this(ptg, EMPTY_ARRAY);
    }

    public ParseNode(Ptg ptg, ParseNode parseNode) {
        this(ptg, new ParseNode[]{parseNode});
    }

    public ParseNode(Ptg ptg, ParseNode parseNode, ParseNode parseNode2) {
        this(ptg, new ParseNode[]{parseNode, parseNode2});
    }

    private int getTokenCount() {
        return this._tokenCount;
    }

    public int getEncodedSize() {
        int n = this._token instanceof ArrayPtg ? 8 : this._token.getSize();
        for (int i = 0; i < this._children.length; ++i) {
            n += this._children[i].getEncodedSize();
        }
        return n;
    }

    public static Ptg[] toTokenArray(ParseNode parseNode) {
        TokenCollector tokenCollector = new TokenCollector(parseNode.getTokenCount());
        parseNode.collectPtgs(tokenCollector);
        return tokenCollector.getResult();
    }

    private void collectPtgs(TokenCollector tokenCollector) {
        boolean bl;
        if (ParseNode.isIf(this._token)) {
            this.collectIfPtgs(tokenCollector);
            return;
        }
        boolean bl2 = bl = this._token instanceof MemFuncPtg || this._token instanceof MemAreaPtg;
        if (bl) {
            tokenCollector.add(this._token);
        }
        for (int i = 0; i < this.getChildren().length; ++i) {
            this.getChildren()[i].collectPtgs(tokenCollector);
        }
        if (!bl) {
            tokenCollector.add(this._token);
        }
    }

    private void collectIfPtgs(TokenCollector tokenCollector) {
        this.getChildren()[0].collectPtgs(tokenCollector);
        int n = tokenCollector.createPlaceholder();
        this.getChildren()[1].collectPtgs(tokenCollector);
        int n2 = tokenCollector.createPlaceholder();
        int n3 = tokenCollector.sumTokenSizes(n + 1, n2);
        AttrPtg attrPtg = AttrPtg.createIf(n3 + 4);
        if (this.getChildren().length > 2) {
            this.getChildren()[2].collectPtgs(tokenCollector);
            int n4 = tokenCollector.createPlaceholder();
            int n5 = tokenCollector.sumTokenSizes(n2 + 1, n4);
            AttrPtg attrPtg2 = AttrPtg.createSkip(n5 + 4 + 4 - 1);
            AttrPtg attrPtg3 = AttrPtg.createSkip(3);
            tokenCollector.setPlaceholder(n, attrPtg);
            tokenCollector.setPlaceholder(n2, attrPtg2);
            tokenCollector.setPlaceholder(n4, attrPtg3);
        } else {
            AttrPtg attrPtg4 = AttrPtg.createSkip(3);
            tokenCollector.setPlaceholder(n, attrPtg);
            tokenCollector.setPlaceholder(n2, attrPtg4);
        }
        tokenCollector.add(this._token);
    }

    private static boolean isIf(Ptg ptg) {
        FuncVarPtg funcVarPtg;
        return ptg instanceof FuncVarPtg && "IF".equals((funcVarPtg = (FuncVarPtg)ptg).getName());
    }

    public Ptg getToken() {
        return this._token;
    }

    public ParseNode[] getChildren() {
        return this._children;
    }

    private static final class TokenCollector {
        private final Ptg[] _ptgs;
        private int _offset;

        public TokenCollector(int n) {
            this._ptgs = new Ptg[n];
            this._offset = 0;
        }

        public int sumTokenSizes(int n, int n2) {
            int n3 = 0;
            for (int i = n; i < n2; ++i) {
                n3 += this._ptgs[i].getSize();
            }
            return n3;
        }

        public int createPlaceholder() {
            return this._offset++;
        }

        public void add(Ptg ptg) {
            if (ptg == null) {
                throw new IllegalArgumentException("token must not be null");
            }
            this._ptgs[this._offset] = ptg;
            ++this._offset;
        }

        public void setPlaceholder(int n, Ptg ptg) {
            if (this._ptgs[n] != null) {
                throw new IllegalStateException("Invalid placeholder index (" + n + ")");
            }
            this._ptgs[n] = ptg;
        }

        public Ptg[] getResult() {
            return this._ptgs;
        }
    }
}

