/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula;

import ai2.org.apache.poi.ss.formula.OperationEvaluationContext;
import ai2.org.apache.poi.ss.formula.UserDefinedFunction;
import ai2.org.apache.poi.ss.formula.eval.ConcatEval;
import ai2.org.apache.poi.ss.formula.eval.FunctionEval;
import ai2.org.apache.poi.ss.formula.eval.IntersectionEval;
import ai2.org.apache.poi.ss.formula.eval.PercentEval;
import ai2.org.apache.poi.ss.formula.eval.RangeEval;
import ai2.org.apache.poi.ss.formula.eval.RelationalOperationEval;
import ai2.org.apache.poi.ss.formula.eval.TwoOperandNumericOperation;
import ai2.org.apache.poi.ss.formula.eval.UnaryMinusEval;
import ai2.org.apache.poi.ss.formula.eval.UnaryPlusEval;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.formula.functions.Function;
import ai2.org.apache.poi.ss.formula.functions.Indirect;
import ai2.org.apache.poi.ss.formula.ptg.AbstractFunctionPtg;
import ai2.org.apache.poi.ss.formula.ptg.AddPtg;
import ai2.org.apache.poi.ss.formula.ptg.ConcatPtg;
import ai2.org.apache.poi.ss.formula.ptg.DividePtg;
import ai2.org.apache.poi.ss.formula.ptg.EqualPtg;
import ai2.org.apache.poi.ss.formula.ptg.GreaterEqualPtg;
import ai2.org.apache.poi.ss.formula.ptg.GreaterThanPtg;
import ai2.org.apache.poi.ss.formula.ptg.IntersectionPtg;
import ai2.org.apache.poi.ss.formula.ptg.LessEqualPtg;
import ai2.org.apache.poi.ss.formula.ptg.LessThanPtg;
import ai2.org.apache.poi.ss.formula.ptg.MultiplyPtg;
import ai2.org.apache.poi.ss.formula.ptg.NotEqualPtg;
import ai2.org.apache.poi.ss.formula.ptg.OperationPtg;
import ai2.org.apache.poi.ss.formula.ptg.PercentPtg;
import ai2.org.apache.poi.ss.formula.ptg.PowerPtg;
import ai2.org.apache.poi.ss.formula.ptg.RangePtg;
import ai2.org.apache.poi.ss.formula.ptg.SubtractPtg;
import ai2.org.apache.poi.ss.formula.ptg.UnaryMinusPtg;
import ai2.org.apache.poi.ss.formula.ptg.UnaryPlusPtg;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class OperationEvaluatorFactory {
    private static final Map<OperationPtg, Function> _instancesByPtgClass = OperationEvaluatorFactory.initialiseInstancesMap();

    private OperationEvaluatorFactory() {
    }

    private static Map<OperationPtg, Function> initialiseInstancesMap() {
        HashMap<OperationPtg, Function> hashMap = new HashMap<OperationPtg, Function>(32);
        OperationEvaluatorFactory.put(hashMap, EqualPtg.instance, RelationalOperationEval.EqualEval);
        OperationEvaluatorFactory.put(hashMap, GreaterEqualPtg.instance, RelationalOperationEval.GreaterEqualEval);
        OperationEvaluatorFactory.put(hashMap, GreaterThanPtg.instance, RelationalOperationEval.GreaterThanEval);
        OperationEvaluatorFactory.put(hashMap, LessEqualPtg.instance, RelationalOperationEval.LessEqualEval);
        OperationEvaluatorFactory.put(hashMap, LessThanPtg.instance, RelationalOperationEval.LessThanEval);
        OperationEvaluatorFactory.put(hashMap, NotEqualPtg.instance, RelationalOperationEval.NotEqualEval);
        OperationEvaluatorFactory.put(hashMap, ConcatPtg.instance, ConcatEval.instance);
        OperationEvaluatorFactory.put(hashMap, AddPtg.instance, TwoOperandNumericOperation.AddEval);
        OperationEvaluatorFactory.put(hashMap, DividePtg.instance, TwoOperandNumericOperation.DivideEval);
        OperationEvaluatorFactory.put(hashMap, MultiplyPtg.instance, TwoOperandNumericOperation.MultiplyEval);
        OperationEvaluatorFactory.put(hashMap, PercentPtg.instance, PercentEval.instance);
        OperationEvaluatorFactory.put(hashMap, PowerPtg.instance, TwoOperandNumericOperation.PowerEval);
        OperationEvaluatorFactory.put(hashMap, SubtractPtg.instance, TwoOperandNumericOperation.SubtractEval);
        OperationEvaluatorFactory.put(hashMap, UnaryMinusPtg.instance, UnaryMinusEval.instance);
        OperationEvaluatorFactory.put(hashMap, UnaryPlusPtg.instance, UnaryPlusEval.instance);
        OperationEvaluatorFactory.put(hashMap, RangePtg.instance, RangeEval.instance);
        OperationEvaluatorFactory.put(hashMap, IntersectionPtg.instance, IntersectionEval.instance);
        return hashMap;
    }

    private static void put(Map<OperationPtg, Function> map, OperationPtg operationPtg, Function function) {
        Constructor<?>[] constructorArray = operationPtg.getClass().getDeclaredConstructors();
        if (constructorArray.length > 1 || !Modifier.isPrivate(constructorArray[0].getModifiers())) {
            throw new RuntimeException("Failed to verify instance (" + operationPtg.getClass().getName() + ") is a singleton.");
        }
        map.put(operationPtg, function);
    }

    public static ValueEval evaluate(OperationPtg operationPtg, ValueEval[] valueEvalArray, OperationEvaluationContext operationEvaluationContext) {
        if (operationPtg == null) {
            throw new IllegalArgumentException("ptg must not be null");
        }
        Function function = _instancesByPtgClass.get(operationPtg);
        if (function != null) {
            return function.evaluate(valueEvalArray, operationEvaluationContext.getRowIndex(), (short)operationEvaluationContext.getColumnIndex());
        }
        if (operationPtg instanceof AbstractFunctionPtg) {
            AbstractFunctionPtg abstractFunctionPtg = (AbstractFunctionPtg)operationPtg;
            short s = abstractFunctionPtg.getFunctionIndex();
            switch (s) {
                case 148: {
                    return Indirect.instance.evaluate(valueEvalArray, operationEvaluationContext);
                }
                case 255: {
                    return UserDefinedFunction.instance.evaluate(valueEvalArray, operationEvaluationContext);
                }
            }
            return FunctionEval.getBasicFunction(s).evaluate(valueEvalArray, operationEvaluationContext.getRowIndex(), (short)operationEvaluationContext.getColumnIndex());
        }
        throw new RuntimeException("Unexpected operation ptg class (" + operationPtg.getClass().getName() + ")");
    }
}

