/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula;

import ai2.org.apache.poi.ss.SpreadsheetVersion;
import ai2.org.apache.poi.ss.formula.EvaluationName;
import ai2.org.apache.poi.ss.formula.ExternSheetReferenceToken;
import ai2.org.apache.poi.ss.formula.FormulaParseException;
import ai2.org.apache.poi.ss.formula.FormulaParsingWorkbook;
import ai2.org.apache.poi.ss.formula.NameIdentifier;
import ai2.org.apache.poi.ss.formula.OperandClassTransformer;
import ai2.org.apache.poi.ss.formula.ParseNode;
import ai2.org.apache.poi.ss.formula.SheetIdentifier;
import ai2.org.apache.poi.ss.formula.SheetRangeIdentifier;
import ai2.org.apache.poi.ss.formula.constant.ErrorConstant;
import ai2.org.apache.poi.ss.formula.function.FunctionMetadata;
import ai2.org.apache.poi.ss.formula.function.FunctionMetadataRegistry;
import ai2.org.apache.poi.ss.formula.ptg.AbstractFunctionPtg;
import ai2.org.apache.poi.ss.formula.ptg.AddPtg;
import ai2.org.apache.poi.ss.formula.ptg.AreaPtg;
import ai2.org.apache.poi.ss.formula.ptg.ArrayPtg;
import ai2.org.apache.poi.ss.formula.ptg.AttrPtg;
import ai2.org.apache.poi.ss.formula.ptg.BoolPtg;
import ai2.org.apache.poi.ss.formula.ptg.ConcatPtg;
import ai2.org.apache.poi.ss.formula.ptg.DividePtg;
import ai2.org.apache.poi.ss.formula.ptg.EqualPtg;
import ai2.org.apache.poi.ss.formula.ptg.ErrPtg;
import ai2.org.apache.poi.ss.formula.ptg.FuncPtg;
import ai2.org.apache.poi.ss.formula.ptg.FuncVarPtg;
import ai2.org.apache.poi.ss.formula.ptg.GreaterEqualPtg;
import ai2.org.apache.poi.ss.formula.ptg.GreaterThanPtg;
import ai2.org.apache.poi.ss.formula.ptg.IntPtg;
import ai2.org.apache.poi.ss.formula.ptg.IntersectionPtg;
import ai2.org.apache.poi.ss.formula.ptg.LessEqualPtg;
import ai2.org.apache.poi.ss.formula.ptg.LessThanPtg;
import ai2.org.apache.poi.ss.formula.ptg.MemAreaPtg;
import ai2.org.apache.poi.ss.formula.ptg.MemFuncPtg;
import ai2.org.apache.poi.ss.formula.ptg.MissingArgPtg;
import ai2.org.apache.poi.ss.formula.ptg.MultiplyPtg;
import ai2.org.apache.poi.ss.formula.ptg.NamePtg;
import ai2.org.apache.poi.ss.formula.ptg.NameXPtg;
import ai2.org.apache.poi.ss.formula.ptg.NotEqualPtg;
import ai2.org.apache.poi.ss.formula.ptg.NumberPtg;
import ai2.org.apache.poi.ss.formula.ptg.OperandPtg;
import ai2.org.apache.poi.ss.formula.ptg.OperationPtg;
import ai2.org.apache.poi.ss.formula.ptg.ParenthesisPtg;
import ai2.org.apache.poi.ss.formula.ptg.PercentPtg;
import ai2.org.apache.poi.ss.formula.ptg.PowerPtg;
import ai2.org.apache.poi.ss.formula.ptg.Ptg;
import ai2.org.apache.poi.ss.formula.ptg.RangePtg;
import ai2.org.apache.poi.ss.formula.ptg.RefPtg;
import ai2.org.apache.poi.ss.formula.ptg.StringPtg;
import ai2.org.apache.poi.ss.formula.ptg.SubtractPtg;
import ai2.org.apache.poi.ss.formula.ptg.UnaryMinusPtg;
import ai2.org.apache.poi.ss.formula.ptg.UnaryPlusPtg;
import ai2.org.apache.poi.ss.formula.ptg.UnionPtg;
import ai2.org.apache.poi.ss.formula.ptg.ValueOperatorPtg;
import ai2.org.apache.poi.ss.util.AreaReference;
import ai2.org.apache.poi.ss.util.CellReference;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Pattern;

public final class FormulaParser {
    private final String _formulaString;
    private final int _formulaLength;
    private int _pointer;
    private ParseNode _rootNode;
    private static final char TAB = '\t';
    private static final char CR = '\r';
    private static final char LF = '\n';
    private char look;
    private boolean _inIntersection = false;
    private FormulaParsingWorkbook _book;
    private SpreadsheetVersion _ssVersion;
    private int _sheetIndex;
    private static final Pattern CELL_REF_PATTERN = Pattern.compile("(\\$?[A-Za-z]+)?(\\$?[0-9]+)?");

    private FormulaParser(String string, FormulaParsingWorkbook formulaParsingWorkbook, int n) {
        this._formulaString = string;
        this._pointer = 0;
        this._book = formulaParsingWorkbook;
        this._ssVersion = formulaParsingWorkbook == null ? SpreadsheetVersion.EXCEL97 : formulaParsingWorkbook.getSpreadsheetVersion();
        this._formulaLength = this._formulaString.length();
        this._sheetIndex = n;
    }

    public static Ptg[] parse(String string, FormulaParsingWorkbook formulaParsingWorkbook, int n, int n2) {
        FormulaParser formulaParser = new FormulaParser(string, formulaParsingWorkbook, n2);
        formulaParser.parse();
        return formulaParser.getRPNPtg(n);
    }

    private void GetChar() {
        if (FormulaParser.IsWhite(this.look)) {
            if (this.look == ' ') {
                this._inIntersection = true;
            }
        } else {
            this._inIntersection = false;
        }
        if (this._pointer > this._formulaLength) {
            throw new RuntimeException("too far");
        }
        if (this._pointer < this._formulaLength) {
            this.look = this._formulaString.charAt(this._pointer);
        } else {
            this.look = '\u0000';
            this._inIntersection = false;
        }
        ++this._pointer;
    }

    private void resetPointer(int n) {
        this._pointer = n;
        this.look = this._pointer <= this._formulaLength ? this._formulaString.charAt(this._pointer - 1) : (char)'\u0000';
    }

    private RuntimeException expected(String string) {
        String string2 = this.look == '=' && this._formulaString.substring(0, this._pointer - 1).trim().length() < 1 ? "The specified formula '" + this._formulaString + "' starts with an equals sign which is not allowed." : "Parse error near char " + (this._pointer - 1) + " '" + this.look + "'" + " in specified formula '" + this._formulaString + "'. Expected " + string;
        return new FormulaParseException(string2);
    }

    private static boolean IsAlpha(char c) {
        return Character.isLetter(c) || c == '$' || c == '_';
    }

    private static boolean IsDigit(char c) {
        return Character.isDigit(c);
    }

    private static boolean IsWhite(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    private void SkipWhite() {
        while (FormulaParser.IsWhite(this.look)) {
            this.GetChar();
        }
    }

    private void Match(char c) {
        if (this.look != c) {
            throw this.expected("'" + c + "'");
        }
        this.GetChar();
    }

    private String GetNum() {
        StringBuffer stringBuffer = new StringBuffer();
        while (FormulaParser.IsDigit(this.look)) {
            stringBuffer.append(this.look);
            this.GetChar();
        }
        return stringBuffer.length() == 0 ? null : stringBuffer.toString();
    }

    private ParseNode parseRangeExpression() {
        ParseNode parseNode = this.parseRangeable();
        boolean bl = false;
        while (this.look == ':') {
            int n = this._pointer;
            this.GetChar();
            ParseNode parseNode2 = this.parseRangeable();
            FormulaParser.checkValidRangeOperand("LHS", n, parseNode);
            FormulaParser.checkValidRangeOperand("RHS", n, parseNode2);
            ParseNode[] parseNodeArray = new ParseNode[]{parseNode, parseNode2};
            parseNode = new ParseNode((Ptg)RangePtg.instance, parseNodeArray);
            bl = true;
        }
        if (bl) {
            return FormulaParser.augmentWithMemPtg(parseNode);
        }
        return parseNode;
    }

    private static ParseNode augmentWithMemPtg(ParseNode parseNode) {
        OperandPtg operandPtg = FormulaParser.needsMemFunc(parseNode) ? new MemFuncPtg(parseNode.getEncodedSize()) : new MemAreaPtg(parseNode.getEncodedSize());
        return new ParseNode((Ptg)operandPtg, parseNode);
    }

    private static boolean needsMemFunc(ParseNode parseNode) {
        Ptg ptg = parseNode.getToken();
        if (ptg instanceof AbstractFunctionPtg) {
            return true;
        }
        if (ptg instanceof ExternSheetReferenceToken) {
            return true;
        }
        if (ptg instanceof NamePtg || ptg instanceof NameXPtg) {
            return true;
        }
        if (ptg instanceof OperationPtg || ptg instanceof ParenthesisPtg) {
            for (ParseNode parseNode2 : parseNode.getChildren()) {
                if (!FormulaParser.needsMemFunc(parseNode2)) continue;
                return true;
            }
            return false;
        }
        if (ptg instanceof OperandPtg) {
            return false;
        }
        return ptg instanceof OperationPtg;
    }

    private static void checkValidRangeOperand(String string, int n, ParseNode parseNode) {
        if (!FormulaParser.isValidRangeOperand(parseNode)) {
            throw new FormulaParseException("The " + string + " of the range operator ':' at position " + n + " is not a proper reference.");
        }
    }

    private static boolean isValidRangeOperand(ParseNode parseNode) {
        Ptg ptg = parseNode.getToken();
        if (ptg instanceof OperandPtg) {
            return true;
        }
        if (ptg instanceof AbstractFunctionPtg) {
            AbstractFunctionPtg abstractFunctionPtg = (AbstractFunctionPtg)ptg;
            byte by = abstractFunctionPtg.getDefaultOperandClass();
            return 0 == by;
        }
        if (ptg instanceof ValueOperatorPtg) {
            return false;
        }
        if (ptg instanceof OperationPtg) {
            return true;
        }
        if (ptg instanceof ParenthesisPtg) {
            return FormulaParser.isValidRangeOperand(parseNode.getChildren()[0]);
        }
        return ptg == ErrPtg.REF_INVALID;
    }

    private ParseNode parseRangeable() {
        this.SkipWhite();
        int n = this._pointer;
        SheetIdentifier sheetIdentifier = this.parseSheetName();
        if (sheetIdentifier == null) {
            this.resetPointer(n);
        } else {
            this.SkipWhite();
            n = this._pointer;
        }
        SimpleRangePart simpleRangePart = this.parseSimpleRangePart();
        if (simpleRangePart == null) {
            if (sheetIdentifier != null) {
                if (this.look == '#') {
                    return new ParseNode(ErrPtg.valueOf(this.parseErrorLiteral()));
                }
                String string = this.parseAsName();
                if (string.length() == 0) {
                    throw new FormulaParseException("Cell reference or Named Range expected after sheet name at index " + this._pointer + ".");
                }
                Ptg ptg = this._book.getNameXPtg(string, sheetIdentifier);
                if (ptg == null) {
                    throw new FormulaParseException("Specified name '" + string + "' for sheet " + sheetIdentifier.asFormulaString() + " not found");
                }
                return new ParseNode(ptg);
            }
            return this.parseNonRange(n);
        }
        boolean bl = FormulaParser.IsWhite(this.look);
        if (bl) {
            this.SkipWhite();
        }
        if (this.look == ':') {
            int n2 = this._pointer;
            this.GetChar();
            this.SkipWhite();
            SimpleRangePart simpleRangePart2 = this.parseSimpleRangePart();
            if (simpleRangePart2 != null && !simpleRangePart.isCompatibleForArea(simpleRangePart2)) {
                simpleRangePart2 = null;
            }
            if (simpleRangePart2 == null) {
                this.resetPointer(n2);
                if (!simpleRangePart.isCell()) {
                    String string = sheetIdentifier == null ? "" : "'" + sheetIdentifier.getSheetIdentifier().getName() + '!';
                    throw new FormulaParseException(string + simpleRangePart.getRep() + "' is not a proper reference.");
                }
                return this.createAreaRefParseNode(sheetIdentifier, simpleRangePart, simpleRangePart2);
            }
            return this.createAreaRefParseNode(sheetIdentifier, simpleRangePart, simpleRangePart2);
        }
        if (this.look == '.') {
            this.GetChar();
            int n3 = 1;
            while (this.look == '.') {
                ++n3;
                this.GetChar();
            }
            boolean bl2 = FormulaParser.IsWhite(this.look);
            this.SkipWhite();
            SimpleRangePart simpleRangePart3 = this.parseSimpleRangePart();
            String string = this._formulaString.substring(n - 1, this._pointer - 1);
            if (simpleRangePart3 == null) {
                if (sheetIdentifier != null) {
                    throw new FormulaParseException("Complete area reference expected after sheet name at index " + this._pointer + ".");
                }
                return this.parseNonRange(n);
            }
            if (bl || bl2) {
                if (simpleRangePart.isRowOrColumn() || simpleRangePart3.isRowOrColumn()) {
                    throw new FormulaParseException("Dotted range (full row or column) expression '" + string + "' must not contain whitespace.");
                }
                return this.createAreaRefParseNode(sheetIdentifier, simpleRangePart, simpleRangePart3);
            }
            if (n3 == 1 && simpleRangePart.isRow() && simpleRangePart3.isRow()) {
                return this.parseNonRange(n);
            }
            if ((simpleRangePart.isRowOrColumn() || simpleRangePart3.isRowOrColumn()) && n3 != 2) {
                throw new FormulaParseException("Dotted range (full row or column) expression '" + string + "' must have exactly 2 dots.");
            }
            return this.createAreaRefParseNode(sheetIdentifier, simpleRangePart, simpleRangePart3);
        }
        if (simpleRangePart.isCell() && this.isValidCellReference(simpleRangePart.getRep())) {
            return this.createAreaRefParseNode(sheetIdentifier, simpleRangePart, null);
        }
        if (sheetIdentifier != null) {
            throw new FormulaParseException("Second part of cell reference expected after sheet name at index " + this._pointer + ".");
        }
        return this.parseNonRange(n);
    }

    private ParseNode parseNonRange(int n) {
        this.resetPointer(n);
        if (Character.isDigit(this.look)) {
            return new ParseNode(this.parseNumber());
        }
        if (this.look == '\"') {
            return new ParseNode(new StringPtg(this.parseStringLiteral()));
        }
        String string = this.parseAsName();
        if (this.look == '(') {
            return this.function(string);
        }
        if (string.equalsIgnoreCase("TRUE") || string.equalsIgnoreCase("FALSE")) {
            return new ParseNode(BoolPtg.valueOf(string.equalsIgnoreCase("TRUE")));
        }
        if (this._book == null) {
            throw new IllegalStateException("Need book to evaluate name '" + string + "'");
        }
        EvaluationName evaluationName = this._book.getName(string, this._sheetIndex);
        if (evaluationName == null) {
            throw new FormulaParseException("Specified named range '" + string + "' does not exist in the current workbook.");
        }
        if (evaluationName.isRange()) {
            return new ParseNode(evaluationName.createPtg());
        }
        throw new FormulaParseException("Specified name '" + string + "' is not a range as expected.");
    }

    private String parseAsName() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!Character.isLetter(this.look) && this.look != '_') {
            throw this.expected("number, string, or defined name");
        }
        while (FormulaParser.isValidDefinedNameChar(this.look)) {
            stringBuilder.append(this.look);
            this.GetChar();
        }
        this.SkipWhite();
        return stringBuilder.toString();
    }

    private static boolean isValidDefinedNameChar(char c) {
        if (Character.isLetterOrDigit(c)) {
            return true;
        }
        switch (c) {
            case '.': 
            case '?': 
            case '\\': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    private ParseNode createAreaRefParseNode(SheetIdentifier sheetIdentifier, SimpleRangePart simpleRangePart, SimpleRangePart simpleRangePart2) throws FormulaParseException {
        Ptg ptg;
        if (simpleRangePart2 == null) {
            CellReference cellReference = simpleRangePart.getCellReference();
            ptg = sheetIdentifier == null ? new RefPtg(cellReference) : this._book.get3DReferencePtg(cellReference, sheetIdentifier);
        } else {
            AreaReference areaReference = this.createAreaRef(simpleRangePart, simpleRangePart2);
            ptg = sheetIdentifier == null ? new AreaPtg(areaReference) : this._book.get3DReferencePtg(areaReference, sheetIdentifier);
        }
        return new ParseNode(ptg);
    }

    private AreaReference createAreaRef(SimpleRangePart simpleRangePart, SimpleRangePart simpleRangePart2) {
        if (!simpleRangePart.isCompatibleForArea(simpleRangePart2)) {
            throw new FormulaParseException("has incompatible parts: '" + simpleRangePart.getRep() + "' and '" + simpleRangePart2.getRep() + "'.");
        }
        if (simpleRangePart.isRow()) {
            return AreaReference.getWholeRow(this._ssVersion, simpleRangePart.getRep(), simpleRangePart2.getRep());
        }
        if (simpleRangePart.isColumn()) {
            return AreaReference.getWholeColumn(this._ssVersion, simpleRangePart.getRep(), simpleRangePart2.getRep());
        }
        return new AreaReference(simpleRangePart.getCellReference(), simpleRangePart2.getCellReference());
    }

    private SimpleRangePart parseSimpleRangePart() {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        for (n = this._pointer - 1; n < this._formulaLength; ++n) {
            char c = this._formulaString.charAt(n);
            if (Character.isDigit(c)) {
                bl = true;
                continue;
            }
            if (Character.isLetter(c)) {
                bl2 = true;
                continue;
            }
            if (c != '$' && c != '_') break;
        }
        if (n <= this._pointer - 1) {
            return null;
        }
        String string = this._formulaString.substring(this._pointer - 1, n);
        if (!CELL_REF_PATTERN.matcher(string).matches()) {
            return null;
        }
        if (bl2 && bl) {
            if (!this.isValidCellReference(string)) {
                return null;
            }
        } else if (bl2) {
            if (!CellReference.isColumnWithnRange(string.replace("$", ""), this._ssVersion)) {
                return null;
            }
        } else if (bl) {
            int n2;
            try {
                n2 = Integer.parseInt(string.replace("$", ""));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            if (n2 < 1 || n2 > this._ssVersion.getMaxRows()) {
                return null;
            }
        } else {
            return null;
        }
        this.resetPointer(n + 1);
        return new SimpleRangePart(string, bl2, bl);
    }

    private SheetIdentifier parseSheetName() {
        String string;
        AbstractStringBuilder abstractStringBuilder;
        if (this.look == '[') {
            abstractStringBuilder = new StringBuilder();
            this.GetChar();
            while (this.look != ']') {
                ((StringBuilder)abstractStringBuilder).append(this.look);
                this.GetChar();
            }
            this.GetChar();
            string = ((StringBuilder)abstractStringBuilder).toString();
        } else {
            string = null;
        }
        if (this.look == '\'') {
            boolean bl;
            abstractStringBuilder = new StringBuffer();
            this.Match('\'');
            boolean bl2 = bl = this.look == '\'';
            while (!bl) {
                ((StringBuffer)abstractStringBuilder).append(this.look);
                this.GetChar();
                if (this.look != '\'') continue;
                this.Match('\'');
                bl = this.look != '\'';
            }
            NameIdentifier nameIdentifier = new NameIdentifier(((StringBuffer)abstractStringBuilder).toString(), true);
            this.SkipWhite();
            if (this.look == '!') {
                this.GetChar();
                return new SheetIdentifier(string, nameIdentifier);
            }
            if (this.look == ':') {
                return this.parseSheetRange(string, nameIdentifier);
            }
            return null;
        }
        if (this.look == '_' || Character.isLetter(this.look)) {
            abstractStringBuilder = new StringBuilder();
            while (FormulaParser.isUnquotedSheetNameChar(this.look)) {
                ((StringBuilder)abstractStringBuilder).append(this.look);
                this.GetChar();
            }
            NameIdentifier nameIdentifier = new NameIdentifier(((StringBuilder)abstractStringBuilder).toString(), false);
            this.SkipWhite();
            if (this.look == '!') {
                this.GetChar();
                return new SheetIdentifier(string, nameIdentifier);
            }
            if (this.look == ':') {
                return this.parseSheetRange(string, nameIdentifier);
            }
            return null;
        }
        if (this.look == '!' && string != null) {
            this.GetChar();
            return new SheetIdentifier(string, null);
        }
        return null;
    }

    private SheetIdentifier parseSheetRange(String string, NameIdentifier nameIdentifier) {
        this.GetChar();
        SheetIdentifier sheetIdentifier = this.parseSheetName();
        if (sheetIdentifier != null) {
            return new SheetRangeIdentifier(string, nameIdentifier, sheetIdentifier.getSheetIdentifier());
        }
        return null;
    }

    private static boolean isUnquotedSheetNameChar(char c) {
        if (Character.isLetterOrDigit(c)) {
            return true;
        }
        switch (c) {
            case '.': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    private boolean isValidCellReference(String string) {
        boolean bl;
        boolean bl2 = bl = CellReference.classifyCellReference(string, this._ssVersion) == CellReference.NameType.CELL;
        if (bl) {
            boolean bl3;
            boolean bl4 = bl3 = FunctionMetadataRegistry.getFunctionByName(string.toUpperCase(Locale.ROOT)) != null;
            if (bl3) {
                int n = this._pointer;
                this.resetPointer(this._pointer + string.length());
                this.SkipWhite();
                bl = this.look != '(';
                this.resetPointer(n);
            }
        }
        return bl;
    }

    private ParseNode function(String string) {
        Object object;
        Ptg ptg = null;
        if (!AbstractFunctionPtg.isBuiltInFunctionName(string)) {
            if (this._book == null) {
                throw new IllegalStateException("Need book to evaluate name '" + string + "'");
            }
            object = this._book.getName(string, this._sheetIndex);
            if (object == null) {
                ptg = this._book.getNameXPtg(string, null);
                if (ptg == null) {
                    throw new FormulaParseException("Name '" + string + "' is completely unknown in the current workbook");
                }
            } else {
                if (!object.isFunctionName()) {
                    throw new FormulaParseException("Attempt to use name '" + string + "' as a function, but defined name in workbook does not refer to a function");
                }
                ptg = object.createPtg();
            }
        }
        this.Match('(');
        object = this.Arguments();
        this.Match(')');
        return this.getFunction(string, ptg, (ParseNode[])object);
    }

    private ParseNode getFunction(String string, Ptg ptg, ParseNode[] parseNodeArray) {
        FunctionMetadata functionMetadata = FunctionMetadataRegistry.getFunctionByName(string.toUpperCase(Locale.ROOT));
        int n = parseNodeArray.length;
        if (functionMetadata == null) {
            if (ptg == null) {
                throw new IllegalStateException("NamePtg must be supplied for external functions");
            }
            ParseNode[] parseNodeArray2 = new ParseNode[n + 1];
            parseNodeArray2[0] = new ParseNode(ptg);
            System.arraycopy(parseNodeArray, 0, parseNodeArray2, 1, n);
            return new ParseNode((Ptg)FuncVarPtg.create(string, n + 1), parseNodeArray2);
        }
        if (ptg != null) {
            throw new IllegalStateException("NamePtg no applicable to internal functions");
        }
        boolean bl = !functionMetadata.hasFixedArgsLength();
        int n2 = functionMetadata.getIndex();
        if (n2 == 4 && parseNodeArray.length == 1) {
            return new ParseNode((Ptg)AttrPtg.getSumSingle(), parseNodeArray);
        }
        this.validateNumArgs(parseNodeArray.length, functionMetadata);
        AbstractFunctionPtg abstractFunctionPtg = bl ? FuncVarPtg.create(string, n) : FuncPtg.create(n2);
        return new ParseNode((Ptg)abstractFunctionPtg, parseNodeArray);
    }

    private void validateNumArgs(int n, FunctionMetadata functionMetadata) {
        if (n < functionMetadata.getMinParams()) {
            String string = "Too few arguments to function '" + functionMetadata.getName() + "'. ";
            string = functionMetadata.hasFixedArgsLength() ? string + "Expected " + functionMetadata.getMinParams() : string + "At least " + functionMetadata.getMinParams() + " were expected";
            string = string + " but got " + n + ".";
            throw new FormulaParseException(string);
        }
        int n2 = functionMetadata.hasUnlimitedVarags() ? (this._book != null ? this._book.getSpreadsheetVersion().getMaxFunctionArgs() : functionMetadata.getMaxParams()) : functionMetadata.getMaxParams();
        if (n > n2) {
            String string = "Too many arguments to function '" + functionMetadata.getName() + "'. ";
            string = functionMetadata.hasFixedArgsLength() ? string + "Expected " + n2 : string + "At most " + n2 + " were expected";
            string = string + " but got " + n + ".";
            throw new FormulaParseException(string);
        }
    }

    private static boolean isArgumentDelimiter(char c) {
        return c == ',' || c == ')';
    }

    private ParseNode[] Arguments() {
        ArrayList<ParseNode> arrayList;
        block5: {
            arrayList = new ArrayList<ParseNode>(2);
            this.SkipWhite();
            if (this.look == ')') {
                return ParseNode.EMPTY_ARRAY;
            }
            boolean bl = true;
            while (true) {
                this.SkipWhite();
                if (FormulaParser.isArgumentDelimiter(this.look)) {
                    if (bl) {
                        arrayList.add(new ParseNode(MissingArgPtg.instance));
                    }
                    if (this.look != ')') {
                        this.Match(',');
                        bl = true;
                        continue;
                    }
                    break block5;
                }
                arrayList.add(this.comparisonExpression());
                bl = false;
                this.SkipWhite();
                if (!FormulaParser.isArgumentDelimiter(this.look)) break;
            }
            throw this.expected("',' or ')'");
        }
        ParseNode[] parseNodeArray = new ParseNode[arrayList.size()];
        arrayList.toArray(parseNodeArray);
        return parseNodeArray;
    }

    private ParseNode powerFactor() {
        ParseNode parseNode = this.percentFactor();
        while (true) {
            this.SkipWhite();
            if (this.look != '^') {
                return parseNode;
            }
            this.Match('^');
            ParseNode parseNode2 = this.percentFactor();
            parseNode = new ParseNode(PowerPtg.instance, parseNode, parseNode2);
        }
    }

    private ParseNode percentFactor() {
        ParseNode parseNode = this.parseSimpleFactor();
        while (true) {
            this.SkipWhite();
            if (this.look != '%') {
                return parseNode;
            }
            this.Match('%');
            parseNode = new ParseNode((Ptg)PercentPtg.instance, parseNode);
        }
    }

    private ParseNode parseSimpleFactor() {
        this.SkipWhite();
        switch (this.look) {
            case '#': {
                return new ParseNode(ErrPtg.valueOf(this.parseErrorLiteral()));
            }
            case '-': {
                this.Match('-');
                return this.parseUnary(false);
            }
            case '+': {
                this.Match('+');
                return this.parseUnary(true);
            }
            case '(': {
                this.Match('(');
                ParseNode parseNode = this.unionExpression();
                this.Match(')');
                return new ParseNode((Ptg)ParenthesisPtg.instance, parseNode);
            }
            case '\"': {
                return new ParseNode(new StringPtg(this.parseStringLiteral()));
            }
            case '{': {
                this.Match('{');
                ParseNode parseNode = this.parseArray();
                this.Match('}');
                return parseNode;
            }
        }
        if (FormulaParser.IsAlpha(this.look) || Character.isDigit(this.look) || this.look == '\'' || this.look == '[') {
            return this.parseRangeExpression();
        }
        if (this.look == '.') {
            return new ParseNode(this.parseNumber());
        }
        throw this.expected("cell ref or constant literal");
    }

    private ParseNode parseUnary(boolean bl) {
        boolean bl2 = FormulaParser.IsDigit(this.look) || this.look == '.';
        ParseNode parseNode = this.powerFactor();
        if (bl2) {
            Ptg ptg = parseNode.getToken();
            if (ptg instanceof NumberPtg) {
                if (bl) {
                    return parseNode;
                }
                ptg = new NumberPtg(-((NumberPtg)ptg).getValue());
                return new ParseNode(ptg);
            }
            if (ptg instanceof IntPtg) {
                if (bl) {
                    return parseNode;
                }
                int n = ((IntPtg)ptg).getValue();
                ptg = new NumberPtg(-n);
                return new ParseNode(ptg);
            }
        }
        return new ParseNode((Ptg)(bl ? UnaryPlusPtg.instance : UnaryMinusPtg.instance), parseNode);
    }

    private ParseNode parseArray() {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        while (true) {
            Object[] objectArray = this.parseArrayRow();
            arrayList.add(objectArray);
            if (this.look == '}') break;
            if (this.look != ';') {
                throw this.expected("'}' or ';'");
            }
            this.Match(';');
        }
        int n = arrayList.size();
        Object[][] objectArray = new Object[n][];
        arrayList.toArray((T[])objectArray);
        int n2 = objectArray[0].length;
        this.checkRowLengths(objectArray, n2);
        return new ParseNode(new ArrayPtg(objectArray));
    }

    private void checkRowLengths(Object[][] objectArray, int n) {
        for (int i = 0; i < objectArray.length; ++i) {
            int n2 = objectArray[i].length;
            if (n2 == n) continue;
            throw new FormulaParseException("Array row " + i + " has length " + n2 + " but row 0 has length " + n);
        }
    }

    private Object[] parseArrayRow() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        block4: while (true) {
            arrayList.add(this.parseArrayItem());
            this.SkipWhite();
            switch (this.look) {
                case ';': 
                case '}': {
                    break block4;
                }
                case ',': {
                    this.Match(',');
                    continue block4;
                }
                default: {
                    throw this.expected("'}' or ','");
                }
            }
            break;
        }
        Object[] objectArray = new Object[arrayList.size()];
        arrayList.toArray(objectArray);
        return objectArray;
    }

    private Object parseArrayItem() {
        this.SkipWhite();
        switch (this.look) {
            case '\"': {
                return this.parseStringLiteral();
            }
            case '#': {
                return ErrorConstant.valueOf(this.parseErrorLiteral());
            }
            case 'F': 
            case 'T': 
            case 'f': 
            case 't': {
                return this.parseBooleanLiteral();
            }
            case '-': {
                this.Match('-');
                this.SkipWhite();
                return FormulaParser.convertArrayNumber(this.parseNumber(), false);
            }
        }
        return FormulaParser.convertArrayNumber(this.parseNumber(), true);
    }

    private Boolean parseBooleanLiteral() {
        String string = this.parseUnquotedIdentifier();
        if ("TRUE".equalsIgnoreCase(string)) {
            return Boolean.TRUE;
        }
        if ("FALSE".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        throw this.expected("'TRUE' or 'FALSE'");
    }

    private static Double convertArrayNumber(Ptg ptg, boolean bl) {
        double d;
        if (ptg instanceof IntPtg) {
            d = ((IntPtg)ptg).getValue();
        } else if (ptg instanceof NumberPtg) {
            d = ((NumberPtg)ptg).getValue();
        } else {
            throw new RuntimeException("Unexpected ptg (" + ptg.getClass().getName() + ")");
        }
        if (!bl) {
            d = -d;
        }
        return new Double(d);
    }

    private Ptg parseNumber() {
        String string = null;
        String string2 = null;
        String string3 = this.GetNum();
        if (this.look == '.') {
            this.GetChar();
            string = this.GetNum();
        }
        if (this.look == 'E') {
            this.GetChar();
            String string4 = "";
            if (this.look == '+') {
                this.GetChar();
            } else if (this.look == '-') {
                this.GetChar();
                string4 = "-";
            }
            String string5 = this.GetNum();
            if (string5 == null) {
                throw this.expected("Integer");
            }
            string2 = string4 + string5;
        }
        if (string3 == null && string == null) {
            throw this.expected("Integer");
        }
        return FormulaParser.getNumberPtgFromString(string3, string, string2);
    }

    private int parseErrorLiteral() {
        this.Match('#');
        String string = this.parseUnquotedIdentifier().toUpperCase(Locale.ROOT);
        if (string == null) {
            throw this.expected("remainder of error constant literal");
        }
        switch (string.charAt(0)) {
            case 'V': {
                if (string.equals("VALUE")) {
                    this.Match('!');
                    return 15;
                }
                throw this.expected("#VALUE!");
            }
            case 'R': {
                if (string.equals("REF")) {
                    this.Match('!');
                    return 23;
                }
                throw this.expected("#REF!");
            }
            case 'D': {
                if (string.equals("DIV")) {
                    this.Match('/');
                    this.Match('0');
                    this.Match('!');
                    return 7;
                }
                throw this.expected("#DIV/0!");
            }
            case 'N': {
                if (string.equals("NAME")) {
                    this.Match('?');
                    return 29;
                }
                if (string.equals("NUM")) {
                    this.Match('!');
                    return 36;
                }
                if (string.equals("NULL")) {
                    this.Match('!');
                    return 0;
                }
                if (string.equals("N")) {
                    this.Match('/');
                    if (this.look != 'A' && this.look != 'a') {
                        throw this.expected("#N/A");
                    }
                    this.Match(this.look);
                    return 42;
                }
                throw this.expected("#NAME?, #NUM!, #NULL! or #N/A");
            }
        }
        throw this.expected("#VALUE!, #REF!, #DIV/0!, #NAME?, #NUM!, #NULL! or #N/A");
    }

    private String parseUnquotedIdentifier() {
        if (this.look == '\'') {
            throw this.expected("unquoted identifier");
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (Character.isLetterOrDigit(this.look) || this.look == '.') {
            stringBuilder.append(this.look);
            this.GetChar();
        }
        if (stringBuilder.length() < 1) {
            return null;
        }
        return stringBuilder.toString();
    }

    private static Ptg getNumberPtgFromString(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string2 == null) {
            int n;
            stringBuffer.append(string);
            if (string3 != null) {
                stringBuffer.append('E');
                stringBuffer.append(string3);
            }
            String string4 = stringBuffer.toString();
            try {
                n = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                return new NumberPtg(string4);
            }
            if (IntPtg.isInRange(n)) {
                return new IntPtg(n);
            }
            return new NumberPtg(string4);
        }
        if (string != null) {
            stringBuffer.append(string);
        }
        stringBuffer.append('.');
        stringBuffer.append(string2);
        if (string3 != null) {
            stringBuffer.append('E');
            stringBuffer.append(string3);
        }
        return new NumberPtg(stringBuffer.toString());
    }

    private String parseStringLiteral() {
        this.Match('\"');
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            if (this.look == '\"') {
                this.GetChar();
                if (this.look != '\"') break;
            }
            stringBuffer.append(this.look);
            this.GetChar();
        }
        return stringBuffer.toString();
    }

    private ParseNode Term() {
        ParseNode parseNode = this.powerFactor();
        while (true) {
            ValueOperatorPtg valueOperatorPtg;
            this.SkipWhite();
            switch (this.look) {
                case '*': {
                    this.Match('*');
                    valueOperatorPtg = MultiplyPtg.instance;
                    break;
                }
                case '/': {
                    this.Match('/');
                    valueOperatorPtg = DividePtg.instance;
                    break;
                }
                default: {
                    return parseNode;
                }
            }
            ParseNode parseNode2 = this.powerFactor();
            parseNode = new ParseNode(valueOperatorPtg, parseNode, parseNode2);
        }
    }

    private ParseNode unionExpression() {
        ParseNode parseNode = this.intersectionExpression();
        boolean bl = false;
        block3: while (true) {
            this.SkipWhite();
            switch (this.look) {
                case ',': {
                    this.GetChar();
                    bl = true;
                    ParseNode parseNode2 = this.intersectionExpression();
                    parseNode = new ParseNode(UnionPtg.instance, parseNode, parseNode2);
                    continue block3;
                }
            }
            break;
        }
        if (bl) {
            return FormulaParser.augmentWithMemPtg(parseNode);
        }
        return parseNode;
    }

    private ParseNode intersectionExpression() {
        ParseNode parseNode = this.comparisonExpression();
        boolean bl = false;
        while (true) {
            this.SkipWhite();
            if (!this._inIntersection) break;
            bl = true;
            ParseNode parseNode2 = this.comparisonExpression();
            parseNode = new ParseNode(IntersectionPtg.instance, parseNode, parseNode2);
        }
        if (bl) {
            return FormulaParser.augmentWithMemPtg(parseNode);
        }
        return parseNode;
    }

    private ParseNode comparisonExpression() {
        ParseNode parseNode = this.concatExpression();
        block3: while (true) {
            this.SkipWhite();
            switch (this.look) {
                case '<': 
                case '=': 
                case '>': {
                    Ptg ptg = this.getComparisonToken();
                    ParseNode parseNode2 = this.concatExpression();
                    parseNode = new ParseNode(ptg, parseNode, parseNode2);
                    continue block3;
                }
            }
            break;
        }
        return parseNode;
    }

    private Ptg getComparisonToken() {
        if (this.look == '=') {
            this.Match(this.look);
            return EqualPtg.instance;
        }
        boolean bl = this.look == '>';
        this.Match(this.look);
        if (bl) {
            if (this.look == '=') {
                this.Match('=');
                return GreaterEqualPtg.instance;
            }
            return GreaterThanPtg.instance;
        }
        switch (this.look) {
            case '=': {
                this.Match('=');
                return LessEqualPtg.instance;
            }
            case '>': {
                this.Match('>');
                return NotEqualPtg.instance;
            }
        }
        return LessThanPtg.instance;
    }

    private ParseNode concatExpression() {
        ParseNode parseNode = this.additiveExpression();
        while (true) {
            this.SkipWhite();
            if (this.look != '&') break;
            this.Match('&');
            ParseNode parseNode2 = this.additiveExpression();
            parseNode = new ParseNode(ConcatPtg.instance, parseNode, parseNode2);
        }
        return parseNode;
    }

    private ParseNode additiveExpression() {
        ParseNode parseNode = this.Term();
        while (true) {
            ValueOperatorPtg valueOperatorPtg;
            this.SkipWhite();
            switch (this.look) {
                case '+': {
                    this.Match('+');
                    valueOperatorPtg = AddPtg.instance;
                    break;
                }
                case '-': {
                    this.Match('-');
                    valueOperatorPtg = SubtractPtg.instance;
                    break;
                }
                default: {
                    return parseNode;
                }
            }
            ParseNode parseNode2 = this.Term();
            parseNode = new ParseNode(valueOperatorPtg, parseNode, parseNode2);
        }
    }

    private void parse() {
        this._pointer = 0;
        this.GetChar();
        this._rootNode = this.unionExpression();
        if (this._pointer <= this._formulaLength) {
            String string = "Unused input [" + this._formulaString.substring(this._pointer - 1) + "] after attempting to parse the formula [" + this._formulaString + "]";
            throw new FormulaParseException(string);
        }
    }

    private Ptg[] getRPNPtg(int n) {
        OperandClassTransformer operandClassTransformer = new OperandClassTransformer(n);
        operandClassTransformer.transformFormula(this._rootNode);
        return ParseNode.toTokenArray(this._rootNode);
    }

    private static final class SimpleRangePart {
        private final Type _type;
        private final String _rep;

        public SimpleRangePart(String string, boolean bl, boolean bl2) {
            this._rep = string;
            this._type = Type.get(bl, bl2);
        }

        public boolean isCell() {
            return this._type == Type.CELL;
        }

        public boolean isRowOrColumn() {
            return this._type != Type.CELL;
        }

        public CellReference getCellReference() {
            if (this._type != Type.CELL) {
                throw new IllegalStateException("Not applicable to this type");
            }
            return new CellReference(this._rep);
        }

        public boolean isColumn() {
            return this._type == Type.COLUMN;
        }

        public boolean isRow() {
            return this._type == Type.ROW;
        }

        public String getRep() {
            return this._rep;
        }

        public boolean isCompatibleForArea(SimpleRangePart simpleRangePart) {
            return this._type == simpleRangePart._type;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(64);
            stringBuilder.append(this.getClass().getName()).append(" [");
            stringBuilder.append(this._rep);
            stringBuilder.append("]");
            return stringBuilder.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum Type {
            CELL,
            ROW,
            COLUMN;


            public static Type get(boolean bl, boolean bl2) {
                if (bl) {
                    return bl2 ? CELL : COLUMN;
                }
                if (!bl2) {
                    throw new IllegalArgumentException("must have either letters or numbers");
                }
                return ROW;
            }
        }
    }
}

