/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula;

import ai2.org.apache.poi.ss.formula.ptg.Ptg;
import ai2.org.apache.poi.ss.util.CellReference;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.LittleEndianByteArrayInputStream;
import ai2.org.apache.poi.util.LittleEndianInput;
import ai2.org.apache.poi.util.LittleEndianOutput;
import java.util.Arrays;

public class Formula {
    private static final Formula EMPTY = new Formula(new byte[0], 0);
    private final byte[] _byteEncoding;
    private final int _encodedTokenLen;

    private Formula(byte[] byArray, int n) {
        this._byteEncoding = byArray;
        this._encodedTokenLen = n;
    }

    public static Formula read(int n, LittleEndianInput littleEndianInput) {
        return Formula.read(n, littleEndianInput, n);
    }

    public static Formula read(int n, LittleEndianInput littleEndianInput, int n2) {
        byte[] byArray = new byte[n2];
        littleEndianInput.readFully(byArray);
        return new Formula(byArray, n);
    }

    public Ptg[] getTokens() {
        LittleEndianByteArrayInputStream littleEndianByteArrayInputStream = new LittleEndianByteArrayInputStream(this._byteEncoding);
        return Ptg.readTokens(this._encodedTokenLen, littleEndianByteArrayInputStream);
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this._encodedTokenLen);
        littleEndianOutput.write(this._byteEncoding);
    }

    public void serializeTokens(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.write(this._byteEncoding, 0, this._encodedTokenLen);
    }

    public void serializeArrayConstantData(LittleEndianOutput littleEndianOutput) {
        int n = this._byteEncoding.length - this._encodedTokenLen;
        littleEndianOutput.write(this._byteEncoding, this._encodedTokenLen, n);
    }

    public int getEncodedSize() {
        return 2 + this._byteEncoding.length;
    }

    public int getEncodedTokenSize() {
        return this._encodedTokenLen;
    }

    public static Formula create(Ptg[] ptgArray) {
        if (ptgArray == null || ptgArray.length < 1) {
            return EMPTY;
        }
        int n = Ptg.getEncodedSize(ptgArray);
        byte[] byArray = new byte[n];
        Ptg.serializePtgs(ptgArray, byArray, 0);
        int n2 = Ptg.getEncodedSizeWithoutArrayData(ptgArray);
        return new Formula(byArray, n2);
    }

    public static Ptg[] getTokens(Formula formula) {
        if (formula == null) {
            return null;
        }
        return formula.getTokens();
    }

    public Formula copy() {
        return this;
    }

    public CellReference getExpReference() {
        byte[] byArray = this._byteEncoding;
        if (byArray.length != 5) {
            return null;
        }
        switch (byArray[0]) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                return null;
            }
        }
        int n = LittleEndian.getUShort(byArray, 1);
        int n2 = LittleEndian.getUShort(byArray, 3);
        return new CellReference(n, n2);
    }

    public boolean isSame(Formula formula) {
        return Arrays.equals(this._byteEncoding, formula._byteEncoding);
    }
}

