/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.format;

import ai2.org.apache.poi.ss.format.CellFormatter;
import ai2.org.apache.poi.util.LocaleUtil;
import java.util.Formatter;
import java.util.Locale;

public class CellGeneralFormatter
extends CellFormatter {
    public CellGeneralFormatter() {
        super("General");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void formatValue(StringBuffer stringBuffer, Object object) {
        if (object instanceof Number) {
            String string;
            double d = ((Number)object).doubleValue();
            if (d == 0.0) {
                stringBuffer.append('0');
                return;
            }
            double d2 = Math.log10(Math.abs(d));
            boolean bl = true;
            if (d2 > 10.0 || d2 < -9.0) {
                string = "%1.5E";
            } else if ((double)((long)d) != d) {
                string = "%1.9f";
            } else {
                string = "%1.0f";
                bl = false;
            }
            Formatter formatter = new Formatter(stringBuffer, LocaleUtil.getUserLocale());
            try {
                formatter.format(LocaleUtil.getUserLocale(), string, object);
            }
            finally {
                formatter.close();
            }
            if (bl) {
                int n = string.endsWith("E") ? stringBuffer.lastIndexOf("E") - 1 : stringBuffer.length() - 1;
                while (stringBuffer.charAt(n) == '0') {
                    stringBuffer.deleteCharAt(n--);
                }
                if (stringBuffer.charAt(n) == '.') {
                    stringBuffer.deleteCharAt(n--);
                }
            }
        } else if (object instanceof Boolean) {
            stringBuffer.append(object.toString().toUpperCase(Locale.ROOT));
        } else {
            stringBuffer.append(object.toString());
        }
    }

    public void simpleValue(StringBuffer stringBuffer, Object object) {
        this.formatValue(stringBuffer, object);
    }
}

