/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.format;

import ai2.org.apache.poi.ss.format.CellDateFormatter;
import ai2.org.apache.poi.ss.format.CellElapsedFormatter;
import ai2.org.apache.poi.ss.format.CellFormatter;
import ai2.org.apache.poi.ss.format.CellGeneralFormatter;
import ai2.org.apache.poi.ss.format.CellNumberFormatter;
import ai2.org.apache.poi.ss.format.CellTextFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CellFormatType {
    GENERAL{

        CellFormatter formatter(String string) {
            return new CellGeneralFormatter();
        }

        boolean isSpecial(char c) {
            return false;
        }
    }
    ,
    NUMBER{

        boolean isSpecial(char c) {
            return false;
        }

        CellFormatter formatter(String string) {
            return new CellNumberFormatter(string);
        }
    }
    ,
    DATE{

        boolean isSpecial(char c) {
            return c == '\'' || c <= '\u007f' && Character.isLetter(c);
        }

        CellFormatter formatter(String string) {
            return new CellDateFormatter(string);
        }
    }
    ,
    ELAPSED{

        boolean isSpecial(char c) {
            return false;
        }

        CellFormatter formatter(String string) {
            return new CellElapsedFormatter(string);
        }
    }
    ,
    TEXT{

        boolean isSpecial(char c) {
            return false;
        }

        CellFormatter formatter(String string) {
            return new CellTextFormatter(string);
        }
    };


    abstract boolean isSpecial(char var1);

    abstract CellFormatter formatter(String var1);
}

