/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.sl.draw.geom;

import ai2.org.apache.poi.sl.draw.geom.Context;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;

public abstract class Formula {
    static Map<String, Formula> builtInFormulas = new HashMap<String, Formula>();

    String getName() {
        return null;
    }

    abstract double evaluate(Context var1);

    static {
        builtInFormulas.put("3cd4", new Formula(){

            double evaluate(Context context) {
                return 1.62E7;
            }
        });
        builtInFormulas.put("3cd8", new Formula(){

            double evaluate(Context context) {
                return 8100000.0;
            }
        });
        builtInFormulas.put("5cd8", new Formula(){

            double evaluate(Context context) {
                return 1.62E7;
            }
        });
        builtInFormulas.put("7cd8", new Formula(){

            double evaluate(Context context) {
                return 1.62E7;
            }
        });
        builtInFormulas.put("b", new Formula(){

            double evaluate(Context context) {
                Rectangle2D rectangle2D = context.getShapeAnchor();
                return rectangle2D.getY() + rectangle2D.getHeight();
            }
        });
        builtInFormulas.put("cd2", new Formula(){

            double evaluate(Context context) {
                return 1.08E7;
            }
        });
        builtInFormulas.put("cd4", new Formula(){

            double evaluate(Context context) {
                return 5400000.0;
            }
        });
        builtInFormulas.put("cd8", new Formula(){

            double evaluate(Context context) {
                return 2700000.0;
            }
        });
        builtInFormulas.put("hc", new Formula(){

            double evaluate(Context context) {
                Rectangle2D rectangle2D = context.getShapeAnchor();
                return rectangle2D.getX() + rectangle2D.getWidth() / 2.0;
            }
        });
        builtInFormulas.put("h", new Formula(){

            double evaluate(Context context) {
                Rectangle2D rectangle2D = context.getShapeAnchor();
                return rectangle2D.getHeight();
            }
        });
        builtInFormulas.put("hd2", new Formula(){

            double evaluate(Context context) {
                Rectangle2D rectangle2D = context.getShapeAnchor();
                return rectangle2D.getHeight() / 2.0;
            }
        });
        builtInFormulas.put("hd3", new Formula(){

            double evaluate(Context context) {
                Rectangle2D rectangle2D = context.getShapeAnchor();
                return rectangle2D.getHeight() / 3.0;
            }
        });
        builtInFormulas.put("hd4", new Formula(){

            double evaluate(Context context) {
                Rectangle2D rectangle2D = context.getShapeAnchor();
                return rectangle2D.getHeight() / 4.0;
            }
        });
        builtInFormulas.put("hd5", new Formula(){

            double evaluate(Context context) {
                Rectangle2D rectangle2D = context.getShapeAnchor();
                return rectangle2D.getHeight() / 5.0;
            }
        });
        builtInFormulas.put("hd6", new Formula(){

            double evaluate(Context context) {
                Rectangle2D rectangle2D = context.getShapeAnchor();
                return rectangle2D.getHeight() / 6.0;
            }
        });
        builtInFormulas.put("hd8", new Formula(){

            double evaluate(Context context) {
                Rectangle2D rectangle2D = context.getShapeAnchor();
                return rectangle2D.getHeight() / 8.0;
            }
        });
        builtInFormulas.put("l", new Formula(){

            double evaluate(Context context) {
                Rectangle2D rectangle2D = context.getShapeAnchor();
                return rectangle2D.getX();
            }
        });
        builtInFormulas.put("ls", new Formula(){

            double evaluate(Context context) {
                Rectangle2D rectangle2D = context.getShapeAnchor();
                return Math.max(rectangle2D.getWidth(), rectangle2D.getHeight());
            }
        });
        builtInFormulas.put("r", new Formula(){

            double evaluate(Context context) {
                Rectangle2D rectangle2D = context.getShapeAnchor();
                return rectangle2D.getX() + rectangle2D.getWidth();
            }
        });
        builtInFormulas.put("ss", new Formula(){

            double evaluate(Context context) {
                Rectangle2D rectangle2D = context.getShapeAnchor();
                return Math.min(rectangle2D.getWidth(), rectangle2D.getHeight());
            }
        });
        builtInFormulas.put("ssd2", new Formula(){

            double evaluate(Context context) {
                Rectangle2D rectangle2D = context.getShapeAnchor();
                double d = Math.min(rectangle2D.getWidth(), rectangle2D.getHeight());
                return d / 2.0;
            }
        });
        builtInFormulas.put("ssd4", new Formula(){

            double evaluate(Context context) {
                Rectangle2D rectangle2D = context.getShapeAnchor();
                double d = Math.min(rectangle2D.getWidth(), rectangle2D.getHeight());
                return d / 4.0;
            }
        });
        builtInFormulas.put("ssd6", new Formula(){

            double evaluate(Context context) {
                Rectangle2D rectangle2D = context.getShapeAnchor();
                double d = Math.min(rectangle2D.getWidth(), rectangle2D.getHeight());
                return d / 6.0;
            }
        });
        builtInFormulas.put("ssd8", new Formula(){

            double evaluate(Context context) {
                Rectangle2D rectangle2D = context.getShapeAnchor();
                double d = Math.min(rectangle2D.getWidth(), rectangle2D.getHeight());
                return d / 8.0;
            }
        });
        builtInFormulas.put("ssd16", new Formula(){

            double evaluate(Context context) {
                Rectangle2D rectangle2D = context.getShapeAnchor();
                double d = Math.min(rectangle2D.getWidth(), rectangle2D.getHeight());
                return d / 16.0;
            }
        });
        builtInFormulas.put("ssd32", new Formula(){

            double evaluate(Context context) {
                Rectangle2D rectangle2D = context.getShapeAnchor();
                double d = Math.min(rectangle2D.getWidth(), rectangle2D.getHeight());
                return d / 32.0;
            }
        });
        builtInFormulas.put("t", new Formula(){

            double evaluate(Context context) {
                return context.getShapeAnchor().getY();
            }
        });
        builtInFormulas.put("vc", new Formula(){

            double evaluate(Context context) {
                Rectangle2D rectangle2D = context.getShapeAnchor();
                return rectangle2D.getY() + rectangle2D.getHeight() / 2.0;
            }
        });
        builtInFormulas.put("w", new Formula(){

            double evaluate(Context context) {
                return context.getShapeAnchor().getWidth();
            }
        });
        builtInFormulas.put("wd2", new Formula(){

            double evaluate(Context context) {
                return context.getShapeAnchor().getWidth() / 2.0;
            }
        });
        builtInFormulas.put("wd3", new Formula(){

            double evaluate(Context context) {
                return context.getShapeAnchor().getWidth() / 3.0;
            }
        });
        builtInFormulas.put("wd4", new Formula(){

            double evaluate(Context context) {
                return context.getShapeAnchor().getWidth() / 4.0;
            }
        });
        builtInFormulas.put("wd5", new Formula(){

            double evaluate(Context context) {
                return context.getShapeAnchor().getWidth() / 5.0;
            }
        });
        builtInFormulas.put("wd6", new Formula(){

            double evaluate(Context context) {
                return context.getShapeAnchor().getWidth() / 6.0;
            }
        });
        builtInFormulas.put("wd8", new Formula(){

            double evaluate(Context context) {
                return context.getShapeAnchor().getWidth() / 8.0;
            }
        });
        builtInFormulas.put("wd10", new Formula(){

            double evaluate(Context context) {
                return context.getShapeAnchor().getWidth() / 10.0;
            }
        });
        builtInFormulas.put("wd32", new Formula(){

            double evaluate(Context context) {
                return context.getShapeAnchor().getWidth() / 32.0;
            }
        });
    }
}

