/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.sl.draw.geom;

import ai2.org.apache.poi.sl.draw.geom.AbsExpression;
import ai2.org.apache.poi.sl.draw.geom.AddDivideExpression;
import ai2.org.apache.poi.sl.draw.geom.AddSubtractExpression;
import ai2.org.apache.poi.sl.draw.geom.ArcTanExpression;
import ai2.org.apache.poi.sl.draw.geom.CosExpression;
import ai2.org.apache.poi.sl.draw.geom.CosineArcTanExpression;
import ai2.org.apache.poi.sl.draw.geom.Expression;
import ai2.org.apache.poi.sl.draw.geom.IfElseExpression;
import ai2.org.apache.poi.sl.draw.geom.LiteralValueExpression;
import ai2.org.apache.poi.sl.draw.geom.MaxExpression;
import ai2.org.apache.poi.sl.draw.geom.MinExpression;
import ai2.org.apache.poi.sl.draw.geom.ModExpression;
import ai2.org.apache.poi.sl.draw.geom.MultiplyDivideExpression;
import ai2.org.apache.poi.sl.draw.geom.PinExpression;
import ai2.org.apache.poi.sl.draw.geom.SinArcTanExpression;
import ai2.org.apache.poi.sl.draw.geom.SinExpression;
import ai2.org.apache.poi.sl.draw.geom.SqrtExpression;
import ai2.org.apache.poi.sl.draw.geom.TanExpression;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExpressionParser {
    static final HashMap<String, Class<? extends Expression>> impls = new HashMap();

    public static Expression parse(String string) {
        for (String string2 : impls.keySet()) {
            Pattern pattern = Pattern.compile(string2);
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches()) continue;
            Class<? extends Expression> clazz = impls.get(string2);
            try {
                return clazz.getDeclaredConstructor(Matcher.class).newInstance(matcher);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        throw new RuntimeException("Unsupported formula: " + string);
    }

    static {
        impls.put("\\*/ +([\\-\\w]+) +([\\-\\w]+) +([\\-\\w]+)", MultiplyDivideExpression.class);
        impls.put("\\+- +([\\-\\w]+) +([\\-\\w]+) +([\\-\\w]+)( 0)?", AddSubtractExpression.class);
        impls.put("\\+/ +([\\-\\w]+) +([\\-\\w]+) +([\\-\\w]+)", AddDivideExpression.class);
        impls.put("\\?: +([\\-\\w]+) +([\\-\\w]+) +([\\-\\w]+)", IfElseExpression.class);
        impls.put("val +([\\-\\w]+)", LiteralValueExpression.class);
        impls.put("abs +([\\-\\w]+)", AbsExpression.class);
        impls.put("sqrt +([\\-\\w]+)", SqrtExpression.class);
        impls.put("max +([\\-\\w]+) +([\\-\\w]+)", MaxExpression.class);
        impls.put("min +([\\-\\w]+) +([\\-\\w]+)", MinExpression.class);
        impls.put("at2 +([\\-\\w]+) +([\\-\\w]+)", ArcTanExpression.class);
        impls.put("sin +([\\-\\w]+) +([\\-\\w]+)", SinExpression.class);
        impls.put("cos +([\\-\\w]+) +([\\-\\w]+)", CosExpression.class);
        impls.put("tan +([\\-\\w]+) +([\\-\\w]+)", TanExpression.class);
        impls.put("cat2 +([\\-\\w]+) +([\\-\\w]+) +([\\-\\w]+)", CosineArcTanExpression.class);
        impls.put("sat2 +([\\-\\w]+) +([\\-\\w]+) +([\\-\\w]+)", SinArcTanExpression.class);
        impls.put("pin +([\\-\\w]+) +([\\-\\w]+) +([\\-\\w]+)", PinExpression.class);
        impls.put("mod +([\\-\\w]+) +([\\-\\w]+) +([\\-\\w]+)", ModExpression.class);
    }
}

