/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.sl.draw;

import ai2.org.apache.poi.sl.draw.Drawable;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

class PathGradientPaint
implements Paint {
    protected final Color[] colors;
    protected final float[] fractions;
    protected final int capStyle;
    protected final int joinStyle;
    protected final int transparency;

    public PathGradientPaint(Color[] colorArray, float[] fArray) {
        this(colorArray, fArray, 1, 1);
    }

    public PathGradientPaint(Color[] colorArray, float[] fArray, int n, int n2) {
        this.colors = colorArray;
        this.fractions = fArray;
        this.capStyle = n;
        this.joinStyle = n2;
        boolean bl = true;
        for (int i = 0; i < colorArray.length; ++i) {
            bl = bl && colorArray[i].getAlpha() == 255;
        }
        this.transparency = bl ? 1 : 3;
    }

    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        return new PathGradientContext(colorModel, rectangle, rectangle2D, affineTransform, renderingHints);
    }

    public int getTransparency() {
        return this.transparency;
    }

    class PathGradientContext
    implements PaintContext {
        protected final Rectangle deviceBounds;
        protected final Rectangle2D userBounds;
        protected final AffineTransform xform;
        protected final RenderingHints hints;
        protected final Shape shape;
        protected final PaintContext pCtx;
        protected final int gradientSteps;
        WritableRaster raster;

        public PathGradientContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
            this.shape = (Shape)renderingHints.get(Drawable.GRADIENT_SHAPE);
            if (this.shape == null) {
                throw new IllegalPathStateException("PathGradientPaint needs a shape to be set via the rendering hint PathGradientPaint.GRADIANT_SHAPE.");
            }
            this.deviceBounds = rectangle;
            this.userBounds = rectangle2D;
            this.xform = affineTransform;
            this.hints = renderingHints;
            this.gradientSteps = this.getGradientSteps(this.shape);
            Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
            Point2D.Double double_2 = new Point2D.Double(this.gradientSteps, 0.0);
            LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, PathGradientPaint.this.fractions, PathGradientPaint.this.colors, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform());
            Rectangle rectangle2 = new Rectangle(0, 0, this.gradientSteps, 1);
            this.pCtx = linearGradientPaint.createContext(colorModel, rectangle2, rectangle2, new AffineTransform(), renderingHints);
        }

        public void dispose() {
        }

        public ColorModel getColorModel() {
            return this.pCtx.getColorModel();
        }

        public Raster getRaster(int n, int n2, int n3, int n4) {
            ColorModel colorModel = this.getColorModel();
            if (this.raster == null) {
                this.createRaster();
            }
            WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n3, n4);
            Rectangle2D.Double double_ = new Rectangle2D.Double(n, n2, n3, n4);
            if (!double_.intersects(this.deviceBounds)) {
                return writableRaster;
            }
            Rectangle2D.Double double_2 = new Rectangle2D.Double();
            Rectangle2D.intersect(double_, this.deviceBounds, double_2);
            int n5 = (int)(((RectangularShape)double_2).getX() - this.deviceBounds.getX());
            int n6 = (int)(((RectangularShape)double_2).getY() - this.deviceBounds.getY());
            int n7 = (int)((RectangularShape)double_2).getWidth();
            int n8 = (int)((RectangularShape)double_2).getHeight();
            Object object = this.raster.getDataElements(n5, n6, n7, n8, null);
            n5 = (int)(((RectangularShape)double_2).getX() - ((RectangularShape)double_).getX());
            n6 = (int)(((RectangularShape)double_2).getY() - ((RectangularShape)double_).getY());
            writableRaster.setDataElements(n5, n6, n7, n8, object);
            return writableRaster;
        }

        protected int getGradientSteps(Shape shape) {
            Rectangle rectangle = shape.getBounds();
            int n = 1;
            int n2 = (int)(Math.max(rectangle.getWidth(), rectangle.getHeight()) / 2.0);
            while (n < n2 - 1) {
                int n3 = n + (n2 - n) / 2;
                BasicStroke basicStroke = new BasicStroke(n3, PathGradientPaint.this.capStyle, PathGradientPaint.this.joinStyle);
                Area area = new Area(basicStroke.createStrokedShape(shape));
                if (area.isSingular()) {
                    n2 = n3;
                    continue;
                }
                n = n3;
            }
            return n2;
        }

        protected void createRaster() {
            ColorModel colorModel = this.getColorModel();
            this.raster = colorModel.createCompatibleWritableRaster((int)this.deviceBounds.getWidth(), (int)this.deviceBounds.getHeight());
            BufferedImage bufferedImage = new BufferedImage(colorModel, this.raster, false, null);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setRenderingHints(this.hints);
            graphics2D.translate(-this.deviceBounds.getX(), -this.deviceBounds.getY());
            graphics2D.transform(this.xform);
            Raster raster = this.pCtx.getRaster(0, 0, this.gradientSteps, 1);
            int[] nArray = new int[colorModel.getNumComponents()];
            for (int i = this.gradientSteps - 1; i >= 0; --i) {
                raster.getPixel(i, 0, nArray);
                Color color = new Color(nArray[0], nArray[1], nArray[2]);
                if (nArray.length == 4) {
                    graphics2D.setComposite(AlphaComposite.getInstance(2, (float)nArray[3] / 255.0f));
                }
                graphics2D.setStroke(new BasicStroke(i + 1, PathGradientPaint.this.capStyle, PathGradientPaint.this.joinStyle));
                graphics2D.setColor(color);
                graphics2D.draw(this.shape);
            }
            graphics2D.dispose();
        }
    }
}

