/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.sl.draw;

import ai2.org.apache.poi.sl.draw.DrawFactory;
import ai2.org.apache.poi.sl.draw.DrawPaint;
import ai2.org.apache.poi.sl.draw.DrawShape;
import ai2.org.apache.poi.sl.draw.Drawable;
import ai2.org.apache.poi.sl.draw.binding.CTCustomGeometry2D;
import ai2.org.apache.poi.sl.draw.geom.Context;
import ai2.org.apache.poi.sl.draw.geom.CustomGeometry;
import ai2.org.apache.poi.sl.draw.geom.IAdjustableShape;
import ai2.org.apache.poi.sl.draw.geom.Outline;
import ai2.org.apache.poi.sl.draw.geom.Path;
import ai2.org.apache.poi.sl.usermodel.LineDecoration;
import ai2.org.apache.poi.sl.usermodel.PaintStyle;
import ai2.org.apache.poi.sl.usermodel.PlaceableShape;
import ai2.org.apache.poi.sl.usermodel.Shadow;
import ai2.org.apache.poi.sl.usermodel.SimpleShape;
import ai2.org.apache.poi.sl.usermodel.StrokeStyle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawSimpleShape
extends DrawShape {
    public DrawSimpleShape(SimpleShape<?, ?> simpleShape) {
        super(simpleShape);
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        Shape shape;
        DrawPaint drawPaint = DrawFactory.getInstance(graphics2D).getPaint((PlaceableShape<?, ?>)((Object)this.getShape()));
        Paint paint = drawPaint.getPaint(graphics2D, this.getShape().getFillStyle().getPaint());
        Paint paint2 = drawPaint.getPaint(graphics2D, this.getShape().getStrokeStyle().getPaint());
        BasicStroke basicStroke = this.getStroke();
        graphics2D.setStroke(basicStroke);
        Collection<Outline> collection = this.computeOutlines(graphics2D);
        this.drawShadow(graphics2D, collection, paint, paint2);
        if (paint != null) {
            graphics2D.setPaint(paint);
            for (Outline outline : collection) {
                if (!outline.getPath().isFilled()) continue;
                shape = outline.getOutline();
                graphics2D.setRenderingHint(Drawable.GRADIENT_SHAPE, shape);
                graphics2D.fill(shape);
            }
        }
        this.drawContent(graphics2D);
        if (paint2 != null) {
            graphics2D.setPaint(paint2);
            for (Outline outline : collection) {
                if (!outline.getPath().isStroked()) continue;
                shape = outline.getOutline();
                graphics2D.setRenderingHint(Drawable.GRADIENT_SHAPE, shape);
                graphics2D.draw(shape);
            }
        }
        this.drawDecoration(graphics2D, paint2, basicStroke);
    }

    protected void drawDecoration(Graphics2D graphics2D, Paint paint, BasicStroke basicStroke) {
        Outline outline;
        if (paint == null) {
            return;
        }
        graphics2D.setPaint(paint);
        ArrayList<Outline> arrayList = new ArrayList<Outline>();
        LineDecoration lineDecoration = this.getShape().getLineDecoration();
        Outline outline2 = this.getHeadDecoration(graphics2D, lineDecoration, basicStroke);
        if (outline2 != null) {
            arrayList.add(outline2);
        }
        if ((outline = this.getTailDecoration(graphics2D, lineDecoration, basicStroke)) != null) {
            arrayList.add(outline);
        }
        for (Outline outline3 : arrayList) {
            Shape shape = outline3.getOutline();
            Path path = outline3.getPath();
            graphics2D.setRenderingHint(Drawable.GRADIENT_SHAPE, shape);
            if (path.isFilled()) {
                graphics2D.fill(shape);
            }
            if (!path.isStroked()) continue;
            graphics2D.draw(shape);
        }
    }

    protected Outline getTailDecoration(Graphics2D graphics2D, LineDecoration lineDecoration, BasicStroke basicStroke) {
        LineDecoration.DecorationSize decorationSize = lineDecoration.getTailLength();
        LineDecoration.DecorationSize decorationSize2 = lineDecoration.getTailWidth();
        double d = Math.max(2.5, (double)basicStroke.getLineWidth());
        Rectangle2D rectangle2D = DrawSimpleShape.getAnchor(graphics2D, this.getShape());
        double d2 = rectangle2D.getX() + rectangle2D.getWidth();
        double d3 = rectangle2D.getY() + rectangle2D.getHeight();
        double d4 = Math.atan(rectangle2D.getHeight() / rectangle2D.getWidth());
        AffineTransform affineTransform = new AffineTransform();
        Shape shape = null;
        Path path = null;
        double d5 = Math.pow(2.0, decorationSize2.ordinal() + 1);
        double d6 = Math.pow(2.0, decorationSize.ordinal() + 1);
        switch (lineDecoration.getTailShape()) {
            case OVAL: {
                path = new Path();
                shape = new Ellipse2D.Double(0.0, 0.0, d * d6, d * d5);
                Rectangle2D rectangle2D2 = shape.getBounds2D();
                affineTransform.translate(d2 - rectangle2D2.getWidth() / 2.0, d3 - rectangle2D2.getHeight() / 2.0);
                affineTransform.rotate(d4, rectangle2D2.getX() + rectangle2D2.getWidth() / 2.0, rectangle2D2.getY() + rectangle2D2.getHeight() / 2.0);
                break;
            }
            case STEALTH: 
            case ARROW: {
                path = new Path(false, true);
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo((float)(-d * d6), (float)(-d * d5 / 2.0));
                generalPath.lineTo(0.0f, 0.0f);
                generalPath.lineTo((float)(-d * d6), (float)(d * d5 / 2.0));
                shape = generalPath;
                affineTransform.translate(d2, d3);
                affineTransform.rotate(d4);
                break;
            }
            case TRIANGLE: {
                path = new Path();
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo((float)(-d * d6), (float)(-d * d5 / 2.0));
                generalPath.lineTo(0.0f, 0.0f);
                generalPath.lineTo((float)(-d * d6), (float)(d * d5 / 2.0));
                generalPath.closePath();
                shape = generalPath;
                affineTransform.translate(d2, d3);
                affineTransform.rotate(d4);
                break;
            }
        }
        if (shape != null) {
            shape = affineTransform.createTransformedShape(shape);
        }
        return shape == null ? null : new Outline(shape, path);
    }

    protected Outline getHeadDecoration(Graphics2D graphics2D, LineDecoration lineDecoration, BasicStroke basicStroke) {
        LineDecoration.DecorationSize decorationSize = lineDecoration.getHeadLength();
        LineDecoration.DecorationSize decorationSize2 = lineDecoration.getHeadWidth();
        double d = Math.max(2.5, (double)basicStroke.getLineWidth());
        Rectangle2D rectangle2D = DrawSimpleShape.getAnchor(graphics2D, this.getShape());
        double d2 = rectangle2D.getX();
        double d3 = rectangle2D.getY();
        double d4 = Math.atan(rectangle2D.getHeight() / rectangle2D.getWidth());
        AffineTransform affineTransform = new AffineTransform();
        Shape shape = null;
        Path path = null;
        double d5 = Math.pow(2.0, decorationSize2.ordinal() + 1);
        double d6 = Math.pow(2.0, decorationSize.ordinal() + 1);
        switch (lineDecoration.getHeadShape()) {
            case OVAL: {
                path = new Path();
                shape = new Ellipse2D.Double(0.0, 0.0, d * d6, d * d5);
                Rectangle2D rectangle2D2 = shape.getBounds2D();
                affineTransform.translate(d2 - rectangle2D2.getWidth() / 2.0, d3 - rectangle2D2.getHeight() / 2.0);
                affineTransform.rotate(d4, rectangle2D2.getX() + rectangle2D2.getWidth() / 2.0, rectangle2D2.getY() + rectangle2D2.getHeight() / 2.0);
                break;
            }
            case STEALTH: 
            case ARROW: {
                path = new Path(false, true);
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo((float)(d * d6), (float)(-d * d5 / 2.0));
                generalPath.lineTo(0.0f, 0.0f);
                generalPath.lineTo((float)(d * d6), (float)(d * d5 / 2.0));
                shape = generalPath;
                affineTransform.translate(d2, d3);
                affineTransform.rotate(d4);
                break;
            }
            case TRIANGLE: {
                path = new Path();
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo((float)(d * d6), (float)(-d * d5 / 2.0));
                generalPath.lineTo(0.0f, 0.0f);
                generalPath.lineTo((float)(d * d6), (float)(d * d5 / 2.0));
                generalPath.closePath();
                shape = generalPath;
                affineTransform.translate(d2, d3);
                affineTransform.rotate(d4);
                break;
            }
        }
        if (shape != null) {
            shape = affineTransform.createTransformedShape(shape);
        }
        return shape == null ? null : new Outline(shape, path);
    }

    public BasicStroke getStroke() {
        int n;
        StrokeStyle.LineCap lineCap;
        StrokeStyle.LineDash lineDash;
        StrokeStyle strokeStyle = this.getShape().getStrokeStyle();
        float f = (float)strokeStyle.getLineWidth();
        if (f == 0.0f) {
            f = 0.25f;
        }
        if ((lineDash = strokeStyle.getLineDash()) == null) {
            lineDash = StrokeStyle.LineDash.SOLID;
        }
        int[] nArray = lineDash.pattern;
        float[] fArray = null;
        if (nArray != null) {
            fArray = new float[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                fArray[i] = (float)nArray[i] * Math.max(1.0f, f);
            }
        }
        if ((lineCap = strokeStyle.getLineCap()) == null) {
            lineCap = StrokeStyle.LineCap.FLAT;
        }
        switch (lineCap) {
            case ROUND: {
                n = 1;
                break;
            }
            case SQUARE: {
                n = 2;
                break;
            }
            default: {
                n = 0;
            }
        }
        int n2 = 1;
        return new BasicStroke(f, n, n2, f, fArray, 0.0f);
    }

    protected void drawShadow(Graphics2D graphics2D, Collection<Outline> collection, Paint paint, Paint paint2) {
        Shadow shadow = this.getShape().getShadow();
        if (shadow == null || paint == null && paint2 == null) {
            return;
        }
        PaintStyle.SolidPaint solidPaint = shadow.getFillStyle();
        Color color = DrawPaint.applyColorTransform(solidPaint.getSolidColor());
        double d = this.getShape().getRotation();
        if (this.getShape().getFlipVertical()) {
            d += 180.0;
        }
        double d2 = shadow.getAngle() - d;
        double d3 = shadow.getDistance();
        double d4 = d3 * Math.cos(Math.toRadians(d2));
        double d5 = d3 * Math.sin(Math.toRadians(d2));
        graphics2D.translate(d4, d5);
        for (Outline outline : collection) {
            Shape shape = outline.getOutline();
            Path path = outline.getPath();
            graphics2D.setRenderingHint(Drawable.GRADIENT_SHAPE, shape);
            graphics2D.setPaint(color);
            if (paint != null && path.isFilled()) {
                graphics2D.fill(shape);
                continue;
            }
            if (paint2 == null || !path.isStroked()) continue;
            graphics2D.draw(shape);
        }
        graphics2D.translate(-d4, -d5);
    }

    protected static CustomGeometry getCustomGeometry(String string) {
        return DrawSimpleShape.getCustomGeometry(string, null);
    }

    protected static CustomGeometry getCustomGeometry(String string, Graphics2D graphics2D) {
        HashMap<String, CustomGeometry> hashMap;
        HashMap<String, CustomGeometry> hashMap2 = hashMap = graphics2D == null ? null : (HashMap<String, CustomGeometry>)graphics2D.getRenderingHint(Drawable.PRESET_GEOMETRY_CACHE);
        if (hashMap == null) {
            hashMap = new HashMap<String, CustomGeometry>();
            if (graphics2D != null) {
                graphics2D.setRenderingHint(Drawable.PRESET_GEOMETRY_CACHE, hashMap);
            }
            String string2 = "ai2.org.apache.poi.sl.draw.binding";
            InputStream inputStream = Drawable.class.getResourceAsStream("presetShapeDefinitions.xml");
            EventFilter eventFilter = new EventFilter(){

                public boolean accept(XMLEvent xMLEvent) {
                    return xMLEvent.isStartElement();
                }
            };
            try {
                XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
                XMLEventReader xMLEventReader = xMLInputFactory.createXMLEventReader(inputStream);
                XMLEventReader xMLEventReader2 = xMLInputFactory.createFilteredReader(xMLEventReader, eventFilter);
                xMLEventReader2.nextEvent();
                JAXBContext jAXBContext = JAXBContext.newInstance((String)string2);
                Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
                while (xMLEventReader2.peek() != null) {
                    StartElement startElement = (StartElement)xMLEventReader2.peek();
                    String string3 = startElement.getName().getLocalPart();
                    JAXBElement jAXBElement = unmarshaller.unmarshal(xMLEventReader, CTCustomGeometry2D.class);
                    CTCustomGeometry2D cTCustomGeometry2D = (CTCustomGeometry2D)jAXBElement.getValue();
                    hashMap.put(string3, new CustomGeometry(cTCustomGeometry2D));
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("Unable to load preset geometries.", exception);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    throw new RuntimeException("Unable to load preset geometries.", iOException);
                }
            }
        }
        return (CustomGeometry)hashMap.get(string);
    }

    protected Collection<Outline> computeOutlines(Graphics2D graphics2D) {
        ArrayList<Outline> arrayList = new ArrayList<Outline>();
        CustomGeometry customGeometry = this.getShape().getGeometry();
        if (customGeometry == null) {
            return arrayList;
        }
        Rectangle2D rectangle2D = DrawSimpleShape.getAnchor(graphics2D, this.getShape());
        for (Path path : customGeometry) {
            double d = path.getW() == -1L ? rectangle2D.getWidth() * 12700.0 : (double)path.getW();
            double d2 = path.getH() == -1L ? rectangle2D.getHeight() * 12700.0 : (double)path.getH();
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, d, d2);
            Context context = new Context(customGeometry, double_, (IAdjustableShape)((Object)this.getShape()));
            GeneralPath generalPath = path.getPath(context);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(rectangle2D.getX(), rectangle2D.getY());
            double d3 = path.getW() != -1L ? rectangle2D.getWidth() / (double)path.getW() : 7.874015748031496E-5;
            double d4 = path.getH() != -1L ? rectangle2D.getHeight() / (double)path.getH() : 7.874015748031496E-5;
            affineTransform.scale(d3, d4);
            Shape shape = affineTransform.createTransformedShape(generalPath);
            arrayList.add(new Outline(shape, path));
        }
        return arrayList;
    }

    protected SimpleShape<?, ?> getShape() {
        return (SimpleShape)this.shape;
    }
}

