/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.sl.draw;

import ai2.org.apache.poi.sl.draw.DrawFactory;
import ai2.org.apache.poi.sl.draw.DrawMasterSheet;
import ai2.org.apache.poi.sl.draw.Drawable;
import ai2.org.apache.poi.sl.usermodel.MasterSheet;
import ai2.org.apache.poi.sl.usermodel.Shape;
import ai2.org.apache.poi.sl.usermodel.Sheet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawSheet
implements Drawable {
    protected final Sheet<?, ?> sheet;

    public DrawSheet(Sheet<?, ?> sheet) {
        this.sheet = sheet;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        Dimension dimension = this.sheet.getSlideShow().getPageSize();
        Color color = new Color(1.0f, 1.0f, 1.0f, 0.0f);
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, (int)dimension.getWidth(), (int)dimension.getHeight());
        DrawFactory drawFactory = DrawFactory.getInstance(graphics2D);
        MasterSheet<?, ?> masterSheet = this.sheet.getMasterSheet();
        if (this.sheet.getFollowMasterGraphics() && masterSheet != null) {
            DrawMasterSheet drawMasterSheet = drawFactory.getDrawable(masterSheet);
            drawMasterSheet.draw(graphics2D);
        }
        graphics2D.setRenderingHint(Drawable.GROUP_TRANSFORM, new AffineTransform());
        for (Shape shape : this.sheet.getShapes()) {
            if (!this.canDraw(shape)) continue;
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.setRenderingHint(Drawable.GSAVE, true);
            Drawable drawable = drawFactory.getDrawable(shape);
            drawable.applyTransform(graphics2D);
            drawable.draw(graphics2D);
            graphics2D.setTransform(affineTransform);
            graphics2D.setRenderingHint(Drawable.GRESTORE, true);
        }
    }

    @Override
    public void applyTransform(Graphics2D graphics2D) {
    }

    @Override
    public void drawContent(Graphics2D graphics2D) {
    }

    protected boolean canDraw(Shape<?, ?> shape) {
        return true;
    }
}

