/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.sl.draw;

import ai2.org.apache.poi.sl.draw.DrawFactory;
import ai2.org.apache.poi.sl.draw.DrawShape;
import ai2.org.apache.poi.sl.draw.Drawable;
import ai2.org.apache.poi.sl.usermodel.GroupShape;
import ai2.org.apache.poi.sl.usermodel.Shape;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.RectangularShape;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawGroupShape
extends DrawShape {
    public DrawGroupShape(GroupShape<?, ?> groupShape) {
        super(groupShape);
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        Rectangle rectangle = this.getShape().getInteriorAnchor();
        Rectangle rectangle2 = this.getShape().getAnchor();
        AffineTransform affineTransform = (AffineTransform)graphics2D.getRenderingHint(Drawable.GROUP_TRANSFORM);
        AffineTransform affineTransform2 = new AffineTransform(affineTransform);
        double d = ((RectangularShape)rectangle).getWidth() == 0.0 ? 1.0 : ((RectangularShape)rectangle2).getWidth() / ((RectangularShape)rectangle).getWidth();
        double d2 = ((RectangularShape)rectangle).getHeight() == 0.0 ? 1.0 : ((RectangularShape)rectangle2).getHeight() / ((RectangularShape)rectangle).getHeight();
        affineTransform.translate(((RectangularShape)rectangle2).getX(), ((RectangularShape)rectangle2).getY());
        affineTransform.scale(d, d2);
        affineTransform.translate(-((RectangularShape)rectangle).getX(), -((RectangularShape)rectangle).getY());
        DrawFactory drawFactory = DrawFactory.getInstance(graphics2D);
        AffineTransform affineTransform3 = graphics2D.getTransform();
        Iterator iterator = this.getShape().iterator();
        while (iterator.hasNext()) {
            Shape shape = (Shape)iterator.next();
            AffineTransform affineTransform4 = graphics2D.getTransform();
            graphics2D.setRenderingHint(Drawable.GSAVE, true);
            Drawable drawable = drawFactory.getDrawable(shape);
            drawable.applyTransform(graphics2D);
            drawable.draw(graphics2D);
            graphics2D.setTransform(affineTransform4);
            graphics2D.setRenderingHint(Drawable.GRESTORE, true);
        }
        graphics2D.setTransform(affineTransform3);
        graphics2D.setRenderingHint(Drawable.GROUP_TRANSFORM, affineTransform2);
    }

    protected GroupShape<?, ?> getShape() {
        return (GroupShape)this.shape;
    }
}

