/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.sl.draw;

import ai2.org.apache.poi.sl.draw.DrawBackground;
import ai2.org.apache.poi.sl.draw.DrawConnectorShape;
import ai2.org.apache.poi.sl.draw.DrawFreeformShape;
import ai2.org.apache.poi.sl.draw.DrawGroupShape;
import ai2.org.apache.poi.sl.draw.DrawMasterSheet;
import ai2.org.apache.poi.sl.draw.DrawNotImplemented;
import ai2.org.apache.poi.sl.draw.DrawNothing;
import ai2.org.apache.poi.sl.draw.DrawPaint;
import ai2.org.apache.poi.sl.draw.DrawPictureShape;
import ai2.org.apache.poi.sl.draw.DrawSheet;
import ai2.org.apache.poi.sl.draw.DrawSlide;
import ai2.org.apache.poi.sl.draw.DrawTableShape;
import ai2.org.apache.poi.sl.draw.DrawTextBox;
import ai2.org.apache.poi.sl.draw.DrawTextFragment;
import ai2.org.apache.poi.sl.draw.DrawTextParagraph;
import ai2.org.apache.poi.sl.draw.DrawTextShape;
import ai2.org.apache.poi.sl.draw.Drawable;
import ai2.org.apache.poi.sl.usermodel.Background;
import ai2.org.apache.poi.sl.usermodel.ConnectorShape;
import ai2.org.apache.poi.sl.usermodel.FreeformShape;
import ai2.org.apache.poi.sl.usermodel.GroupShape;
import ai2.org.apache.poi.sl.usermodel.MasterSheet;
import ai2.org.apache.poi.sl.usermodel.PictureShape;
import ai2.org.apache.poi.sl.usermodel.PlaceableShape;
import ai2.org.apache.poi.sl.usermodel.Shape;
import ai2.org.apache.poi.sl.usermodel.Sheet;
import ai2.org.apache.poi.sl.usermodel.Slide;
import ai2.org.apache.poi.sl.usermodel.TableShape;
import ai2.org.apache.poi.sl.usermodel.TextBox;
import ai2.org.apache.poi.sl.usermodel.TextParagraph;
import ai2.org.apache.poi.sl.usermodel.TextShape;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.text.AttributedString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawFactory {
    protected static final ThreadLocal<DrawFactory> defaultFactory = new ThreadLocal();

    public static void setDefaultFactory(DrawFactory drawFactory) {
        defaultFactory.set(drawFactory);
    }

    public static DrawFactory getInstance(Graphics2D graphics2D) {
        DrawFactory drawFactory = null;
        boolean bl = false;
        if (graphics2D != null) {
            drawFactory = (DrawFactory)graphics2D.getRenderingHint(Drawable.DRAW_FACTORY);
            boolean bl2 = bl = drawFactory != null;
        }
        if (drawFactory == null) {
            drawFactory = defaultFactory.get();
        }
        if (drawFactory == null) {
            drawFactory = new DrawFactory();
        }
        if (graphics2D != null && !bl) {
            graphics2D.setRenderingHint(Drawable.DRAW_FACTORY, drawFactory);
        }
        return drawFactory;
    }

    public Drawable getDrawable(Shape<?, ?> shape) {
        if (shape instanceof TextBox) {
            return this.getDrawable((TextBox)shape);
        }
        if (shape instanceof FreeformShape) {
            return this.getDrawable((FreeformShape)shape);
        }
        if (shape instanceof TextShape) {
            return this.getDrawable((TextShape)shape);
        }
        if (shape instanceof TableShape) {
            return this.getDrawable((TableShape)shape);
        }
        if (shape instanceof GroupShape) {
            return this.getDrawable((GroupShape)shape);
        }
        if (shape instanceof PictureShape) {
            return this.getDrawable((PictureShape)shape);
        }
        if (shape instanceof Background) {
            return this.getDrawable((Background)shape);
        }
        if (shape instanceof ConnectorShape) {
            return this.getDrawable((ConnectorShape)shape);
        }
        if (shape instanceof Slide) {
            return this.getDrawable((Slide)((Object)shape));
        }
        if (shape instanceof MasterSheet) {
            return this.getDrawable((MasterSheet)((Object)shape));
        }
        if (shape instanceof Sheet) {
            return this.getDrawable((Sheet)((Object)shape));
        }
        if (shape.getClass().isAnnotationPresent(DrawNotImplemented.class)) {
            return new DrawNothing(shape);
        }
        throw new IllegalArgumentException("Unsupported shape type: " + shape.getClass());
    }

    public DrawSlide getDrawable(Slide<?, ?> slide) {
        return new DrawSlide(slide);
    }

    public DrawSheet getDrawable(Sheet<?, ?> sheet) {
        return new DrawSheet(sheet);
    }

    public DrawMasterSheet getDrawable(MasterSheet<?, ?> masterSheet) {
        return new DrawMasterSheet(masterSheet);
    }

    public DrawTextBox getDrawable(TextBox<?, ?> textBox) {
        return new DrawTextBox(textBox);
    }

    public DrawFreeformShape getDrawable(FreeformShape<?, ?> freeformShape) {
        return new DrawFreeformShape(freeformShape);
    }

    public DrawConnectorShape getDrawable(ConnectorShape<?, ?> connectorShape) {
        return new DrawConnectorShape(connectorShape);
    }

    public DrawTableShape getDrawable(TableShape<?, ?> tableShape) {
        return new DrawTableShape(tableShape);
    }

    public DrawTextShape getDrawable(TextShape<?, ?> textShape) {
        return new DrawTextShape(textShape);
    }

    public DrawGroupShape getDrawable(GroupShape<?, ?> groupShape) {
        return new DrawGroupShape(groupShape);
    }

    public DrawPictureShape getDrawable(PictureShape<?, ?> pictureShape) {
        return new DrawPictureShape(pictureShape);
    }

    public DrawTextParagraph getDrawable(TextParagraph<?, ?, ?> textParagraph) {
        return new DrawTextParagraph(textParagraph);
    }

    public DrawBackground getDrawable(Background<?, ?> background) {
        return new DrawBackground(background);
    }

    public DrawTextFragment getTextFragment(TextLayout textLayout, AttributedString attributedString) {
        return new DrawTextFragment(textLayout, attributedString);
    }

    public DrawPaint getPaint(PlaceableShape<?, ?> placeableShape) {
        return new DrawPaint(placeableShape);
    }
}

