/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.storage;

import ai2.org.apache.poi.poifs.common.POIFSBigBlockSize;
import ai2.org.apache.poi.poifs.storage.BlockWritable;
import ai2.org.apache.poi.poifs.storage.DataInputBlock;
import ai2.org.apache.poi.poifs.storage.ListManagedBlock;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SmallDocumentBlock
implements BlockWritable,
ListManagedBlock {
    private static final int BLOCK_SHIFT = 6;
    private byte[] _data;
    private static final byte _default_fill = -1;
    private static final int _block_size = 64;
    private static final int BLOCK_MASK = 63;
    private final int _blocks_per_big_block;
    private final POIFSBigBlockSize _bigBlockSize;

    private SmallDocumentBlock(POIFSBigBlockSize pOIFSBigBlockSize, byte[] byArray, int n) {
        this(pOIFSBigBlockSize);
        System.arraycopy(byArray, n * 64, this._data, 0, 64);
    }

    protected SmallDocumentBlock(POIFSBigBlockSize pOIFSBigBlockSize) {
        this._bigBlockSize = pOIFSBigBlockSize;
        this._blocks_per_big_block = SmallDocumentBlock.getBlocksPerBigBlock(pOIFSBigBlockSize);
        this._data = new byte[64];
    }

    private static int getBlocksPerBigBlock(POIFSBigBlockSize pOIFSBigBlockSize) {
        return pOIFSBigBlockSize.getBigBlockSize() / 64;
    }

    public static SmallDocumentBlock[] convert(POIFSBigBlockSize pOIFSBigBlockSize, byte[] byArray, int n) {
        SmallDocumentBlock[] smallDocumentBlockArray = new SmallDocumentBlock[(n + 64 - 1) / 64];
        int n2 = 0;
        for (int i = 0; i < smallDocumentBlockArray.length; ++i) {
            smallDocumentBlockArray[i] = new SmallDocumentBlock(pOIFSBigBlockSize);
            if (n2 < byArray.length) {
                int n3 = Math.min(64, byArray.length - n2);
                System.arraycopy(byArray, n2, smallDocumentBlockArray[i]._data, 0, n3);
                if (n3 != 64) {
                    Arrays.fill(smallDocumentBlockArray[i]._data, n3, 64, (byte)-1);
                }
            } else {
                Arrays.fill(smallDocumentBlockArray[i]._data, (byte)-1);
            }
            n2 += 64;
        }
        return smallDocumentBlockArray;
    }

    public static int fill(POIFSBigBlockSize pOIFSBigBlockSize, List<SmallDocumentBlock> list) {
        int n;
        int n2 = SmallDocumentBlock.getBlocksPerBigBlock(pOIFSBigBlockSize);
        int n3 = (n + n2 - 1) / n2;
        int n4 = n3 * n2;
        for (n = list.size(); n < n4; ++n) {
            list.add(SmallDocumentBlock.makeEmptySmallDocumentBlock(pOIFSBigBlockSize));
        }
        return n3;
    }

    public static SmallDocumentBlock[] convert(POIFSBigBlockSize pOIFSBigBlockSize, BlockWritable[] blockWritableArray, int n) throws IOException, ArrayIndexOutOfBoundsException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < blockWritableArray.length; ++i) {
            blockWritableArray[i].writeBlocks(byteArrayOutputStream);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        SmallDocumentBlock[] smallDocumentBlockArray = new SmallDocumentBlock[SmallDocumentBlock.convertToBlockCount(n)];
        for (int i = 0; i < smallDocumentBlockArray.length; ++i) {
            smallDocumentBlockArray[i] = new SmallDocumentBlock(pOIFSBigBlockSize, byArray, i);
        }
        return smallDocumentBlockArray;
    }

    public static List<SmallDocumentBlock> extract(POIFSBigBlockSize pOIFSBigBlockSize, ListManagedBlock[] listManagedBlockArray) throws IOException {
        int n = SmallDocumentBlock.getBlocksPerBigBlock(pOIFSBigBlockSize);
        ArrayList<SmallDocumentBlock> arrayList = new ArrayList<SmallDocumentBlock>();
        for (int i = 0; i < listManagedBlockArray.length; ++i) {
            byte[] byArray = listManagedBlockArray[i].getData();
            for (int j = 0; j < n; ++j) {
                arrayList.add(new SmallDocumentBlock(pOIFSBigBlockSize, byArray, j));
            }
        }
        return arrayList;
    }

    public static DataInputBlock getDataInputBlock(SmallDocumentBlock[] smallDocumentBlockArray, int n) {
        int n2 = n >> 6;
        int n3 = n & 0x3F;
        return new DataInputBlock(smallDocumentBlockArray[n2]._data, n3);
    }

    public static int calcSize(int n) {
        return n * 64;
    }

    protected int getSmallBlocksPerBigBlock() {
        return this._blocks_per_big_block;
    }

    private static SmallDocumentBlock makeEmptySmallDocumentBlock(POIFSBigBlockSize pOIFSBigBlockSize) {
        SmallDocumentBlock smallDocumentBlock = new SmallDocumentBlock(pOIFSBigBlockSize);
        Arrays.fill(smallDocumentBlock._data, (byte)-1);
        return smallDocumentBlock;
    }

    private static int convertToBlockCount(int n) {
        return (n + 64 - 1) / 64;
    }

    @Override
    public void writeBlocks(OutputStream outputStream) throws IOException {
        outputStream.write(this._data);
    }

    @Override
    public byte[] getData() {
        return this._data;
    }

    public POIFSBigBlockSize getBigBlockSize() {
        return this._bigBlockSize;
    }
}

