/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.storage;

import ai2.org.apache.poi.poifs.common.POIFSBigBlockSize;
import ai2.org.apache.poi.poifs.property.Property;
import ai2.org.apache.poi.poifs.storage.BigBlock;
import ai2.org.apache.poi.poifs.storage.BlockWritable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyBlock
extends BigBlock {
    private Property[] _properties;

    private PropertyBlock(POIFSBigBlockSize pOIFSBigBlockSize, Property[] propertyArray, int n) {
        super(pOIFSBigBlockSize);
        this._properties = new Property[pOIFSBigBlockSize.getPropertiesPerBlock()];
        for (int i = 0; i < this._properties.length; ++i) {
            this._properties[i] = propertyArray[i + n];
        }
    }

    public static BlockWritable[] createPropertyBlockArray(POIFSBigBlockSize pOIFSBigBlockSize, List<Property> list) {
        int n = pOIFSBigBlockSize.getPropertiesPerBlock();
        int n2 = (list.size() + n - 1) / n;
        Property[] propertyArray = new Property[n2 * n];
        System.arraycopy(list.toArray(new Property[0]), 0, propertyArray, 0, list.size());
        for (int i = list.size(); i < propertyArray.length; ++i) {
            propertyArray[i] = new Property(){

                protected void preWrite() {
                }

                public boolean isDirectory() {
                    return false;
                }
            };
        }
        BlockWritable[] blockWritableArray = new BlockWritable[n2];
        for (int i = 0; i < n2; ++i) {
            blockWritableArray[i] = new PropertyBlock(pOIFSBigBlockSize, propertyArray, i * n);
        }
        return blockWritableArray;
    }

    @Override
    void writeData(OutputStream outputStream) throws IOException {
        int n = this.bigBlockSize.getPropertiesPerBlock();
        for (int i = 0; i < n; ++i) {
            this._properties[i].writeData(outputStream);
        }
    }
}

