/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.storage;

import ai2.org.apache.poi.poifs.common.POIFSBigBlockSize;
import ai2.org.apache.poi.poifs.filesystem.BATManaged;
import ai2.org.apache.poi.poifs.storage.BATBlock;
import ai2.org.apache.poi.poifs.storage.BlockWritable;
import ai2.org.apache.poi.poifs.storage.HeaderBlockWriter;
import ai2.org.apache.poi.util.IntList;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class BlockAllocationTableWriter
implements BlockWritable,
BATManaged {
    private IntList _entries;
    private BATBlock[] _blocks;
    private int _start_block;
    private POIFSBigBlockSize _bigBlockSize;

    public BlockAllocationTableWriter(POIFSBigBlockSize pOIFSBigBlockSize) {
        this._bigBlockSize = pOIFSBigBlockSize;
        this._start_block = -2;
        this._entries = new IntList();
        this._blocks = new BATBlock[0];
    }

    public int createBlocks() {
        int n;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            n = BATBlock.calculateStorageRequirements(this._bigBlockSize, n3 + n2 + this._entries.size());
            int n4 = HeaderBlockWriter.calculateXBATStorageRequirements(this._bigBlockSize, n);
            if (n3 == n && n2 == n4) break;
            n3 = n;
            n2 = n4;
        }
        n = this.allocateSpace(n3);
        this.allocateSpace(n2);
        this.simpleCreateBlocks();
        return n;
    }

    public int allocateSpace(int n) {
        int n2 = this._entries.size();
        if (n > 0) {
            int n3 = n - 1;
            int n4 = n2 + 1;
            for (int i = 0; i < n3; ++i) {
                this._entries.add(n4++);
            }
            this._entries.add(-2);
        }
        return n2;
    }

    public int getStartBlock() {
        return this._start_block;
    }

    void simpleCreateBlocks() {
        this._blocks = BATBlock.createBATBlocks(this._bigBlockSize, this._entries.toArray());
    }

    public void writeBlocks(OutputStream outputStream) throws IOException {
        for (int i = 0; i < this._blocks.length; ++i) {
            this._blocks[i].writeBlocks(outputStream);
        }
    }

    public static void writeBlock(BATBlock bATBlock, ByteBuffer byteBuffer) throws IOException {
        bATBlock.writeData(byteBuffer);
    }

    public int countBlocks() {
        return this._blocks.length;
    }

    public void setStartBlock(int n) {
        this._start_block = n;
    }
}

