/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.property;

import ai2.org.apache.poi.poifs.filesystem.BATManaged;
import ai2.org.apache.poi.poifs.property.DirectoryProperty;
import ai2.org.apache.poi.poifs.property.Property;
import ai2.org.apache.poi.poifs.property.RootProperty;
import ai2.org.apache.poi.poifs.storage.HeaderBlock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyTableBase
implements BATManaged {
    private final HeaderBlock _header_block;
    protected final List<Property> _properties;

    public PropertyTableBase(HeaderBlock headerBlock) {
        this._header_block = headerBlock;
        this._properties = new ArrayList<Property>();
        this.addProperty(new RootProperty());
    }

    public PropertyTableBase(HeaderBlock headerBlock, List<Property> list) throws IOException {
        this._header_block = headerBlock;
        this._properties = list;
        this.populatePropertyTree((DirectoryProperty)this._properties.get(0));
    }

    public void addProperty(Property property) {
        this._properties.add(property);
    }

    public void removeProperty(Property property) {
        this._properties.remove(property);
    }

    public RootProperty getRoot() {
        return (RootProperty)this._properties.get(0);
    }

    private void populatePropertyTree(DirectoryProperty directoryProperty) throws IOException {
        int n = directoryProperty.getChildIndex();
        if (!Property.isValidIndex(n)) {
            return;
        }
        Stack<Property> stack = new Stack<Property>();
        stack.push(this._properties.get(n));
        while (!stack.empty()) {
            Property property = (Property)stack.pop();
            if (property == null) continue;
            directoryProperty.addChild(property);
            if (property.isDirectory()) {
                this.populatePropertyTree((DirectoryProperty)property);
            }
            if (Property.isValidIndex(n = property.getPreviousChildIndex())) {
                stack.push(this._properties.get(n));
            }
            if (!Property.isValidIndex(n = property.getNextChildIndex())) continue;
            stack.push(this._properties.get(n));
        }
    }

    public int getStartBlock() {
        return this._header_block.getPropertyStart();
    }

    @Override
    public void setStartBlock(int n) {
        this._header_block.setPropertyStart(n);
    }
}

