/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.property;

import ai2.org.apache.poi.poifs.common.POIFSBigBlockSize;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSStream;
import ai2.org.apache.poi.poifs.property.Property;
import ai2.org.apache.poi.poifs.property.PropertyFactory;
import ai2.org.apache.poi.poifs.property.PropertyTableBase;
import ai2.org.apache.poi.poifs.storage.HeaderBlock;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NPropertyTable
extends PropertyTableBase {
    private static final POILogger _logger = POILogFactory.getLogger(NPropertyTable.class);
    private POIFSBigBlockSize _bigBigBlockSize;

    public NPropertyTable(HeaderBlock headerBlock) {
        super(headerBlock);
        this._bigBigBlockSize = headerBlock.getBigBlockSize();
    }

    public NPropertyTable(HeaderBlock headerBlock, NPOIFSFileSystem nPOIFSFileSystem) throws IOException {
        super(headerBlock, NPropertyTable.buildProperties(new NPOIFSStream(nPOIFSFileSystem, headerBlock.getPropertyStart()).iterator(), headerBlock.getBigBlockSize()));
        this._bigBigBlockSize = headerBlock.getBigBlockSize();
    }

    private static List<Property> buildProperties(Iterator<ByteBuffer> iterator, POIFSBigBlockSize pOIFSBigBlockSize) throws IOException {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        while (iterator.hasNext()) {
            byte[] byArray;
            ByteBuffer byteBuffer = iterator.next();
            if (byteBuffer.hasArray() && byteBuffer.arrayOffset() == 0 && byteBuffer.array().length == pOIFSBigBlockSize.getBigBlockSize()) {
                byArray = byteBuffer.array();
            } else {
                byArray = new byte[pOIFSBigBlockSize.getBigBlockSize()];
                int n = byArray.length;
                if (byteBuffer.remaining() < pOIFSBigBlockSize.getBigBlockSize()) {
                    _logger.log(5, "Short Property Block, ", byteBuffer.remaining(), " bytes instead of the expected " + pOIFSBigBlockSize.getBigBlockSize());
                    n = byteBuffer.remaining();
                }
                byteBuffer.get(byArray, 0, n);
            }
            PropertyFactory.convertToProperties(byArray, arrayList);
        }
        return arrayList;
    }

    @Override
    public int countBlocks() {
        int n = this._properties.size() * 128;
        return (int)Math.ceil(n / this._bigBigBlockSize.getBigBlockSize());
    }

    public void preWrite() {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        int n = 0;
        for (Property property : this._properties) {
            if (property == null) continue;
            property.setIndex(n++);
            arrayList.add(property);
        }
        for (Property property : arrayList) {
            property.preWrite();
        }
    }

    public void write(NPOIFSStream nPOIFSStream) throws IOException {
        OutputStream outputStream = nPOIFSStream.getOutputStream();
        for (Property property : this._properties) {
            if (property == null) continue;
            property.writeData(outputStream);
        }
        outputStream.close();
        if (this.getStartBlock() != nPOIFSStream.getStartBlock()) {
            this.setStartBlock(nPOIFSStream.getStartBlock());
        }
    }
}

