/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.nio;

import ai2.org.apache.poi.poifs.nio.DataSource;
import ai2.org.apache.poi.util.IOUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;

public class FileBackedDataSource
extends DataSource {
    private FileChannel channel;
    private boolean writable;
    private RandomAccessFile srcFile;

    public FileBackedDataSource(File file) throws FileNotFoundException {
        this(FileBackedDataSource.newSrcFile(file, "r"), true);
    }

    public FileBackedDataSource(File file, boolean bl) throws FileNotFoundException {
        this(FileBackedDataSource.newSrcFile(file, bl ? "r" : "rw"), bl);
    }

    public FileBackedDataSource(RandomAccessFile randomAccessFile, boolean bl) {
        this(randomAccessFile.getChannel(), bl);
        this.srcFile = randomAccessFile;
    }

    public FileBackedDataSource(FileChannel fileChannel, boolean bl) {
        this.channel = fileChannel;
        this.writable = !bl;
    }

    public boolean isWriteable() {
        return this.writable;
    }

    public FileChannel getChannel() {
        return this.channel;
    }

    public ByteBuffer read(int n, long l) throws IOException {
        ByteBuffer byteBuffer;
        if (l >= this.size()) {
            throw new IllegalArgumentException("Position " + l + " past the end of the file");
        }
        int n2 = -1;
        if (this.writable) {
            byteBuffer = this.channel.map(FileChannel.MapMode.READ_WRITE, l, n);
            n2 = 0;
        } else {
            this.channel.position(l);
            byteBuffer = ByteBuffer.allocate(n);
            n2 = IOUtils.readFully(this.channel, byteBuffer);
        }
        if (n2 == -1) {
            throw new IllegalArgumentException("Position " + l + " past the end of the file");
        }
        byteBuffer.position(0);
        return byteBuffer;
    }

    public void write(ByteBuffer byteBuffer, long l) throws IOException {
        this.channel.write(byteBuffer, l);
    }

    public void copyTo(OutputStream outputStream) throws IOException {
        WritableByteChannel writableByteChannel = Channels.newChannel(outputStream);
        this.channel.transferTo(0L, this.channel.size(), writableByteChannel);
    }

    public long size() throws IOException {
        return this.channel.size();
    }

    public void close() throws IOException {
        if (this.srcFile != null) {
            this.srcFile.close();
        } else {
            this.channel.close();
        }
    }

    private static RandomAccessFile newSrcFile(File file, String string) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        return new RandomAccessFile(file, string);
    }
}

