/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.nio;

import ai2.org.apache.poi.poifs.nio.DataSource;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ByteArrayBackedDataSource
extends DataSource {
    private byte[] buffer;
    private long size;

    public ByteArrayBackedDataSource(byte[] byArray, int n) {
        this.buffer = byArray;
        this.size = n;
    }

    public ByteArrayBackedDataSource(byte[] byArray) {
        this(byArray, byArray.length);
    }

    public ByteBuffer read(int n, long l) {
        if (l >= this.size) {
            throw new IndexOutOfBoundsException("Unable to read " + n + " bytes from " + l + " in stream of length " + this.size);
        }
        int n2 = (int)Math.min((long)n, this.size - l);
        return ByteBuffer.wrap(this.buffer, (int)l, n2);
    }

    public void write(ByteBuffer byteBuffer, long l) {
        long l2 = l + (long)byteBuffer.capacity();
        if (l2 > (long)this.buffer.length) {
            this.extend(l2);
        }
        byteBuffer.get(this.buffer, (int)l, byteBuffer.capacity());
        if (l2 > this.size) {
            this.size = l2;
        }
    }

    private void extend(long l) {
        long l2 = l - (long)this.buffer.length;
        if ((double)l2 < (double)this.buffer.length * 0.25) {
            l2 = (long)((double)this.buffer.length * 0.25);
        }
        if (l2 < 4096L) {
            l2 = 4096L;
        }
        byte[] byArray = new byte[(int)(l2 + (long)this.buffer.length)];
        System.arraycopy(this.buffer, 0, byArray, 0, (int)this.size);
        this.buffer = byArray;
    }

    public void copyTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buffer, 0, (int)this.size);
    }

    public long size() {
        return this.size;
    }

    public void close() {
        this.buffer = null;
        this.size = -1L;
    }
}

