/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.filesystem;

import ai2.org.apache.poi.poifs.common.POIFSBigBlockSize;
import ai2.org.apache.poi.poifs.common.POIFSConstants;
import ai2.org.apache.poi.poifs.dev.POIFSViewable;
import ai2.org.apache.poi.poifs.filesystem.BATManaged;
import ai2.org.apache.poi.poifs.filesystem.DirectoryEntry;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.DocumentEntry;
import ai2.org.apache.poi.poifs.filesystem.DocumentInputStream;
import ai2.org.apache.poi.poifs.filesystem.DocumentNode;
import ai2.org.apache.poi.poifs.filesystem.EntryNode;
import ai2.org.apache.poi.poifs.filesystem.OPOIFSDocument;
import ai2.org.apache.poi.poifs.filesystem.POIFSWriterListener;
import ai2.org.apache.poi.poifs.property.DirectoryProperty;
import ai2.org.apache.poi.poifs.property.Property;
import ai2.org.apache.poi.poifs.property.PropertyTable;
import ai2.org.apache.poi.poifs.storage.BATBlock;
import ai2.org.apache.poi.poifs.storage.BlockAllocationTableReader;
import ai2.org.apache.poi.poifs.storage.BlockAllocationTableWriter;
import ai2.org.apache.poi.poifs.storage.BlockList;
import ai2.org.apache.poi.poifs.storage.BlockWritable;
import ai2.org.apache.poi.poifs.storage.HeaderBlock;
import ai2.org.apache.poi.poifs.storage.HeaderBlockWriter;
import ai2.org.apache.poi.poifs.storage.RawDataBlockList;
import ai2.org.apache.poi.poifs.storage.SmallBlockTableReader;
import ai2.org.apache.poi.poifs.storage.SmallBlockTableWriter;
import ai2.org.apache.poi.util.CloseIgnoringInputStream;
import ai2.org.apache.poi.util.IOUtils;
import ai2.org.apache.poi.util.LongField;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPOIFSFileSystem
implements POIFSViewable {
    private static final POILogger _logger = POILogFactory.getLogger(OPOIFSFileSystem.class);
    private PropertyTable _property_table;
    private List<OPOIFSDocument> _documents;
    private DirectoryNode _root;
    private POIFSBigBlockSize bigBlockSize = POIFSConstants.SMALLER_BIG_BLOCK_SIZE_DETAILS;

    public static InputStream createNonClosingInputStream(InputStream inputStream) {
        return new CloseIgnoringInputStream(inputStream);
    }

    public OPOIFSFileSystem() {
        HeaderBlock headerBlock = new HeaderBlock(this.bigBlockSize);
        this._property_table = new PropertyTable(headerBlock);
        this._documents = new ArrayList<OPOIFSDocument>();
        this._root = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPOIFSFileSystem(InputStream inputStream) throws IOException {
        this();
        RawDataBlockList rawDataBlockList;
        HeaderBlock headerBlock;
        boolean bl = false;
        try {
            headerBlock = new HeaderBlock(inputStream);
            this.bigBlockSize = headerBlock.getBigBlockSize();
            rawDataBlockList = new RawDataBlockList(inputStream, this.bigBlockSize);
            bl = true;
        }
        finally {
            this.closeInputStream(inputStream, bl);
        }
        new BlockAllocationTableReader(headerBlock.getBigBlockSize(), headerBlock.getBATCount(), headerBlock.getBATArray(), headerBlock.getXBATCount(), headerBlock.getXBATIndex(), rawDataBlockList);
        PropertyTable propertyTable = new PropertyTable(headerBlock, rawDataBlockList);
        this.processProperties(SmallBlockTableReader.getSmallDocumentBlocks(this.bigBlockSize, rawDataBlockList, propertyTable.getRoot(), headerBlock.getSBATStart()), rawDataBlockList, propertyTable.getRoot().getChildren(), null, headerBlock.getPropertyStart());
        this.getRoot().setStorageClsid(propertyTable.getRoot().getStorageClsid());
    }

    protected void closeInputStream(InputStream inputStream, boolean bl) {
        if (inputStream.markSupported() && !(inputStream instanceof ByteArrayInputStream)) {
            String string = "POIFS is closing the supplied input stream of type (" + inputStream.getClass().getName() + ") which supports mark/reset.  " + "This will be a problem for the caller if the stream will still be used.  " + "If that is the case the caller should wrap the input stream to avoid this close logic.  " + "This warning is only temporary and will not be present in future versions of POI.";
            _logger.log(5, new Object[]{string});
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            if (bl) {
                throw new RuntimeException(iOException);
            }
            iOException.printStackTrace();
        }
    }

    public static boolean hasPOIFSHeader(InputStream inputStream) throws IOException {
        byte[] byArray = IOUtils.peekFirst8Bytes(inputStream);
        return OPOIFSFileSystem.hasPOIFSHeader(byArray);
    }

    public static boolean hasPOIFSHeader(byte[] byArray) {
        LongField longField = new LongField(0, byArray);
        return longField.get() == -2226271756974174256L;
    }

    public DocumentEntry createDocument(InputStream inputStream, String string) throws IOException {
        return this.getRoot().createDocument(string, inputStream);
    }

    public DocumentEntry createDocument(String string, int n, POIFSWriterListener pOIFSWriterListener) throws IOException {
        return this.getRoot().createDocument(string, n, pOIFSWriterListener);
    }

    public DirectoryEntry createDirectory(String string) throws IOException {
        return this.getRoot().createDirectory(string);
    }

    public void writeFilesystem(OutputStream outputStream) throws IOException {
        this._property_table.preWrite();
        SmallBlockTableWriter smallBlockTableWriter = new SmallBlockTableWriter(this.bigBlockSize, this._documents, this._property_table.getRoot());
        BlockAllocationTableWriter blockAllocationTableWriter = new BlockAllocationTableWriter(this.bigBlockSize);
        ArrayList<BATManaged> arrayList = new ArrayList<BATManaged>();
        arrayList.addAll(this._documents);
        arrayList.add(this._property_table);
        arrayList.add(smallBlockTableWriter);
        arrayList.add(smallBlockTableWriter.getSBAT());
        for (BATManaged bATManaged : arrayList) {
            int n = bATManaged.countBlocks();
            if (n == 0) continue;
            bATManaged.setStartBlock(blockAllocationTableWriter.allocateSpace(n));
        }
        int n = blockAllocationTableWriter.createBlocks();
        HeaderBlockWriter headerBlockWriter = new HeaderBlockWriter(this.bigBlockSize);
        BATBlock[] bATBlockArray = headerBlockWriter.setBATBlocks(blockAllocationTableWriter.countBlocks(), n);
        headerBlockWriter.setPropertyStart(this._property_table.getStartBlock());
        headerBlockWriter.setSBATStart(smallBlockTableWriter.getSBAT().getStartBlock());
        headerBlockWriter.setSBATBlockCount(smallBlockTableWriter.getSBATBlockCount());
        ArrayList<BlockWritable> arrayList2 = new ArrayList<BlockWritable>();
        arrayList2.add(headerBlockWriter);
        arrayList2.addAll(this._documents);
        arrayList2.add(this._property_table);
        arrayList2.add(smallBlockTableWriter);
        arrayList2.add(smallBlockTableWriter.getSBAT());
        arrayList2.add(blockAllocationTableWriter);
        for (int i = 0; i < bATBlockArray.length; ++i) {
            arrayList2.add(bATBlockArray[i]);
        }
        for (BlockWritable blockWritable : arrayList2) {
            blockWritable.writeBlocks(outputStream);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 2) {
            System.err.println("two arguments required: input filename and output filename");
            System.exit(1);
        }
        FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
        FileOutputStream fileOutputStream = new FileOutputStream(stringArray[1]);
        new OPOIFSFileSystem(fileInputStream).writeFilesystem(fileOutputStream);
        fileInputStream.close();
        fileOutputStream.close();
    }

    public DirectoryNode getRoot() {
        if (this._root == null) {
            this._root = new DirectoryNode((DirectoryProperty)this._property_table.getRoot(), this, null);
        }
        return this._root;
    }

    public DocumentInputStream createDocumentInputStream(String string) throws IOException {
        return this.getRoot().createDocumentInputStream(string);
    }

    void addDocument(OPOIFSDocument oPOIFSDocument) {
        this._documents.add(oPOIFSDocument);
        this._property_table.addProperty(oPOIFSDocument.getDocumentProperty());
    }

    void addDirectory(DirectoryProperty directoryProperty) {
        this._property_table.addProperty(directoryProperty);
    }

    void remove(EntryNode entryNode) {
        this._property_table.removeProperty(entryNode.getProperty());
        if (entryNode.isDocumentEntry()) {
            this._documents.remove(((DocumentNode)entryNode).getDocument());
        }
    }

    private void processProperties(BlockList blockList, BlockList blockList2, Iterator<Property> iterator, DirectoryNode directoryNode, int n) throws IOException {
        while (iterator.hasNext()) {
            DirectoryNode directoryNode2;
            Property property = iterator.next();
            String string = property.getName();
            DirectoryNode directoryNode3 = directoryNode2 = directoryNode == null ? this.getRoot() : directoryNode;
            if (property.isDirectory()) {
                DirectoryNode directoryNode4 = (DirectoryNode)directoryNode2.createDirectory(string);
                directoryNode4.setStorageClsid(property.getStorageClsid());
                this.processProperties(blockList, blockList2, ((DirectoryProperty)property).getChildren(), directoryNode4, n);
                continue;
            }
            int n2 = property.getStartBlock();
            int n3 = property.getSize();
            OPOIFSDocument oPOIFSDocument = null;
            oPOIFSDocument = property.shouldUseSmallBlocks() ? new OPOIFSDocument(string, blockList.fetchBlocks(n2, n), n3) : new OPOIFSDocument(string, blockList2.fetchBlocks(n2, n), n3);
            directoryNode2.createDocument(oPOIFSDocument);
        }
    }

    @Override
    public Object[] getViewableArray() {
        if (this.preferArray()) {
            return this.getRoot().getViewableArray();
        }
        return new Object[0];
    }

    @Override
    public Iterator<Object> getViewableIterator() {
        if (!this.preferArray()) {
            return this.getRoot().getViewableIterator();
        }
        return Collections.emptyList().iterator();
    }

    @Override
    public boolean preferArray() {
        return this.getRoot().preferArray();
    }

    @Override
    public String getShortDescription() {
        return "POIFS FileSystem";
    }

    public int getBigBlockSize() {
        return this.bigBlockSize.getBigBlockSize();
    }

    public POIFSBigBlockSize getBigBlockSizeDetails() {
        return this.bigBlockSize;
    }
}

