/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.filesystem;

import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.DocumentEntry;
import ai2.org.apache.poi.poifs.filesystem.DocumentNode;
import ai2.org.apache.poi.poifs.filesystem.NDocumentInputStream;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSDocument;
import ai2.org.apache.poi.poifs.filesystem.ODocumentInputStream;
import ai2.org.apache.poi.poifs.filesystem.OPOIFSDocument;
import ai2.org.apache.poi.util.LittleEndianInput;
import java.io.IOException;
import java.io.InputStream;

public class DocumentInputStream
extends InputStream
implements LittleEndianInput {
    protected static final int EOF = -1;
    protected static final int SIZE_SHORT = 2;
    protected static final int SIZE_INT = 4;
    protected static final int SIZE_LONG = 8;
    private DocumentInputStream delegate;

    protected DocumentInputStream() {
    }

    public DocumentInputStream(DocumentEntry documentEntry) throws IOException {
        if (!(documentEntry instanceof DocumentNode)) {
            throw new IOException("Cannot open internal document storage");
        }
        DocumentNode documentNode = (DocumentNode)documentEntry;
        DirectoryNode directoryNode = (DirectoryNode)documentEntry.getParent();
        if (documentNode.getDocument() != null) {
            this.delegate = new ODocumentInputStream(documentEntry);
        } else if (directoryNode.getOFileSystem() != null) {
            this.delegate = new ODocumentInputStream(documentEntry);
        } else if (directoryNode.getNFileSystem() != null) {
            this.delegate = new NDocumentInputStream(documentEntry);
        } else {
            throw new IOException("No FileSystem bound on the parent, can't read contents");
        }
    }

    public DocumentInputStream(OPOIFSDocument oPOIFSDocument) {
        this.delegate = new ODocumentInputStream(oPOIFSDocument);
    }

    public DocumentInputStream(NPOIFSDocument nPOIFSDocument) {
        this.delegate = new NDocumentInputStream(nPOIFSDocument);
    }

    public int available() {
        return this.delegate.available();
    }

    public void close() {
        this.delegate.close();
    }

    public void mark(int n) {
        this.delegate.mark(n);
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        return this.delegate.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.delegate.read(byArray, n, n2);
    }

    public void reset() {
        this.delegate.reset();
    }

    public long skip(long l) throws IOException {
        return this.delegate.skip(l);
    }

    public byte readByte() {
        return this.delegate.readByte();
    }

    public double readDouble() {
        return this.delegate.readDouble();
    }

    public short readShort() {
        return (short)this.readUShort();
    }

    public void readFully(byte[] byArray) {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) {
        this.delegate.readFully(byArray, n, n2);
    }

    public long readLong() {
        return this.delegate.readLong();
    }

    public int readInt() {
        return this.delegate.readInt();
    }

    public int readUShort() {
        return this.delegate.readUShort();
    }

    public int readUByte() {
        return this.delegate.readUByte();
    }

    public long readUInt() {
        int n = this.readInt();
        return (long)n & 0xFFFFFFFFL;
    }
}

