/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.dev;

import ai2.org.apache.poi.poifs.filesystem.DirectoryEntry;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.DocumentEntry;
import ai2.org.apache.poi.poifs.filesystem.DocumentInputStream;
import ai2.org.apache.poi.poifs.filesystem.DocumentNode;
import ai2.org.apache.poi.poifs.filesystem.Entry;
import ai2.org.apache.poi.poifs.filesystem.EntryNode;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSStream;
import ai2.org.apache.poi.poifs.property.NPropertyTable;
import ai2.org.apache.poi.poifs.property.PropertyTableBase;
import ai2.org.apache.poi.poifs.storage.HeaderBlock;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Iterator;

public class POIFSDump {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.err.println("Must specify at least one file to dump");
            System.exit(1);
        }
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            if (stringArray[i].equalsIgnoreCase("-dumprops") || stringArray[i].equalsIgnoreCase("-dump-props") || stringArray[i].equalsIgnoreCase("-dump-properties")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-dumpmini") || stringArray[i].equalsIgnoreCase("-dump-mini") || stringArray[i].equalsIgnoreCase("-dump-ministream") || stringArray[i].equalsIgnoreCase("-dump-mini-stream")) {
                bl2 = true;
                continue;
            }
            System.out.println("Dumping " + stringArray[i]);
            FileInputStream fileInputStream = new FileInputStream(stringArray[i]);
            NPOIFSFileSystem nPOIFSFileSystem = new NPOIFSFileSystem(fileInputStream);
            fileInputStream.close();
            DirectoryNode directoryNode = nPOIFSFileSystem.getRoot();
            File file = new File(directoryNode.getName());
            file.mkdir();
            POIFSDump.dump(directoryNode, file);
            if (bl) {
                object = POIFSDump.getHeaderBlock(nPOIFSFileSystem);
                POIFSDump.dump(nPOIFSFileSystem, ((HeaderBlock)object).getPropertyStart(), "properties", file);
            }
            if (!bl2) continue;
            object = POIFSDump.getPropertyTable(nPOIFSFileSystem);
            int n = ((PropertyTableBase)object).getRoot().getStartBlock();
            if (n == -2) {
                System.err.println("No Mini Stream in file");
                continue;
            }
            POIFSDump.dump(nPOIFSFileSystem, n, "mini-stream", file);
        }
    }

    protected static HeaderBlock getHeaderBlock(NPOIFSFileSystem nPOIFSFileSystem) throws Exception {
        Field field = NPOIFSFileSystem.class.getDeclaredField("_header");
        field.setAccessible(true);
        HeaderBlock headerBlock = (HeaderBlock)field.get(nPOIFSFileSystem);
        return headerBlock;
    }

    protected static NPropertyTable getPropertyTable(NPOIFSFileSystem nPOIFSFileSystem) throws Exception {
        Field field = NPOIFSFileSystem.class.getDeclaredField("_property_table");
        field.setAccessible(true);
        NPropertyTable nPropertyTable = (NPropertyTable)field.get(nPOIFSFileSystem);
        return nPropertyTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(DirectoryEntry directoryEntry, File file) throws IOException {
        Iterator<Entry> iterator = directoryEntry.getEntries();
        while (iterator.hasNext()) {
            Object object;
            Entry entry;
            Entry entry2 = iterator.next();
            if (entry2 instanceof DocumentNode) {
                entry = (DocumentNode)entry2;
                object = new DocumentInputStream((DocumentEntry)entry);
                byte[] byArray = new byte[((DocumentNode)entry).getSize()];
                ((DocumentInputStream)object).read(byArray);
                ((DocumentInputStream)object).close();
                FileOutputStream fileOutputStream = new FileOutputStream(new File(file, ((EntryNode)entry).getName().trim()));
                try {
                    ((OutputStream)fileOutputStream).write(byArray);
                    continue;
                }
                finally {
                    ((OutputStream)fileOutputStream).close();
                    continue;
                }
            }
            if (entry2 instanceof DirectoryEntry) {
                entry = (DirectoryEntry)entry2;
                object = new File(file, entry2.getName());
                ((File)object).mkdir();
                POIFSDump.dump((DirectoryEntry)entry, (File)object);
                continue;
            }
            System.err.println("Skipping unsupported POIFS entry: " + entry2);
        }
    }

    public static void dump(NPOIFSFileSystem nPOIFSFileSystem, int n, String string, File file) throws IOException {
        File file2 = new File(file, string);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        NPOIFSStream nPOIFSStream = new NPOIFSStream(nPOIFSFileSystem, n);
        byte[] byArray = new byte[nPOIFSFileSystem.getBigBlockSize()];
        for (ByteBuffer byteBuffer : nPOIFSStream) {
            int n2 = byteBuffer.remaining();
            byteBuffer.get(byArray);
            fileOutputStream.write(byArray, 0, n2);
        }
        fileOutputStream.close();
    }
}

