/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.crypt.dsig.services;

import ai2.org.apache.poi.poifs.crypt.CryptoFunctions;
import ai2.org.apache.poi.poifs.crypt.HashAlgorithm;
import ai2.org.apache.poi.poifs.crypt.dsig.SignatureConfig;
import ai2.org.apache.poi.poifs.crypt.dsig.services.RevocationData;
import ai2.org.apache.poi.poifs.crypt.dsig.services.TimeStampService;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.IOUtils;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.bind.DatatypeConverter;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cmp.PKIFailureInfo;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSSignatureAlgorithmNameGenerator;
import org.bouncycastle.cms.DefaultCMSSignatureAlgorithmNameGenerator;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.bc.BcRSASignerInfoVerifierBuilder;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampToken;

public class TSPTimeStampService
implements TimeStampService {
    private static final POILogger LOG = POILogFactory.getLogger(TSPTimeStampService.class);
    private SignatureConfig signatureConfig;

    public ASN1ObjectIdentifier mapDigestAlgoToOID(HashAlgorithm hashAlgorithm) {
        switch (hashAlgorithm) {
            case sha1: {
                return X509ObjectIdentifiers.id_SHA1;
            }
            case sha256: {
                return NISTObjectIdentifiers.id_sha256;
            }
            case sha384: {
                return NISTObjectIdentifiers.id_sha384;
            }
            case sha512: {
                return NISTObjectIdentifiers.id_sha512;
            }
        }
        throw new IllegalArgumentException("unsupported digest algo: " + (Object)((Object)hashAlgorithm));
    }

    public byte[] timeStamp(byte[] byArray, RevocationData revocationData) throws Exception {
        X509CertificateHolder x509CertificateHolder3;
        int n;
        Object object;
        Object object2;
        MessageDigest messageDigest = CryptoFunctions.getMessageDigest(this.signatureConfig.getTspDigestAlgo());
        byte[] byArray2 = messageDigest.digest(byArray);
        BigInteger bigInteger = new BigInteger(128, new SecureRandom());
        TimeStampRequestGenerator timeStampRequestGenerator = new TimeStampRequestGenerator();
        timeStampRequestGenerator.setCertReq(true);
        String string = this.signatureConfig.getTspRequestPolicy();
        if (string != null) {
            timeStampRequestGenerator.setReqPolicy(new ASN1ObjectIdentifier(string));
        }
        ASN1ObjectIdentifier aSN1ObjectIdentifier = this.mapDigestAlgoToOID(this.signatureConfig.getTspDigestAlgo());
        TimeStampRequest timeStampRequest = timeStampRequestGenerator.generate(aSN1ObjectIdentifier, byArray2, bigInteger);
        byte[] byArray3 = timeStampRequest.getEncoded();
        Proxy proxy = Proxy.NO_PROXY;
        if (this.signatureConfig.getProxyUrl() != null) {
            object2 = new URL(this.signatureConfig.getProxyUrl());
            object = ((URL)object2).getHost();
            n = ((URL)object2).getPort();
            proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress((String)object, n == -1 ? 80 : n));
        }
        object2 = (HttpURLConnection)new URL(this.signatureConfig.getTspUrl()).openConnection(proxy);
        if (this.signatureConfig.getTspUser() != null) {
            object = this.signatureConfig.getTspUser() + ":" + this.signatureConfig.getTspPass();
            String string2 = DatatypeConverter.printBase64Binary((byte[])((String)object).getBytes(Charset.forName("iso-8859-1")));
            ((URLConnection)object2).setRequestProperty("Authorization", "Basic " + string2);
        }
        ((HttpURLConnection)object2).setRequestMethod("POST");
        ((URLConnection)object2).setConnectTimeout(20000);
        ((URLConnection)object2).setReadTimeout(20000);
        ((URLConnection)object2).setDoOutput(true);
        ((URLConnection)object2).setRequestProperty("User-Agent", this.signatureConfig.getUserAgent());
        ((URLConnection)object2).setRequestProperty("Content-Type", this.signatureConfig.isTspOldProtocol() ? "application/timestamp-request" : "application/timestamp-query");
        object = ((URLConnection)object2).getOutputStream();
        ((OutputStream)object).write(byArray3);
        ((URLConnection)object2).connect();
        n = ((HttpURLConnection)object2).getResponseCode();
        if (n != 200) {
            LOG.log(7, "Error contacting TSP server ", this.signatureConfig.getTspUrl());
            throw new IOException("Error contacting TSP server " + this.signatureConfig.getTspUrl());
        }
        String string3 = ((URLConnection)object2).getHeaderField("Content-Type");
        if (null == string3) {
            throw new RuntimeException("missing Content-Type header");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy(((URLConnection)object2).getInputStream(), byteArrayOutputStream);
        LOG.log(1, "response content: ", HexDump.dump(byteArrayOutputStream.toByteArray(), 0L, 0));
        if (!string3.startsWith(this.signatureConfig.isTspOldProtocol() ? "application/timestamp-response" : "application/timestamp-reply")) {
            throw new RuntimeException("invalid Content-Type: " + string3);
        }
        if (byteArrayOutputStream.size() == 0) {
            throw new RuntimeException("Content-Length is zero");
        }
        TimeStampResponse timeStampResponse = new TimeStampResponse(byteArrayOutputStream.toByteArray());
        timeStampResponse.validate(timeStampRequest);
        if (0 != timeStampResponse.getStatus()) {
            LOG.log(1, new Object[]{"status: " + timeStampResponse.getStatus()});
            LOG.log(1, new Object[]{"status string: " + timeStampResponse.getStatusString()});
            PKIFailureInfo pKIFailureInfo = timeStampResponse.getFailInfo();
            if (null != pKIFailureInfo) {
                LOG.log(1, new Object[]{"fail info int value: " + pKIFailureInfo.intValue()});
                if (256 == pKIFailureInfo.intValue()) {
                    LOG.log(1, new Object[]{"unaccepted policy"});
                }
            }
            throw new RuntimeException("timestamp response status != 0: " + timeStampResponse.getStatus());
        }
        TimeStampToken timeStampToken = timeStampResponse.getTimeStampToken();
        SignerId signerId = timeStampToken.getSID();
        BigInteger bigInteger2 = signerId.getSerialNumber();
        X500Name x500Name = signerId.getIssuer();
        LOG.log(1, new Object[]{"signer cert serial number: " + bigInteger2});
        LOG.log(1, new Object[]{"signer cert issuer: " + x500Name});
        Collection collection = timeStampToken.getCertificates().getMatches(null);
        X509CertificateHolder x509CertificateHolder2 = null;
        HashMap<X500Name, X509CertificateHolder> hashMap = new HashMap<X500Name, X509CertificateHolder>();
        for (X509CertificateHolder x509CertificateHolder3 : collection) {
            if (x500Name.equals((Object)x509CertificateHolder3.getIssuer()) && bigInteger2.equals(x509CertificateHolder3.getSerialNumber())) {
                x509CertificateHolder2 = x509CertificateHolder3;
            }
            hashMap.put(x509CertificateHolder3.getSubject(), x509CertificateHolder3);
        }
        if (x509CertificateHolder2 == null) {
            throw new RuntimeException("TSP response token has no signer certificate");
        }
        ArrayList arrayList = new ArrayList();
        x509CertificateHolder3 = new JcaX509CertificateConverter();
        x509CertificateHolder3.setProvider("BC");
        X509CertificateHolder x509CertificateHolder4 = x509CertificateHolder2;
        do {
            LOG.log(1, new Object[]{"adding to certificate chain: " + x509CertificateHolder4.getSubject()});
            arrayList.add(x509CertificateHolder3.getCertificate(x509CertificateHolder4));
        } while (!x509CertificateHolder4.getSubject().equals((Object)x509CertificateHolder4.getIssuer()) && null != (x509CertificateHolder4 = (X509CertificateHolder)hashMap.get(x509CertificateHolder4.getIssuer())));
        X509CertificateHolder x509CertificateHolder5 = new X509CertificateHolder(((X509Certificate)arrayList.get(0)).getEncoded());
        DefaultCMSSignatureAlgorithmNameGenerator defaultCMSSignatureAlgorithmNameGenerator = new DefaultCMSSignatureAlgorithmNameGenerator();
        DefaultSignatureAlgorithmIdentifierFinder defaultSignatureAlgorithmIdentifierFinder = new DefaultSignatureAlgorithmIdentifierFinder();
        DefaultDigestAlgorithmIdentifierFinder defaultDigestAlgorithmIdentifierFinder = new DefaultDigestAlgorithmIdentifierFinder();
        BcDigestCalculatorProvider bcDigestCalculatorProvider = new BcDigestCalculatorProvider();
        BcRSASignerInfoVerifierBuilder bcRSASignerInfoVerifierBuilder = new BcRSASignerInfoVerifierBuilder((CMSSignatureAlgorithmNameGenerator)defaultCMSSignatureAlgorithmNameGenerator, (SignatureAlgorithmIdentifierFinder)defaultSignatureAlgorithmIdentifierFinder, (DigestAlgorithmIdentifierFinder)defaultDigestAlgorithmIdentifierFinder, (DigestCalculatorProvider)bcDigestCalculatorProvider);
        SignerInformationVerifier signerInformationVerifier = bcRSASignerInfoVerifierBuilder.build(x509CertificateHolder5);
        timeStampToken.validate(signerInformationVerifier);
        if (this.signatureConfig.getTspValidator() != null) {
            this.signatureConfig.getTspValidator().validate(arrayList, revocationData);
        }
        LOG.log(1, new Object[]{"time-stamp token time: " + timeStampToken.getTimeStampInfo().getGenTime()});
        byte[] byArray4 = timeStampToken.getEncoded();
        return byArray4;
    }

    public void setSignatureConfig(SignatureConfig signatureConfig) {
        this.signatureConfig = signatureConfig;
    }
}

