/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.crypt.dsig.services;

import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import ai2.org.apache.poi.util.XmlSort;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.xpackage.x2006.digitalSignature.CTRelationshipReference;
import org.openxmlformats.schemas.xpackage.x2006.digitalSignature.RelationshipReferenceDocument;
import org.openxmlformats.schemas.xpackage.x2006.relationships.CTRelationship;
import org.openxmlformats.schemas.xpackage.x2006.relationships.CTRelationships;
import org.openxmlformats.schemas.xpackage.x2006.relationships.RelationshipsDocument;
import org.openxmlformats.schemas.xpackage.x2006.relationships.STTargetMode;
import org.w3.x2000.x09.xmldsig.TransformDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RelationshipTransformService
extends TransformService {
    public static final String TRANSFORM_URI = "http://schemas.openxmlformats.org/package/2006/RelationshipTransform";
    private final List<String> sourceIds;
    private static final POILogger LOG = POILogFactory.getLogger(RelationshipTransformService.class);

    public RelationshipTransformService() {
        LOG.log(1, new Object[]{"constructor"});
        this.sourceIds = new ArrayList<String>();
    }

    public static synchronized void registerDsigProvider() {
        if (Security.getProperty("POIXmlDsigProvider") == null) {
            Provider provider = new Provider("POIXmlDsigProvider", 1.0, "POIXmlDsigProvider"){
                static final long serialVersionUID = 1L;
            };
            provider.put("TransformService.http://schemas.openxmlformats.org/package/2006/RelationshipTransform", RelationshipTransformService.class.getName());
            provider.put("TransformService.http://schemas.openxmlformats.org/package/2006/RelationshipTransform MechanismType", "DOM");
            Security.addProvider(provider);
        }
    }

    public void init(TransformParameterSpec transformParameterSpec) throws InvalidAlgorithmParameterException {
        LOG.log(1, new Object[]{"init(params)"});
        if (!(transformParameterSpec instanceof RelationshipTransformParameterSpec)) {
            throw new InvalidAlgorithmParameterException();
        }
        RelationshipTransformParameterSpec relationshipTransformParameterSpec = (RelationshipTransformParameterSpec)transformParameterSpec;
        for (String string : relationshipTransformParameterSpec.sourceIds) {
            this.sourceIds.add(string);
        }
    }

    public void init(XMLStructure xMLStructure, XMLCryptoContext xMLCryptoContext) throws InvalidAlgorithmParameterException {
        LOG.log(1, new Object[]{"init(parent,context)"});
        LOG.log(1, new Object[]{"parent java type: " + xMLStructure.getClass().getName()});
        DOMStructure dOMStructure = (DOMStructure)xMLStructure;
        Node node = dOMStructure.getNode();
        try {
            TransformDocument transformDocument = TransformDocument.Factory.parse((Node)node);
            XmlObject[] xmlObjectArray = transformDocument.getTransform().selectChildren(RelationshipReferenceDocument.type.getDocumentElementName());
            if (xmlObjectArray.length == 0) {
                LOG.log(5, new Object[]{"no RelationshipReference/@SourceId parameters present"});
            }
            for (XmlObject xmlObject : xmlObjectArray) {
                String string = ((CTRelationshipReference)xmlObject).getSourceId();
                LOG.log(1, "sourceId: ", string);
                this.sourceIds.add(string);
            }
        }
        catch (XmlException xmlException) {
            throw new InvalidAlgorithmParameterException(xmlException);
        }
    }

    public void marshalParams(XMLStructure xMLStructure, XMLCryptoContext xMLCryptoContext) throws MarshalException {
        LOG.log(1, new Object[]{"marshallParams(parent,context)"});
        DOMStructure dOMStructure = (DOMStructure)xMLStructure;
        Element element = (Element)dOMStructure.getNode();
        Document document = element.getOwnerDocument();
        for (String string : this.sourceIds) {
            RelationshipReferenceDocument relationshipReferenceDocument = RelationshipReferenceDocument.Factory.newInstance();
            relationshipReferenceDocument.addNewRelationshipReference().setSourceId(string);
            Node node = relationshipReferenceDocument.getRelationshipReference().getDomNode();
            node = document.importNode(node, true);
            element.appendChild(node);
        }
    }

    public AlgorithmParameterSpec getParameterSpec() {
        LOG.log(1, new Object[]{"getParameterSpec"});
        return null;
    }

    public Data transform(Data data, XMLCryptoContext xMLCryptoContext) throws TransformException {
        Object object;
        RelationshipsDocument relationshipsDocument;
        LOG.log(1, new Object[]{"transform(data,context)"});
        LOG.log(1, new Object[]{"data java type: " + data.getClass().getName()});
        OctetStreamData octetStreamData = (OctetStreamData)data;
        LOG.log(1, new Object[]{"URI: " + octetStreamData.getURI()});
        InputStream inputStream = octetStreamData.getOctetStream();
        try {
            relationshipsDocument = RelationshipsDocument.Factory.parse((InputStream)inputStream);
        }
        catch (Exception exception) {
            throw new TransformException(exception.getMessage(), exception);
        }
        LOG.log(1, "relationships document", relationshipsDocument);
        CTRelationships cTRelationships = relationshipsDocument.getRelationships();
        List list = cTRelationships.getRelationshipList();
        Iterator iterator = cTRelationships.getRelationshipList().iterator();
        while (iterator.hasNext()) {
            object = (CTRelationship)iterator.next();
            if (!this.sourceIds.contains(object.getId())) {
                LOG.log(1, new Object[]{"removing element: " + object.getId()});
                iterator.remove();
                continue;
            }
            if (object.isSetTargetMode()) continue;
            object.setTargetMode(STTargetMode.INTERNAL);
        }
        LOG.log(1, "# Relationship elements", list.size());
        XmlSort.sort((XmlObject)cTRelationships, new Comparator<XmlCursor>(){

            @Override
            public int compare(XmlCursor xmlCursor, XmlCursor xmlCursor2) {
                String string = ((CTRelationship)xmlCursor.getObject()).getId();
                String string2 = ((CTRelationship)xmlCursor2.getObject()).getId();
                return string.compareTo(string2);
            }
        });
        try {
            object = new ByteArrayOutputStream();
            XmlOptions xmlOptions = new XmlOptions();
            xmlOptions.setSaveNoXmlDecl();
            relationshipsDocument.save((OutputStream)object, xmlOptions);
            return new OctetStreamData(new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray()));
        }
        catch (IOException iOException) {
            throw new TransformException(iOException.getMessage(), iOException);
        }
    }

    public Data transform(Data data, XMLCryptoContext xMLCryptoContext, OutputStream outputStream) throws TransformException {
        LOG.log(1, new Object[]{"transform(data,context,os)"});
        return null;
    }

    public boolean isFeatureSupported(String string) {
        LOG.log(1, new Object[]{"isFeatureSupported(feature)"});
        return false;
    }

    public static class RelationshipTransformParameterSpec
    implements TransformParameterSpec {
        List<String> sourceIds = new ArrayList<String>();

        public void addRelationshipReference(String string) {
            this.sourceIds.add(string);
        }

        public boolean hasSourceIds() {
            return !this.sourceIds.isEmpty();
        }
    }
}

