/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.crypt.dsig.facets;

import ai2.org.apache.poi.poifs.crypt.CryptoFunctions;
import ai2.org.apache.poi.poifs.crypt.HashAlgorithm;
import ai2.org.apache.poi.poifs.crypt.dsig.SignatureConfig;
import ai2.org.apache.poi.poifs.crypt.dsig.facets.SignatureFacet;
import ai2.org.apache.poi.poifs.crypt.dsig.services.SignaturePolicyService;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.security.MessageDigest;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignatureException;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlString;
import org.etsi.uri.x01903.v13.AnyType;
import org.etsi.uri.x01903.v13.CertIDListType;
import org.etsi.uri.x01903.v13.CertIDType;
import org.etsi.uri.x01903.v13.DataObjectFormatType;
import org.etsi.uri.x01903.v13.DigestAlgAndValueType;
import org.etsi.uri.x01903.v13.IdentifierType;
import org.etsi.uri.x01903.v13.QualifyingPropertiesDocument;
import org.etsi.uri.x01903.v13.QualifyingPropertiesType;
import org.etsi.uri.x01903.v13.SigPolicyQualifiersListType;
import org.etsi.uri.x01903.v13.SignedPropertiesType;
import org.etsi.uri.x01903.v13.SignedSignaturePropertiesType;
import org.etsi.uri.x01903.v13.SignerRoleType;
import org.w3.x2000.x09.xmldsig.DigestMethodType;
import org.w3.x2000.x09.xmldsig.X509IssuerSerialType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XAdESSignatureFacet
extends SignatureFacet {
    private static final POILogger LOG = POILogFactory.getLogger(XAdESSignatureFacet.class);
    private static final String XADES_TYPE = "http://uri.etsi.org/01903#SignedProperties";
    private Map<String, String> dataObjectFormatMimeTypes = new HashMap<String, String>();

    @Override
    public void preSign(Document document, List<Reference> list, List<XMLObject> list2) throws XMLSignatureException {
        Object object;
        Object object2;
        Object object3;
        Object object5;
        Object object6;
        Object object7;
        SignaturePolicyService signaturePolicyService;
        LOG.log(1, new Object[]{"preSign"});
        QualifyingPropertiesDocument qualifyingPropertiesDocument = QualifyingPropertiesDocument.Factory.newInstance();
        QualifyingPropertiesType qualifyingPropertiesType = qualifyingPropertiesDocument.addNewQualifyingProperties();
        qualifyingPropertiesType.setTarget("#" + this.signatureConfig.getPackageSignatureId());
        SignedPropertiesType signedPropertiesType = qualifyingPropertiesType.addNewSignedProperties();
        signedPropertiesType.setId(this.signatureConfig.getXadesSignatureId());
        SignedSignaturePropertiesType signedSignaturePropertiesType = signedPropertiesType.addNewSignedSignatureProperties();
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("Z"), Locale.ROOT);
        calendar.setTime(this.signatureConfig.getExecutionTime());
        calendar.clear(14);
        signedSignaturePropertiesType.setSigningTime(calendar);
        if (this.signatureConfig.getSigningCertificateChain() == null || this.signatureConfig.getSigningCertificateChain().isEmpty()) {
            throw new RuntimeException("no signing certificate chain available");
        }
        CertIDListType certIDListType = signedSignaturePropertiesType.addNewSigningCertificate();
        CertIDType certIDType = certIDListType.addNewCert();
        X509Certificate x509Certificate = this.signatureConfig.getSigningCertificateChain().get(0);
        XAdESSignatureFacet.setCertID(certIDType, this.signatureConfig, this.signatureConfig.isXadesIssuerNameNoReverseOrder(), x509Certificate);
        String string = this.signatureConfig.getXadesRole();
        if (string != null && !string.isEmpty()) {
            signaturePolicyService = signedSignaturePropertiesType.addNewSignerRole();
            signedSignaturePropertiesType.setSignerRole((SignerRoleType)signaturePolicyService);
            object7 = signaturePolicyService.addNewClaimedRoles();
            object6 = object7.addNewClaimedRole();
            object5 = XmlString.Factory.newInstance();
            object5.setStringValue(string);
            XAdESSignatureFacet.insertXChild((XmlObject)object6, (XmlObject)object5);
        }
        if ((signaturePolicyService = this.signatureConfig.getSignaturePolicyService()) != null) {
            object7 = signedSignaturePropertiesType.addNewSignaturePolicyIdentifier();
            object6 = object7.addNewSignaturePolicyId();
            object5 = object6.addNewSigPolicyId();
            object5.setDescription(signaturePolicyService.getSignaturePolicyDescription());
            IdentifierType object42 = object5.addNewIdentifier();
            object42.setStringValue(signaturePolicyService.getSignaturePolicyIdentifier());
            object3 = signaturePolicyService.getSignaturePolicyDocument();
            object2 = object6.addNewSigPolicyHash();
            XAdESSignatureFacet.setDigestAlgAndValue(object2, (byte[])object3, this.signatureConfig.getDigestAlgo());
            object = signaturePolicyService.getSignaturePolicyDownloadUrl();
            if (null != object) {
                SigPolicyQualifiersListType sigPolicyQualifiersListType = object6.addNewSigPolicyQualifiers();
                AnyType anyType = sigPolicyQualifiersListType.addNewSigPolicyQualifier();
                XmlString xmlString = XmlString.Factory.newInstance();
                xmlString.setStringValue((String)object);
                XAdESSignatureFacet.insertXChild((XmlObject)anyType, (XmlObject)xmlString);
            }
        } else if (this.signatureConfig.isXadesSignaturePolicyImplied()) {
            object7 = signedSignaturePropertiesType.addNewSignaturePolicyIdentifier();
            object7.addNewSignaturePolicyImplied();
        }
        if (!this.dataObjectFormatMimeTypes.isEmpty()) {
            object7 = signedPropertiesType.addNewSignedDataObjectProperties();
            object6 = object7.getDataObjectFormatList();
            for (Map.Entry entry : this.dataObjectFormatMimeTypes.entrySet()) {
                object3 = DataObjectFormatType.Factory.newInstance();
                object3.setObjectReference("#" + (String)entry.getKey());
                object3.setMimeType((String)entry.getValue());
                object6.add(object3);
            }
        }
        object7 = new ArrayList();
        object6 = (Element)qualifyingPropertiesType.getDomNode();
        object5 = (Element)document.importNode((Node)object6, true);
        object7.add(new DOMStructure((Node)object5));
        XMLObject xMLObject = this.getSignatureFactory().newXMLObject((List<? extends XMLStructure>)object7, null, null, null);
        list2.add(xMLObject);
        object3 = new ArrayList();
        object2 = this.newTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        object3.add(object2);
        object = this.newReference("#" + this.signatureConfig.getXadesSignatureId(), (List<Transform>)object3, XADES_TYPE, null, null);
        list.add((Reference)object);
    }

    protected static void setDigestAlgAndValue(DigestAlgAndValueType digestAlgAndValueType, byte[] byArray, HashAlgorithm hashAlgorithm) {
        DigestMethodType digestMethodType = digestAlgAndValueType.addNewDigestMethod();
        digestMethodType.setAlgorithm(SignatureConfig.getDigestMethodUri(hashAlgorithm));
        MessageDigest messageDigest = CryptoFunctions.getMessageDigest(hashAlgorithm);
        byte[] byArray2 = messageDigest.digest(byArray);
        digestAlgAndValueType.setDigestValue(byArray2);
    }

    protected static void setCertID(CertIDType certIDType, SignatureConfig signatureConfig, boolean bl, X509Certificate x509Certificate) {
        byte[] byArray;
        X509IssuerSerialType x509IssuerSerialType = certIDType.addNewIssuerSerial();
        String string = bl ? x509Certificate.getIssuerDN().getName().replace(",", ", ") : x509Certificate.getIssuerX500Principal().toString();
        x509IssuerSerialType.setX509IssuerName(string);
        x509IssuerSerialType.setX509SerialNumber(x509Certificate.getSerialNumber());
        try {
            byArray = x509Certificate.getEncoded();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new RuntimeException("certificate encoding error: " + certificateEncodingException.getMessage(), certificateEncodingException);
        }
        DigestAlgAndValueType digestAlgAndValueType = certIDType.addNewCertDigest();
        XAdESSignatureFacet.setDigestAlgAndValue(digestAlgAndValueType, byArray, signatureConfig.getXadesDigestAlgo());
    }

    public void addMimeType(String string, String string2) {
        this.dataObjectFormatMimeTypes.put(string, string2);
    }

    protected static void insertXChild(XmlObject xmlObject, XmlObject xmlObject2) {
        XmlCursor xmlCursor = xmlObject.newCursor();
        xmlCursor.toEndToken();
        XmlCursor xmlCursor2 = xmlObject2.newCursor();
        xmlCursor2.toNextToken();
        xmlCursor2.moveXml(xmlCursor);
        xmlCursor2.dispose();
        xmlCursor.dispose();
    }
}

