/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.crypt.dsig.facets;

import ai2.org.apache.poi.poifs.crypt.dsig.SignatureConfig;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import org.apache.jcp.xml.dsig.internal.dom.DOMDigestMethod;
import org.apache.jcp.xml.dsig.internal.dom.DOMReference;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SignatureFacet
implements SignatureConfig.SignatureConfigurable {
    private static final POILogger LOG = POILogFactory.getLogger(SignatureFacet.class);
    public static final String XML_NS = "http://www.w3.org/2000/xmlns/";
    public static final String XML_DIGSIG_NS = "http://www.w3.org/2000/09/xmldsig#";
    public static final String OO_DIGSIG_NS = "http://schemas.openxmlformats.org/package/2006/digital-signature";
    public static final String MS_DIGSIG_NS = "http://schemas.microsoft.com/office/2006/digsig";
    public static final String XADES_132_NS = "http://uri.etsi.org/01903/v1.3.2#";
    public static final String XADES_141_NS = "http://uri.etsi.org/01903/v1.4.1#";
    protected SignatureConfig signatureConfig;

    @Override
    public void setSignatureConfig(SignatureConfig signatureConfig) {
        this.signatureConfig = signatureConfig;
    }

    public void preSign(Document document, List<Reference> list, List<XMLObject> list2) throws XMLSignatureException {
    }

    public void postSign(Document document) throws MarshalException {
    }

    protected XMLSignatureFactory getSignatureFactory() {
        return this.signatureConfig.getSignatureFactory();
    }

    protected Transform newTransform(String string) throws XMLSignatureException {
        return this.newTransform(string, null);
    }

    protected Transform newTransform(String string, TransformParameterSpec transformParameterSpec) throws XMLSignatureException {
        try {
            return this.getSignatureFactory().newTransform(string, transformParameterSpec);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new XMLSignatureException("unknown canonicalization method: " + string, generalSecurityException);
        }
    }

    protected Reference newReference(String string, List<Transform> list, String string2, String string3, byte[] byArray) throws XMLSignatureException {
        return SignatureFacet.newReference(string, list, string2, string3, byArray, this.signatureConfig);
    }

    public static Reference newReference(String string, List<Transform> list, String string2, String string3, byte[] byArray, SignatureConfig signatureConfig) throws XMLSignatureException {
        DigestMethod digestMethod;
        String string4 = signatureConfig.getDigestMethodUri();
        XMLSignatureFactory xMLSignatureFactory = signatureConfig.getSignatureFactory();
        try {
            digestMethod = xMLSignatureFactory.newDigestMethod(string4, null);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new XMLSignatureException("unknown digest method uri: " + string4, generalSecurityException);
        }
        Reference reference = byArray == null ? xMLSignatureFactory.newReference(string, digestMethod, list, string2, string3) : xMLSignatureFactory.newReference(string, digestMethod, list, string2, string3, byArray);
        SignatureFacet.brokenJvmWorkaround(reference);
        return reference;
    }

    public static void brokenJvmWorkaround(Reference reference) {
        DigestMethod digestMethod = reference.getDigestMethod();
        String string = digestMethod.getAlgorithm();
        Provider provider = Security.getProvider("BC");
        if (provider != null && !"http://www.w3.org/2000/09/xmldsig#sha1".equals(string)) {
            try {
                Method method = DOMDigestMethod.class.getDeclaredMethod("getMessageDigestAlgorithm", new Class[0]);
                method.setAccessible(true);
                String string2 = (String)method.invoke((Object)digestMethod, new Object[0]);
                MessageDigest messageDigest = MessageDigest.getInstance(string2, provider);
                Field field = DOMReference.class.getDeclaredField("md");
                field.setAccessible(true);
                field.set(reference, messageDigest);
            }
            catch (Exception exception) {
                LOG.log(5, new Object[]{"Can't overwrite message digest (workaround for https://bugzilla.redhat.com/show_bug.cgi?id=1155012)", exception});
            }
        }
    }
}

