/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.crypt.dsig.facets;

import ai2.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import ai2.org.apache.poi.openxml4j.opc.OPCPackage;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackagePartName;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import ai2.org.apache.poi.openxml4j.opc.PackagingURIHelper;
import ai2.org.apache.poi.openxml4j.opc.TargetMode;
import ai2.org.apache.poi.poifs.crypt.dsig.facets.SignatureFacet;
import ai2.org.apache.poi.poifs.crypt.dsig.services.RelationshipTransformService;
import ai2.org.apache.poi.util.LocaleUtil;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import com.microsoft.schemas.office.x2006.digsig.CTSignatureInfoV1;
import com.microsoft.schemas.office.x2006.digsig.SignatureInfoV1Document;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.Manifest;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureProperties;
import javax.xml.crypto.dsig.SignatureProperty;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignatureException;
import org.openxmlformats.schemas.xpackage.x2006.digitalSignature.CTSignatureTime;
import org.openxmlformats.schemas.xpackage.x2006.digitalSignature.SignatureTimeDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OOXMLSignatureFacet
extends SignatureFacet {
    private static final POILogger LOG = POILogFactory.getLogger(OOXMLSignatureFacet.class);
    public static final String[] contentTypes = new String[]{"application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml", "application/vnd.openxmlformats-officedocument.wordprocessingml.fontTable+xml", "application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml", "application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml", "application/vnd.openxmlformats-officedocument.theme+xml", "application/vnd.openxmlformats-officedocument.wordprocessingml.webSettings+xml", "application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml", "application/vnd.ms-word.stylesWithEffects+xml", "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml", "application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml", "application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml", "application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml", "application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml", "application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml", "application/vnd.openxmlformats-officedocument.presentationml.slide+xml", "application/vnd.openxmlformats-officedocument.presentationml.tableStyles+xml", "application/vnd.openxmlformats-officedocument.presentationml.viewProps+xml", "application/vnd.openxmlformats-officedocument.presentationml.presProps+xml"};
    public static final String[] signed = new String[]{"powerPivotData", "activeXControlBinary", "attachedToolbars", "connectorXml", "downRev", "functionPrototypes", "graphicFrameDoc", "groupShapeXml", "ink", "keyMapCustomizations", "legacyDiagramText", "legacyDocTextInfo", "officeDocument", "pictureXml", "shapeXml", "smartTags", "ui/altText", "ui/buttonSize", "ui/controlID", "ui/description", "ui/enabled", "ui/extensibility", "ui/helperText", "ui/imageID", "ui/imageMso", "ui/keyTip", "ui/label", "ui/lcid", "ui/loud", "ui/pressed", "ui/progID", "ui/ribbonID", "ui/showImage", "ui/showLabel", "ui/supertip", "ui/target", "ui/text", "ui/title", "ui/tooltip", "ui/userCustomization", "ui/visible", "userXmlData", "vbaProject", "wordVbaData", "wsSortMap", "xlBinaryIndex", "xlExternalLinkPath/xlAlternateStartup", "xlExternalLinkPath/xlLibrary", "xlExternalLinkPath/xlPathMissing", "xlExternalLinkPath/xlStartup", "xlIntlMacrosheet", "xlMacrosheet", "customData", "diagramDrawing", "hdphoto", "inkXml", "media", "slicer", "slicerCache", "stylesWithEffects", "ui/extensibility", "chartColorStyle", "chartLayout", "chartStyle", "dictionary", "timeline", "timelineCache", "aFChunk", "attachedTemplate", "audio", "calcChain", "chart", "chartsheet", "chartUserShapes", "commentAuthors", "comments", "connections", "control", "customProperty", "customXml", "diagramColors", "diagramData", "diagramLayout", "diagramQuickStyle", "dialogsheet", "drawing", "endnotes", "externalLink", "externalLinkPath", "font", "fontTable", "footer", "footnotes", "glossaryDocument", "handoutMaster", "header", "hyperlink", "image", "mailMergeHeaderSource", "mailMergeRecipientData", "mailMergeSource", "notesMaster", "notesSlide", "numbering", "officeDocument", "oleObject", "package", "pivotCacheDefinition", "pivotCacheRecords", "pivotTable", "presProps", "printerSettings", "queryTable", "recipientData", "settings", "sharedStrings", "sheetMetadata", "slide", "slideLayout", "slideMaster", "slideUpdateInfo", "slideUpdateUrl", "styles", "table", "tableSingleCells", "tableStyles", "tags", "theme", "themeOverride", "transform", "video", "viewProps", "volatileDependencies", "webSettings", "worksheet", "xmlMaps", "ctrlProp", "customData", "diagram", "diagramColorsHeader", "diagramLayoutHeader", "diagramQuickStyleHeader", "documentParts", "slicer", "slicerCache", "vmlDrawing"};

    @Override
    public void preSign(Document document, List<Reference> list, List<XMLObject> list2) throws XMLSignatureException {
        LOG.log(1, new Object[]{"pre sign"});
        this.addManifestObject(document, list, list2);
        this.addSignatureInfo(document, list, list2);
    }

    protected void addManifestObject(Document document, List<Reference> list, List<XMLObject> list2) throws XMLSignatureException {
        ArrayList<Reference> arrayList = new ArrayList<Reference>();
        this.addManifestReferences(arrayList);
        Manifest manifest = this.getSignatureFactory().newManifest(arrayList);
        String string = "idPackageObject";
        ArrayList<XMLStructure> arrayList2 = new ArrayList<XMLStructure>();
        arrayList2.add(manifest);
        this.addSignatureTime(document, arrayList2);
        XMLObject xMLObject = this.getSignatureFactory().newXMLObject(arrayList2, string, null, null);
        list2.add(xMLObject);
        Reference reference = this.newReference("#" + string, null, "http://www.w3.org/2000/09/xmldsig#Object", null, null);
        list.add(reference);
    }

    protected void addManifestReferences(List<Reference> list) throws XMLSignatureException {
        OPCPackage oPCPackage = this.signatureConfig.getOpcPackage();
        ArrayList<PackagePart> arrayList = oPCPackage.getPartsByContentType("application/vnd.openxmlformats-package.relationships+xml");
        HashSet<String> hashSet = new HashSet<String>();
        for (PackagePart packagePart : arrayList) {
            Object object;
            Object object22;
            PackageRelationshipCollection packageRelationshipCollection;
            String string = packagePart.getPartName().getName().replaceFirst("(.*)/_rels/.*", "$1");
            try {
                packageRelationshipCollection = new PackageRelationshipCollection(oPCPackage);
                packageRelationshipCollection.parseRelationshipsPart(packagePart);
            }
            catch (InvalidFormatException invalidFormatException) {
                throw new XMLSignatureException("Invalid relationship descriptor: " + packagePart.getPartName().getName(), invalidFormatException);
            }
            RelationshipTransformService.RelationshipTransformParameterSpec relationshipTransformParameterSpec = new RelationshipTransformService.RelationshipTransformParameterSpec();
            for (Object object22 : packageRelationshipCollection) {
                String string2;
                Object object3;
                Object object4;
                object = ((PackageRelationship)object22).getRelationshipType();
                if (TargetMode.EXTERNAL == ((PackageRelationship)object22).getTargetMode() || !OOXMLSignatureFacet.isSignedRelationship((String)object)) continue;
                relationshipTransformParameterSpec.addRelationshipReference(((PackageRelationship)object22).getId());
                String string3 = string + ((PackageRelationship)object22).getTargetURI().toString();
                try {
                    string3 = new URI(string3).normalize().getPath().replace('\\', '/');
                    LOG.log(1, new Object[]{"part name: " + string3});
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new XMLSignatureException(uRISyntaxException);
                }
                try {
                    object4 = PackagingURIHelper.createPartName(string3);
                    object3 = oPCPackage.getPart((PackagePartName)object4);
                    string2 = ((PackagePart)object3).getContentType();
                }
                catch (InvalidFormatException invalidFormatException) {
                    throw new XMLSignatureException(invalidFormatException);
                }
                if (((String)object).endsWith("customXml") && !string2.equals("inkml+xml") && !string2.equals("text/xml")) {
                    LOG.log(1, new Object[]{"skipping customXml with content type: " + string2});
                    continue;
                }
                if (hashSet.contains(string3)) continue;
                object4 = string3 + "?ContentType=" + string2;
                object3 = this.newReference((String)object4, null, null, null, null);
                list.add((Reference)object3);
                hashSet.add(string3);
            }
            if (!relationshipTransformParameterSpec.hasSourceIds()) continue;
            ArrayList arrayList2 = new ArrayList();
            arrayList2.add(this.newTransform("http://schemas.openxmlformats.org/package/2006/RelationshipTransform", relationshipTransformParameterSpec));
            arrayList2.add(this.newTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315"));
            object22 = packagePart.getPartName().getName() + "?ContentType=application/vnd.openxmlformats-package.relationships+xml";
            object = this.newReference((String)object22, arrayList2, null, null, null);
            list.add((Reference)object);
        }
    }

    protected void addSignatureTime(Document document, List<XMLStructure> list) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ROOT);
        simpleDateFormat.setTimeZone(LocaleUtil.TIMEZONE_UTC);
        String string = simpleDateFormat.format(this.signatureConfig.getExecutionTime());
        LOG.log(1, new Object[]{"now: " + string});
        SignatureTimeDocument signatureTimeDocument = SignatureTimeDocument.Factory.newInstance();
        CTSignatureTime cTSignatureTime = signatureTimeDocument.addNewSignatureTime();
        cTSignatureTime.setFormat("YYYY-MM-DDThh:mm:ssTZD");
        cTSignatureTime.setValue(string);
        Element element = (Element)document.importNode(cTSignatureTime.getDomNode(), true);
        ArrayList<DOMStructure> arrayList = new ArrayList<DOMStructure>();
        arrayList.add(new DOMStructure(element));
        SignatureProperty signatureProperty = this.getSignatureFactory().newSignatureProperty(arrayList, "#" + this.signatureConfig.getPackageSignatureId(), "idSignatureTime");
        ArrayList<SignatureProperty> arrayList2 = new ArrayList<SignatureProperty>();
        arrayList2.add(signatureProperty);
        SignatureProperties signatureProperties = this.getSignatureFactory().newSignatureProperties(arrayList2, "id-signature-time-" + this.signatureConfig.getExecutionTime());
        list.add(signatureProperties);
    }

    protected void addSignatureInfo(Document document, List<Reference> list, List<XMLObject> list2) throws XMLSignatureException {
        ArrayList<SignatureProperties> arrayList = new ArrayList<SignatureProperties>();
        SignatureInfoV1Document signatureInfoV1Document = SignatureInfoV1Document.Factory.newInstance();
        CTSignatureInfoV1 cTSignatureInfoV1 = signatureInfoV1Document.addNewSignatureInfoV1();
        cTSignatureInfoV1.setManifestHashAlgorithm(this.signatureConfig.getDigestMethodUri());
        Element element = (Element)document.importNode(cTSignatureInfoV1.getDomNode(), true);
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://schemas.microsoft.com/office/2006/digsig");
        ArrayList<DOMStructure> arrayList2 = new ArrayList<DOMStructure>();
        arrayList2.add(new DOMStructure(element));
        SignatureProperty signatureProperty = this.getSignatureFactory().newSignatureProperty(arrayList2, "#" + this.signatureConfig.getPackageSignatureId(), "idOfficeV1Details");
        ArrayList<SignatureProperty> arrayList3 = new ArrayList<SignatureProperty>();
        arrayList3.add(signatureProperty);
        SignatureProperties signatureProperties = this.getSignatureFactory().newSignatureProperties(arrayList3, null);
        arrayList.add(signatureProperties);
        String string = "idOfficeObject";
        list2.add(this.getSignatureFactory().newXMLObject(arrayList, string, null, null));
        Reference reference = this.newReference("#" + string, null, "http://www.w3.org/2000/09/xmldsig#Object", null, null);
        list.add(reference);
    }

    protected static String getRelationshipReferenceURI(String string) {
        return "/" + string + "?ContentType=application/vnd.openxmlformats-package.relationships+xml";
    }

    protected static String getResourceReferenceURI(String string, String string2) {
        return "/" + string + "?ContentType=" + string2;
    }

    protected static boolean isSignedRelationship(String string) {
        LOG.log(1, new Object[]{"relationship type: " + string});
        for (String string2 : signed) {
            if (!string.endsWith(string2)) continue;
            return true;
        }
        if (string.endsWith("customXml")) {
            LOG.log(1, new Object[]{"customXml relationship type"});
            return true;
        }
        return false;
    }
}

