/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.crypt.dsig.facets;

import ai2.org.apache.poi.poifs.crypt.dsig.facets.SignatureFacet;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.security.Key;
import java.security.KeyException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import org.apache.jcp.xml.dsig.internal.dom.DOMKeyInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KeyInfoSignatureFacet
extends SignatureFacet {
    private static final POILogger LOG = POILogFactory.getLogger(KeyInfoSignatureFacet.class);

    public void postSign(Document document) throws MarshalException {
        XMLStructure xMLStructure;
        LOG.log(1, new Object[]{"postSign"});
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Object");
        Node node = nodeList.getLength() == 0 ? null : nodeList.item(0);
        KeyInfoFactory keyInfoFactory = this.signatureConfig.getKeyInfoFactory();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        X509Certificate x509Certificate = this.signatureConfig.getSigningCertificateChain().get(0);
        ArrayList<KeyValue> arrayList2 = new ArrayList<KeyValue>();
        if (this.signatureConfig.isIncludeKeyValue()) {
            try {
                xMLStructure = keyInfoFactory.newKeyValue(x509Certificate.getPublicKey());
            }
            catch (KeyException keyException) {
                throw new RuntimeException("key exception: " + keyException.getMessage(), keyException);
            }
            arrayList2.add((KeyValue)xMLStructure);
        }
        if (this.signatureConfig.isIncludeIssuerSerial()) {
            arrayList.add(keyInfoFactory.newX509IssuerSerial(x509Certificate.getIssuerX500Principal().toString(), x509Certificate.getSerialNumber()));
        }
        if (this.signatureConfig.isIncludeEntireCertificateChain()) {
            arrayList.addAll(this.signatureConfig.getSigningCertificateChain());
        } else {
            arrayList.add(x509Certificate);
        }
        if (!arrayList.isEmpty()) {
            xMLStructure = keyInfoFactory.newX509Data(arrayList);
            arrayList2.add((KeyValue)xMLStructure);
        }
        xMLStructure = keyInfoFactory.newKeyInfo(arrayList2);
        DOMKeyInfo dOMKeyInfo = (DOMKeyInfo)xMLStructure;
        Key key = new Key(){
            private static final long serialVersionUID = 1L;

            public String getAlgorithm() {
                return null;
            }

            public byte[] getEncoded() {
                return null;
            }

            public String getFormat() {
                return null;
            }
        };
        Element element = document.getDocumentElement();
        DOMSignContext dOMSignContext = new DOMSignContext(key, (Node)element, node);
        for (Map.Entry<String, String> object : this.signatureConfig.getNamespacePrefixes().entrySet()) {
            dOMSignContext.putNamespacePrefix(object.getKey(), object.getValue());
        }
        DOMStructure dOMStructure = new DOMStructure(element);
        dOMKeyInfo.marshal((XMLStructure)dOMStructure, (XMLCryptoContext)dOMSignContext);
        if (node != null) {
            NodeList nodeList2 = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
            if (nodeList2.getLength() != 1) {
                throw new RuntimeException("KeyInfo wasn't set");
            }
            node.getParentNode().insertBefore(nodeList2.item(0), node);
        }
    }
}

