/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.crypt.dsig;

import ai2.org.apache.poi.EncryptedDocumentException;
import ai2.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import ai2.org.apache.poi.openxml4j.opc.OPCPackage;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackagePartName;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import ai2.org.apache.poi.openxml4j.opc.PackagingURIHelper;
import ai2.org.apache.poi.openxml4j.opc.TargetMode;
import ai2.org.apache.poi.poifs.crypt.ChainingMode;
import ai2.org.apache.poi.poifs.crypt.CipherAlgorithm;
import ai2.org.apache.poi.poifs.crypt.CryptoFunctions;
import ai2.org.apache.poi.poifs.crypt.dsig.DigestInfo;
import ai2.org.apache.poi.poifs.crypt.dsig.KeyInfoKeySelector;
import ai2.org.apache.poi.poifs.crypt.dsig.SignatureConfig;
import ai2.org.apache.poi.poifs.crypt.dsig.SignatureMarshalListener;
import ai2.org.apache.poi.poifs.crypt.dsig.facets.SignatureFacet;
import ai2.org.apache.poi.poifs.crypt.dsig.services.RelationshipTransformService;
import ai2.org.apache.poi.util.DocumentHelper;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.crypto.Cipher;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.Manifest;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignContext;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.jcp.xml.dsig.internal.dom.DOMReference;
import org.apache.jcp.xml.dsig.internal.dom.DOMSignedInfo;
import org.apache.xml.security.Init;
import org.apache.xml.security.utils.Base64;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.w3.x2000.x09.xmldsig.SignatureDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureInfo
implements SignatureConfig.SignatureConfigurable {
    private static final POILogger LOG = POILogFactory.getLogger(SignatureInfo.class);
    private static boolean isInitialized = false;
    private SignatureConfig signatureConfig;

    public SignatureInfo() {
        SignatureInfo.initXmlProvider();
    }

    public SignatureConfig getSignatureConfig() {
        return this.signatureConfig;
    }

    @Override
    public void setSignatureConfig(SignatureConfig signatureConfig) {
        this.signatureConfig = signatureConfig;
    }

    public boolean verifySignature() {
        Iterator<SignaturePart> iterator = this.getSignatureParts().iterator();
        if (iterator.hasNext()) {
            SignaturePart signaturePart = iterator.next();
            return signaturePart.validate();
        }
        return false;
    }

    public void confirmSignature() throws XMLSignatureException, MarshalException {
        Document document = DocumentHelper.createDocument();
        DigestInfo digestInfo = this.preSign(document, null);
        byte[] byArray = this.signDigest(digestInfo.digestValue);
        this.postSign(document, byArray);
    }

    public byte[] signDigest(byte[] byArray) {
        Cipher cipher = CryptoFunctions.getCipher(this.signatureConfig.getKey(), CipherAlgorithm.rsa, ChainingMode.ecb, null, 1, "PKCS1Padding");
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(this.signatureConfig.getHashMagic());
            byteArrayOutputStream.write(byArray);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            byte[] byArray3 = cipher.doFinal(byArray2);
            return byArray3;
        }
        catch (Exception exception) {
            throw new EncryptedDocumentException(exception);
        }
    }

    public Iterable<SignaturePart> getSignatureParts() {
        this.signatureConfig.init(true);
        return new Iterable<SignaturePart>(){

            @Override
            public Iterator<SignaturePart> iterator() {
                return new Iterator<SignaturePart>(){
                    OPCPackage pkg;
                    Iterator<PackageRelationship> sigOrigRels;
                    Iterator<PackageRelationship> sigRels;
                    PackagePart sigPart;
                    {
                        this.pkg = SignatureInfo.this.signatureConfig.getOpcPackage();
                        this.sigOrigRels = this.pkg.getRelationshipsByType("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin").iterator();
                        this.sigRels = null;
                        this.sigPart = null;
                    }

                    @Override
                    public boolean hasNext() {
                        while (this.sigRels == null || !this.sigRels.hasNext()) {
                            if (!this.sigOrigRels.hasNext()) {
                                return false;
                            }
                            this.sigPart = this.pkg.getPart(this.sigOrigRels.next());
                            LOG.log(1, "Digital Signature Origin part", this.sigPart);
                            try {
                                this.sigRels = this.sigPart.getRelationshipsByType("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/signature").iterator();
                            }
                            catch (InvalidFormatException invalidFormatException) {
                                LOG.log(5, new Object[]{"Reference to signature is invalid.", invalidFormatException});
                            }
                        }
                        return true;
                    }

                    @Override
                    public SignaturePart next() {
                        PackagePart packagePart = null;
                        do {
                            try {
                                if (!this.hasNext()) {
                                    throw new NoSuchElementException();
                                }
                                packagePart = this.sigPart.getRelatedPart(this.sigRels.next());
                                LOG.log(1, "XML Signature part", packagePart);
                            }
                            catch (InvalidFormatException invalidFormatException) {
                                LOG.log(5, new Object[]{"Reference to signature is invalid.", invalidFormatException});
                            }
                        } while (this.sigPart == null);
                        return new SignaturePart(packagePart);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    protected static synchronized void initXmlProvider() {
        if (isInitialized) {
            return;
        }
        isInitialized = true;
        try {
            Init.init();
            RelationshipTransformService.registerDsigProvider();
            CryptoFunctions.registerBouncyCastle();
        }
        catch (Exception exception) {
            throw new RuntimeException("Xml & BouncyCastle-Provider initialization failed", exception);
        }
    }

    public DigestInfo preSign(Document document, List<DigestInfo> list) throws XMLSignatureException, MarshalException {
        Object object;
        Object object2;
        Object object3;
        Object object42;
        Object object5;
        SignedInfo signedInfo;
        List<Reference> list2;
        Object object6;
        Object object72;
        this.signatureConfig.init(false);
        EventTarget eventTarget = (EventTarget)((Object)document);
        EventListener eventListener = this.signatureConfig.getSignatureMarshalListener();
        if (eventListener != null) {
            if (eventListener instanceof SignatureMarshalListener) {
                ((SignatureMarshalListener)eventListener).setEventTarget(eventTarget);
            }
            SignatureMarshalListener.setListener(eventTarget, eventListener, true);
        }
        DOMSignContext dOMSignContext = new DOMSignContext(this.signatureConfig.getKey(), (Node)document);
        URIDereferencer uRIDereferencer = this.signatureConfig.getUriDereferencer();
        if (null != uRIDereferencer) {
            dOMSignContext.setURIDereferencer(uRIDereferencer);
        }
        for (Map.Entry<String, String> object102 : this.signatureConfig.getNamespacePrefixes().entrySet()) {
            dOMSignContext.putNamespacePrefix(object102.getKey(), object102.getValue());
        }
        dOMSignContext.setDefaultNamespacePrefix("");
        this.brokenJvmWorkaround(dOMSignContext);
        XMLSignatureFactory xMLSignatureFactory = this.signatureConfig.getSignatureFactory();
        ArrayList<Reference> arrayList = new ArrayList<Reference>();
        for (DigestInfo digestInfo : SignatureInfo.safe(list)) {
            object72 = digestInfo.digestValue;
            object6 = new File(digestInfo.description).getName();
            list2 = SignatureFacet.newReference((String)object6, null, null, null, (byte[])object72, this.signatureConfig);
            arrayList.add((Reference)((Object)list2));
        }
        ArrayList arrayList2 = new ArrayList();
        for (Object object72 : this.signatureConfig.getSignatureFacets()) {
            LOG.log(1, new Object[]{"invoking signature facet: " + object72.getClass().getSimpleName()});
            ((SignatureFacet)object72).preSign(document, arrayList, arrayList2);
        }
        try {
            object72 = xMLSignatureFactory.newSignatureMethod(this.signatureConfig.getSignatureMethodUri(), null);
            object6 = xMLSignatureFactory.newCanonicalizationMethod(this.signatureConfig.getCanonicalizationMethod(), (C14NMethodParameterSpec)null);
            signedInfo = xMLSignatureFactory.newSignedInfo((CanonicalizationMethod)object6, (SignatureMethod)object72, arrayList);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new XMLSignatureException(generalSecurityException);
        }
        object72 = this.signatureConfig.getPackageSignatureId() + "-signature-value";
        object6 = xMLSignatureFactory.newXMLSignature(signedInfo, null, arrayList2, this.signatureConfig.getPackageSignatureId(), (String)object72);
        object6.sign(dOMSignContext);
        list2 = arrayList2.iterator();
        while (list2.hasNext()) {
            object5 = (XMLObject)list2.next();
            LOG.log(1, new Object[]{"object java type: " + object5.getClass().getName()});
            List<XMLStructure> list3 = object5.getContent();
            for (Object object42 : list3) {
                LOG.log(1, new Object[]{"object content java type: " + object42.getClass().getName()});
                if (!(object42 instanceof Manifest)) continue;
                object3 = (Manifest)object42;
                object2 = object3.getReferences();
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    Reference reference = (Reference)iterator.next();
                    if (reference.getDigestValue() != null) continue;
                    DOMReference dOMReference = (DOMReference)reference;
                    dOMReference.digest((XMLSignContext)dOMSignContext);
                }
            }
        }
        list2 = signedInfo.getReferences();
        for (Reference reference : list2) {
            object = (DOMReference)reference;
            if (object.getDigestValue() != null) continue;
            object.digest((XMLSignContext)dOMSignContext);
        }
        object5 = (DOMSignedInfo)signedInfo;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        object5.canonicalize((XMLCryptoContext)dOMSignContext, byteArrayOutputStream);
        object = byteArrayOutputStream.toByteArray();
        object42 = CryptoFunctions.getMessageDigest(this.signatureConfig.getDigestAlgo());
        object3 = ((MessageDigest)object42).digest((byte[])object);
        object2 = this.signatureConfig.getSignatureDescription();
        return new DigestInfo((byte[])object3, this.signatureConfig.getDigestAlgo(), (String)object2);
    }

    public void postSign(Document document, byte[] byArray) throws MarshalException {
        LOG.log(1, new Object[]{"postSign"});
        String string = this.signatureConfig.getPackageSignatureId();
        if (!string.equals(document.getDocumentElement().getAttribute("Id"))) {
            throw new RuntimeException("ds:Signature not found for @Id: " + string);
        }
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignatureValue");
        if (nodeList.getLength() != 1) {
            throw new RuntimeException("preSign has to be called before postSign");
        }
        nodeList.item(0).setTextContent(Base64.encode((byte[])byArray));
        for (SignatureFacet signatureFacet : this.signatureConfig.getSignatureFacets()) {
            signatureFacet.postSign(document);
        }
        this.writeDocument(document);
    }

    protected void writeDocument(Document document) throws MarshalException {
        Object object;
        Object exception;
        PackagePartName packagePartName;
        PackagePartName packagePartName2;
        XmlOptions xmlOptions = new XmlOptions();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, String> object32 : this.signatureConfig.getNamespacePrefixes().entrySet()) {
            hashMap.put(object32.getValue(), object32.getKey());
        }
        xmlOptions.setSaveSuggestedPrefixes(hashMap);
        xmlOptions.setUseDefaultNamespace();
        LOG.log(1, new Object[]{"output signed Office OpenXML document"});
        OPCPackage oPCPackage = this.signatureConfig.getOpcPackage();
        try {
            packagePartName2 = PackagingURIHelper.createPartName("/_xmlsignatures/sig1.xml");
            packagePartName = PackagingURIHelper.createPartName("/_xmlsignatures/origin.sigs");
        }
        catch (InvalidFormatException packagePart) {
            throw new MarshalException(packagePart);
        }
        PackagePart packagePart = oPCPackage.getPart(packagePartName2);
        if (packagePart == null) {
            packagePart = oPCPackage.createPart(packagePartName2, "application/vnd.openxmlformats-package.digital-signature-xmlsignature+xml");
        }
        try {
            exception = packagePart.getOutputStream();
            object = SignatureDocument.Factory.parse((Node)document);
            object.save((OutputStream)exception, xmlOptions);
            ((OutputStream)exception).close();
        }
        catch (Exception exception2) {
            throw new MarshalException("Unable to write signature document", exception2);
        }
        exception = oPCPackage.getPart(packagePartName);
        if (exception == null) {
            exception = oPCPackage.createPart(packagePartName, "application/vnd.openxmlformats-package.digital-signature-origin");
        }
        object = oPCPackage.getRelationshipsByType("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        Iterator<PackageRelationship> iterator = ((PackageRelationshipCollection)object).iterator();
        while (iterator.hasNext()) {
            PackageRelationship packageRelationship = iterator.next();
            oPCPackage.removeRelationship(packageRelationship.getId());
        }
        oPCPackage.addRelationship(packagePartName, TargetMode.INTERNAL, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        ((PackagePart)exception).addRelationship(packagePartName2, TargetMode.INTERNAL, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/signature");
    }

    private static <T> List<T> safe(List<T> list) {
        return list == null ? Collections.EMPTY_LIST : list;
    }

    private void brokenJvmWorkaround(XMLSignContext xMLSignContext) {
        Provider provider = Security.getProvider("BC");
        if (provider != null) {
            xMLSignContext.setProperty("org.jcp.xml.dsig.internal.dom.SignatureProvider", provider);
        }
    }

    private void brokenJvmWorkaround(XMLValidateContext xMLValidateContext) {
        Provider provider = Security.getProvider("BC");
        if (provider != null) {
            xMLValidateContext.setProperty("org.jcp.xml.dsig.internal.dom.SignatureProvider", provider);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SignaturePart {
        private final PackagePart signaturePart;
        private X509Certificate signer;
        private List<X509Certificate> certChain;

        private SignaturePart(PackagePart packagePart) {
            this.signaturePart = packagePart;
        }

        public PackagePart getPackagePart() {
            return this.signaturePart;
        }

        public X509Certificate getSigner() {
            return this.signer;
        }

        public List<X509Certificate> getCertChain() {
            return this.certChain;
        }

        public SignatureDocument getSignatureDocument() throws IOException, XmlException {
            return SignatureDocument.Factory.parse((InputStream)this.signaturePart.getInputStream());
        }

        public boolean validate() {
            KeyInfoKeySelector keyInfoKeySelector = new KeyInfoKeySelector();
            try {
                Document document = DocumentHelper.readDocument(this.signaturePart.getInputStream());
                XPath xPath = XPathFactory.newInstance().newXPath();
                NodeList nodeList = (NodeList)xPath.compile("//*[@Id]").evaluate(document, XPathConstants.NODESET);
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    ((Element)nodeList.item(i)).setIdAttribute("Id", true);
                }
                DOMValidateContext dOMValidateContext = new DOMValidateContext(keyInfoKeySelector, (Node)document);
                dOMValidateContext.setProperty("org.jcp.xml.dsig.validateManifests", Boolean.TRUE);
                dOMValidateContext.setURIDereferencer(SignatureInfo.this.signatureConfig.getUriDereferencer());
                SignatureInfo.this.brokenJvmWorkaround(dOMValidateContext);
                XMLSignatureFactory xMLSignatureFactory = SignatureInfo.this.signatureConfig.getSignatureFactory();
                XMLSignature xMLSignature = xMLSignatureFactory.unmarshalXMLSignature(dOMValidateContext);
                for (Reference xMLStructure : xMLSignature.getSignedInfo().getReferences()) {
                    SignatureFacet.brokenJvmWorkaround(xMLStructure);
                }
                for (XMLObject xMLObject : xMLSignature.getObjects()) {
                    for (XMLStructure xMLStructure : xMLObject.getContent()) {
                        if (!(xMLStructure instanceof Manifest)) continue;
                        for (Reference reference : ((Manifest)xMLStructure).getReferences()) {
                            SignatureFacet.brokenJvmWorkaround(reference);
                        }
                    }
                }
                boolean bl = xMLSignature.validate(dOMValidateContext);
                if (bl) {
                    this.signer = keyInfoKeySelector.getSigner();
                    this.certChain = keyInfoKeySelector.getCertChain();
                }
                return bl;
            }
            catch (Exception exception) {
                String string = "error in marshalling and validating the signature";
                LOG.log(7, new Object[]{string, exception});
                throw new EncryptedDocumentException(string, exception);
            }
        }
    }
}

