/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.crypt.cryptoapi;

import ai2.org.apache.poi.EncryptedDocumentException;
import ai2.org.apache.poi.hpsf.DocumentSummaryInformation;
import ai2.org.apache.poi.hpsf.PropertySetFactory;
import ai2.org.apache.poi.hpsf.WritingNotSupportedException;
import ai2.org.apache.poi.poifs.crypt.CryptoFunctions;
import ai2.org.apache.poi.poifs.crypt.DataSpaceMapUtils;
import ai2.org.apache.poi.poifs.crypt.EncryptionInfo;
import ai2.org.apache.poi.poifs.crypt.Encryptor;
import ai2.org.apache.poi.poifs.crypt.HashAlgorithm;
import ai2.org.apache.poi.poifs.crypt.cryptoapi.CryptoAPIDecryptor;
import ai2.org.apache.poi.poifs.crypt.cryptoapi.CryptoAPIEncryptionHeader;
import ai2.org.apache.poi.poifs.crypt.cryptoapi.CryptoAPIEncryptionInfoBuilder;
import ai2.org.apache.poi.poifs.crypt.cryptoapi.CryptoAPIEncryptionVerifier;
import ai2.org.apache.poi.poifs.crypt.standard.EncryptionRecord;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.DocumentInputStream;
import ai2.org.apache.poi.util.IOUtils;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.LittleEndianByteArrayOutputStream;
import ai2.org.apache.poi.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public class CryptoAPIEncryptor
extends Encryptor {
    private final CryptoAPIEncryptionInfoBuilder builder;

    protected CryptoAPIEncryptor(CryptoAPIEncryptionInfoBuilder cryptoAPIEncryptionInfoBuilder) {
        this.builder = cryptoAPIEncryptionInfoBuilder;
    }

    public void confirmPassword(String string) {
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[16];
        byte[] byArray2 = new byte[16];
        ((Random)secureRandom).nextBytes(byArray);
        ((Random)secureRandom).nextBytes(byArray2);
        this.confirmPassword(string, null, null, byArray2, byArray, null);
    }

    public void confirmPassword(String string, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5) {
        assert (byArray3 != null && byArray4 != null);
        CryptoAPIEncryptionVerifier cryptoAPIEncryptionVerifier = this.builder.getVerifier();
        cryptoAPIEncryptionVerifier.setSalt(byArray4);
        SecretKey secretKey = CryptoAPIDecryptor.generateSecretKey(string, cryptoAPIEncryptionVerifier);
        this.setSecretKey(secretKey);
        try {
            Cipher cipher = this.initCipherForBlock(null, 0);
            byte[] byArray6 = new byte[byArray3.length];
            cipher.update(byArray3, 0, byArray3.length, byArray6);
            cryptoAPIEncryptionVerifier.setEncryptedVerifier(byArray6);
            HashAlgorithm hashAlgorithm = cryptoAPIEncryptionVerifier.getHashAlgorithm();
            MessageDigest messageDigest = CryptoFunctions.getMessageDigest(hashAlgorithm);
            byte[] byArray7 = messageDigest.digest(byArray3);
            byte[] byArray8 = cipher.doFinal(byArray7);
            cryptoAPIEncryptionVerifier.setEncryptedVerifierHash(byArray8);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new EncryptedDocumentException("Password confirmation failed", generalSecurityException);
        }
    }

    public Cipher initCipherForBlock(Cipher cipher, int n) throws GeneralSecurityException {
        return CryptoAPIDecryptor.initCipherForBlock(cipher, n, this.builder, this.getSecretKey(), 1);
    }

    public OutputStream getDataStream(DirectoryNode directoryNode) throws IOException, GeneralSecurityException {
        CipherByteArrayOutputStream cipherByteArrayOutputStream = new CipherByteArrayOutputStream();
        byte[] byArray = new byte[8];
        cipherByteArrayOutputStream.write(byArray, 0, 8);
        String[] stringArray = new String[]{"\u0005SummaryInformation", "\u0005DocumentSummaryInformation"};
        ArrayList<CryptoAPIDecryptor.StreamDescriptorEntry> arrayList = new ArrayList<CryptoAPIDecryptor.StreamDescriptorEntry>();
        int n = 0;
        for (String object2 : stringArray) {
            if (!directoryNode.hasEntry(object2)) continue;
            CryptoAPIDecryptor.StreamDescriptorEntry streamDescriptorEntry = new CryptoAPIDecryptor.StreamDescriptorEntry();
            streamDescriptorEntry.block = n;
            streamDescriptorEntry.streamOffset = cipherByteArrayOutputStream.size();
            streamDescriptorEntry.streamName = object2;
            streamDescriptorEntry.flags = CryptoAPIDecryptor.StreamDescriptorEntry.flagStream.setValue(0, 1);
            streamDescriptorEntry.reserved2 = 0;
            cipherByteArrayOutputStream.setBlock(n);
            DocumentInputStream documentInputStream = directoryNode.createDocumentInputStream(object2);
            IOUtils.copy(documentInputStream, cipherByteArrayOutputStream);
            documentInputStream.close();
            streamDescriptorEntry.streamSize = cipherByteArrayOutputStream.size() - streamDescriptorEntry.streamOffset;
            arrayList.add(streamDescriptorEntry);
            directoryNode.getEntry(object2).delete();
            ++n;
        }
        int n2 = cipherByteArrayOutputStream.size();
        cipherByteArrayOutputStream.setBlock(0);
        LittleEndian.putUInt(byArray, 0, arrayList.size());
        cipherByteArrayOutputStream.write(byArray, 0, 4);
        for (CryptoAPIDecryptor.StreamDescriptorEntry streamDescriptorEntry : arrayList) {
            LittleEndian.putUInt(byArray, 0, streamDescriptorEntry.streamOffset);
            cipherByteArrayOutputStream.write(byArray, 0, 4);
            LittleEndian.putUInt(byArray, 0, streamDescriptorEntry.streamSize);
            cipherByteArrayOutputStream.write(byArray, 0, 4);
            LittleEndian.putUShort(byArray, 0, streamDescriptorEntry.block);
            cipherByteArrayOutputStream.write(byArray, 0, 2);
            LittleEndian.putUByte(byArray, 0, (short)streamDescriptorEntry.streamName.length());
            cipherByteArrayOutputStream.write(byArray, 0, 1);
            LittleEndian.putUByte(byArray, 0, (short)streamDescriptorEntry.flags);
            cipherByteArrayOutputStream.write(byArray, 0, 1);
            LittleEndian.putUInt(byArray, 0, streamDescriptorEntry.reserved2);
            cipherByteArrayOutputStream.write(byArray, 0, 4);
            byte[] byArray2 = StringUtil.getToUnicodeLE(streamDescriptorEntry.streamName);
            cipherByteArrayOutputStream.write(byArray2, 0, byArray2.length);
            LittleEndian.putShort(byArray, 0, (short)0);
            cipherByteArrayOutputStream.write(byArray, 0, 2);
        }
        int n3 = cipherByteArrayOutputStream.size();
        int n4 = n3 - n2;
        LittleEndian.putUInt(byArray, 0, n2);
        LittleEndian.putUInt(byArray, 4, n4);
        cipherByteArrayOutputStream.reset();
        cipherByteArrayOutputStream.setBlock(0);
        cipherByteArrayOutputStream.write(byArray, 0, 8);
        cipherByteArrayOutputStream.setSize(n3);
        directoryNode.createDocument("EncryptedSummary", new ByteArrayInputStream(cipherByteArrayOutputStream.getBuf(), 0, n3));
        DocumentSummaryInformation documentSummaryInformation = PropertySetFactory.newDocumentSummaryInformation();
        try {
            documentSummaryInformation.write(directoryNode, "\u0005DocumentSummaryInformation");
        }
        catch (WritingNotSupportedException writingNotSupportedException) {
            throw new IOException(writingNotSupportedException);
        }
        return cipherByteArrayOutputStream;
    }

    protected int getKeySizeInBytes() {
        return this.builder.getHeader().getKeySize() / 8;
    }

    protected void createEncryptionInfoEntry(DirectoryNode directoryNode) throws IOException {
        DataSpaceMapUtils.addDefaultDataSpace(directoryNode);
        final EncryptionInfo encryptionInfo = this.builder.getEncryptionInfo();
        final CryptoAPIEncryptionHeader cryptoAPIEncryptionHeader = this.builder.getHeader();
        final CryptoAPIEncryptionVerifier cryptoAPIEncryptionVerifier = this.builder.getVerifier();
        EncryptionRecord encryptionRecord = new EncryptionRecord(){

            public void write(LittleEndianByteArrayOutputStream littleEndianByteArrayOutputStream) {
                littleEndianByteArrayOutputStream.writeShort(encryptionInfo.getVersionMajor());
                littleEndianByteArrayOutputStream.writeShort(encryptionInfo.getVersionMinor());
                cryptoAPIEncryptionHeader.write(littleEndianByteArrayOutputStream);
                cryptoAPIEncryptionVerifier.write(littleEndianByteArrayOutputStream);
            }
        };
        DataSpaceMapUtils.createEncryptionEntry(directoryNode, "EncryptionInfo", encryptionRecord);
    }

    private class CipherByteArrayOutputStream
    extends ByteArrayOutputStream {
        Cipher cipher;
        byte[] oneByte = new byte[]{0};

        public CipherByteArrayOutputStream() throws GeneralSecurityException {
            this.setBlock(0);
        }

        public byte[] getBuf() {
            return this.buf;
        }

        public void setSize(int n) {
            this.count = n;
        }

        public void setBlock(int n) throws GeneralSecurityException {
            this.cipher = CryptoAPIEncryptor.this.initCipherForBlock(this.cipher, n);
        }

        public void write(int n) {
            try {
                this.oneByte[0] = (byte)n;
                this.cipher.update(this.oneByte, 0, 1, this.oneByte, 0);
                super.write(this.oneByte);
            }
            catch (Exception exception) {
                throw new EncryptedDocumentException(exception);
            }
        }

        public void write(byte[] byArray, int n, int n2) {
            try {
                this.cipher.update(byArray, n, n2, byArray, n);
                super.write(byArray, n, n2);
            }
            catch (Exception exception) {
                throw new EncryptedDocumentException(exception);
            }
        }
    }
}

