/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.crypt.cryptoapi;

import ai2.org.apache.poi.poifs.crypt.ChainingMode;
import ai2.org.apache.poi.poifs.crypt.CipherAlgorithm;
import ai2.org.apache.poi.poifs.crypt.EncryptionInfo;
import ai2.org.apache.poi.poifs.crypt.EncryptionInfoBuilder;
import ai2.org.apache.poi.poifs.crypt.HashAlgorithm;
import ai2.org.apache.poi.poifs.crypt.cryptoapi.CryptoAPIDecryptor;
import ai2.org.apache.poi.poifs.crypt.cryptoapi.CryptoAPIEncryptionHeader;
import ai2.org.apache.poi.poifs.crypt.cryptoapi.CryptoAPIEncryptionVerifier;
import ai2.org.apache.poi.poifs.crypt.cryptoapi.CryptoAPIEncryptor;
import ai2.org.apache.poi.util.LittleEndianInput;
import java.io.IOException;

public class CryptoAPIEncryptionInfoBuilder
implements EncryptionInfoBuilder {
    EncryptionInfo info;
    CryptoAPIEncryptionHeader header;
    CryptoAPIEncryptionVerifier verifier;
    CryptoAPIDecryptor decryptor;
    CryptoAPIEncryptor encryptor;

    public void initialize(EncryptionInfo encryptionInfo, LittleEndianInput littleEndianInput) throws IOException {
        this.info = encryptionInfo;
        littleEndianInput.readInt();
        this.header = new CryptoAPIEncryptionHeader(littleEndianInput);
        this.verifier = new CryptoAPIEncryptionVerifier(littleEndianInput, this.header);
        this.decryptor = new CryptoAPIDecryptor(this);
        this.encryptor = new CryptoAPIEncryptor(this);
    }

    public void initialize(EncryptionInfo encryptionInfo, CipherAlgorithm cipherAlgorithm, HashAlgorithm hashAlgorithm, int n, int n2, ChainingMode chainingMode) {
        this.info = encryptionInfo;
        if (cipherAlgorithm == null) {
            cipherAlgorithm = CipherAlgorithm.rc4;
        }
        if (hashAlgorithm == null) {
            hashAlgorithm = HashAlgorithm.sha1;
        }
        if (n == -1) {
            n = 40;
        }
        assert (cipherAlgorithm == CipherAlgorithm.rc4 && hashAlgorithm == HashAlgorithm.sha1);
        this.header = new CryptoAPIEncryptionHeader(cipherAlgorithm, hashAlgorithm, n, n2, chainingMode);
        this.verifier = new CryptoAPIEncryptionVerifier(cipherAlgorithm, hashAlgorithm, n, n2, chainingMode);
        this.decryptor = new CryptoAPIDecryptor(this);
        this.encryptor = new CryptoAPIEncryptor(this);
    }

    public CryptoAPIEncryptionHeader getHeader() {
        return this.header;
    }

    public CryptoAPIEncryptionVerifier getVerifier() {
        return this.verifier;
    }

    public CryptoAPIDecryptor getDecryptor() {
        return this.decryptor;
    }

    public CryptoAPIEncryptor getEncryptor() {
        return this.encryptor;
    }

    public EncryptionInfo getEncryptionInfo() {
        return this.info;
    }
}

