/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.crypt.cryptoapi;

import ai2.org.apache.poi.EncryptedDocumentException;
import ai2.org.apache.poi.poifs.crypt.ChainingMode;
import ai2.org.apache.poi.poifs.crypt.CipherAlgorithm;
import ai2.org.apache.poi.poifs.crypt.CipherProvider;
import ai2.org.apache.poi.poifs.crypt.HashAlgorithm;
import ai2.org.apache.poi.poifs.crypt.standard.StandardEncryptionHeader;
import ai2.org.apache.poi.util.LittleEndianInput;
import java.io.IOException;

public class CryptoAPIEncryptionHeader
extends StandardEncryptionHeader {
    public CryptoAPIEncryptionHeader(LittleEndianInput littleEndianInput) throws IOException {
        super(littleEndianInput);
    }

    protected CryptoAPIEncryptionHeader(CipherAlgorithm cipherAlgorithm, HashAlgorithm hashAlgorithm, int n, int n2, ChainingMode chainingMode) {
        super(cipherAlgorithm, hashAlgorithm, n, n2, chainingMode);
    }

    public void setKeySize(int n) {
        boolean bl = false;
        for (int n2 : this.getCipherAlgorithm().allowedKeySize) {
            if (n2 != n) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new EncryptedDocumentException("invalid keysize " + n + " for cipher algorithm " + (Object)((Object)this.getCipherAlgorithm()));
        }
        super.setKeySize(n);
        if (n > 40) {
            this.setCspName("Microsoft Enhanced Cryptographic Provider v1.0");
        } else {
            this.setCspName(CipherProvider.rc4.cipherProviderName);
        }
    }
}

