/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.crypt.cryptoapi;

import ai2.org.apache.poi.EncryptedDocumentException;
import ai2.org.apache.poi.poifs.crypt.CryptoFunctions;
import ai2.org.apache.poi.poifs.crypt.Decryptor;
import ai2.org.apache.poi.poifs.crypt.EncryptionHeader;
import ai2.org.apache.poi.poifs.crypt.EncryptionInfoBuilder;
import ai2.org.apache.poi.poifs.crypt.EncryptionVerifier;
import ai2.org.apache.poi.poifs.crypt.HashAlgorithm;
import ai2.org.apache.poi.poifs.crypt.cryptoapi.CryptoAPIEncryptionInfoBuilder;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.DocumentInputStream;
import ai2.org.apache.poi.poifs.filesystem.DocumentNode;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.BitFieldFactory;
import ai2.org.apache.poi.util.BoundedInputStream;
import ai2.org.apache.poi.util.IOUtils;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.LittleEndianInputStream;
import ai2.org.apache.poi.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public class CryptoAPIDecryptor
extends Decryptor {
    private long _length = -1L;

    protected CryptoAPIDecryptor(CryptoAPIEncryptionInfoBuilder cryptoAPIEncryptionInfoBuilder) {
        super(cryptoAPIEncryptionInfoBuilder);
    }

    public boolean verifyPassword(String string) {
        EncryptionVerifier encryptionVerifier = this.builder.getVerifier();
        SecretKey secretKey = CryptoAPIDecryptor.generateSecretKey(string, encryptionVerifier);
        try {
            Cipher cipher = CryptoAPIDecryptor.initCipherForBlock(null, 0, this.builder, secretKey, 2);
            byte[] byArray = encryptionVerifier.getEncryptedVerifier();
            byte[] byArray2 = new byte[byArray.length];
            cipher.update(byArray, 0, byArray.length, byArray2);
            this.setVerifier(byArray2);
            byte[] byArray3 = encryptionVerifier.getEncryptedVerifierHash();
            byte[] byArray4 = cipher.doFinal(byArray3);
            HashAlgorithm hashAlgorithm = encryptionVerifier.getHashAlgorithm();
            MessageDigest messageDigest = CryptoFunctions.getMessageDigest(hashAlgorithm);
            byte[] byArray5 = messageDigest.digest(byArray2);
            if (Arrays.equals(byArray5, byArray4)) {
                this.setSecretKey(secretKey);
                return true;
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new EncryptedDocumentException(generalSecurityException);
        }
        return false;
    }

    public Cipher initCipherForBlock(Cipher cipher, int n) throws GeneralSecurityException {
        return CryptoAPIDecryptor.initCipherForBlock(cipher, n, this.builder, this.getSecretKey(), 2);
    }

    protected static Cipher initCipherForBlock(Cipher cipher, int n, EncryptionInfoBuilder encryptionInfoBuilder, SecretKey secretKey, int n2) throws GeneralSecurityException {
        EncryptionVerifier encryptionVerifier = encryptionInfoBuilder.getVerifier();
        HashAlgorithm hashAlgorithm = encryptionVerifier.getHashAlgorithm();
        byte[] byArray = new byte[4];
        LittleEndian.putUInt(byArray, 0, n);
        MessageDigest messageDigest = CryptoFunctions.getMessageDigest(hashAlgorithm);
        messageDigest.update(secretKey.getEncoded());
        byte[] byArray2 = messageDigest.digest(byArray);
        EncryptionHeader encryptionHeader = encryptionInfoBuilder.getHeader();
        int n3 = encryptionHeader.getKeySize();
        byArray2 = CryptoFunctions.getBlock0(byArray2, n3 / 8);
        if (n3 == 40) {
            byArray2 = CryptoFunctions.getBlock0(byArray2, 16);
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, secretKey.getAlgorithm());
        if (cipher == null) {
            cipher = CryptoFunctions.getCipher(secretKeySpec, encryptionHeader.getCipherAlgorithm(), null, null, n2);
        } else {
            cipher.init(n2, secretKeySpec);
        }
        return cipher;
    }

    protected static SecretKey generateSecretKey(String string, EncryptionVerifier encryptionVerifier) {
        if (string.length() > 255) {
            string = string.substring(0, 255);
        }
        HashAlgorithm hashAlgorithm = encryptionVerifier.getHashAlgorithm();
        MessageDigest messageDigest = CryptoFunctions.getMessageDigest(hashAlgorithm);
        messageDigest.update(encryptionVerifier.getSalt());
        byte[] byArray = messageDigest.digest(StringUtil.getToUnicodeLE(string));
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, encryptionVerifier.getCipherAlgorithm().jceId);
        return secretKeySpec;
    }

    /*
     * WARNING - void declaration
     */
    public InputStream getDataStream(DirectoryNode directoryNode) throws IOException, GeneralSecurityException {
        void object;
        NPOIFSFileSystem nPOIFSFileSystem = new NPOIFSFileSystem();
        DocumentNode documentNode = (DocumentNode)directoryNode.getEntry("EncryptedSummary");
        DocumentInputStream documentInputStream = directoryNode.createDocumentInputStream(documentNode);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy(documentInputStream, byteArrayOutputStream);
        documentInputStream.close();
        SeekableByteArrayInputStream seekableByteArrayInputStream = new SeekableByteArrayInputStream(byteArrayOutputStream.toByteArray());
        LittleEndianInputStream littleEndianInputStream = new LittleEndianInputStream(seekableByteArrayInputStream);
        int n = (int)littleEndianInputStream.readUInt();
        littleEndianInputStream.readUInt();
        seekableByteArrayInputStream.skip(n - 8);
        seekableByteArrayInputStream.setBlock(0);
        int n2 = (int)littleEndianInputStream.readUInt();
        StreamDescriptorEntry[] streamDescriptorEntryArray = new StreamDescriptorEntry[n2];
        boolean i = false;
        while (object < n2) {
            StreamDescriptorEntry streamDescriptorEntry;
            streamDescriptorEntryArray[object] = streamDescriptorEntry = new StreamDescriptorEntry();
            streamDescriptorEntry.streamOffset = (int)littleEndianInputStream.readUInt();
            streamDescriptorEntry.streamSize = (int)littleEndianInputStream.readUInt();
            streamDescriptorEntry.block = littleEndianInputStream.readUShort();
            int n3 = littleEndianInputStream.readUByte();
            streamDescriptorEntry.flags = littleEndianInputStream.readUByte();
            streamDescriptorEntry.reserved2 = littleEndianInputStream.readInt();
            streamDescriptorEntry.streamName = StringUtil.readUnicodeLE(littleEndianInputStream, n3);
            littleEndianInputStream.readShort();
            assert (streamDescriptorEntry.streamName.length() == n3);
            ++object;
        }
        for (StreamDescriptorEntry streamDescriptorEntry : streamDescriptorEntryArray) {
            seekableByteArrayInputStream.seek(streamDescriptorEntry.streamOffset);
            seekableByteArrayInputStream.setBlock(streamDescriptorEntry.block);
            BoundedInputStream boundedInputStream = new BoundedInputStream(seekableByteArrayInputStream, streamDescriptorEntry.streamSize);
            nPOIFSFileSystem.createDocument(boundedInputStream, streamDescriptorEntry.streamName);
        }
        littleEndianInputStream.close();
        seekableByteArrayInputStream = null;
        byteArrayOutputStream.reset();
        nPOIFSFileSystem.writeFilesystem(byteArrayOutputStream);
        nPOIFSFileSystem.close();
        this._length = byteArrayOutputStream.size();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        return byteArrayInputStream;
    }

    public long getLength() {
        if (this._length == -1L) {
            throw new IllegalStateException("Decryptor.getDataStream() was not called");
        }
        return this._length;
    }

    static class StreamDescriptorEntry {
        static BitField flagStream = BitFieldFactory.getInstance(1);
        int streamOffset;
        int streamSize;
        int block;
        int flags;
        int reserved2;
        String streamName;

        StreamDescriptorEntry() {
        }
    }

    private class SeekableByteArrayInputStream
    extends ByteArrayInputStream {
        Cipher cipher;
        byte[] oneByte;

        public void seek(int n) {
            if (n > this.count) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            this.pos = n;
            this.mark = n;
        }

        public void setBlock(int n) throws GeneralSecurityException {
            this.cipher = CryptoAPIDecryptor.this.initCipherForBlock(this.cipher, n);
        }

        public synchronized int read() {
            int n = super.read();
            if (n == -1) {
                return -1;
            }
            this.oneByte[0] = (byte)n;
            try {
                this.cipher.update(this.oneByte, 0, 1, this.oneByte);
            }
            catch (ShortBufferException shortBufferException) {
                throw new EncryptedDocumentException(shortBufferException);
            }
            return this.oneByte[0];
        }

        public synchronized int read(byte[] byArray, int n, int n2) {
            int n3 = super.read(byArray, n, n2);
            if (n3 == -1) {
                return -1;
            }
            try {
                this.cipher.update(byArray, n, n3, byArray, n);
            }
            catch (ShortBufferException shortBufferException) {
                throw new EncryptedDocumentException(shortBufferException);
            }
            return n3;
        }

        public SeekableByteArrayInputStream(byte[] byArray) throws GeneralSecurityException {
            super(byArray);
            this.oneByte = new byte[]{0};
            this.cipher = CryptoAPIDecryptor.this.initCipherForBlock(null, 0);
        }
    }
}

