/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.crypt.binaryrc4;

import ai2.org.apache.poi.EncryptedDocumentException;
import ai2.org.apache.poi.poifs.crypt.ChunkedCipherOutputStream;
import ai2.org.apache.poi.poifs.crypt.CryptoFunctions;
import ai2.org.apache.poi.poifs.crypt.DataSpaceMapUtils;
import ai2.org.apache.poi.poifs.crypt.EncryptionInfo;
import ai2.org.apache.poi.poifs.crypt.Encryptor;
import ai2.org.apache.poi.poifs.crypt.HashAlgorithm;
import ai2.org.apache.poi.poifs.crypt.binaryrc4.BinaryRC4Decryptor;
import ai2.org.apache.poi.poifs.crypt.binaryrc4.BinaryRC4EncryptionHeader;
import ai2.org.apache.poi.poifs.crypt.binaryrc4.BinaryRC4EncryptionInfoBuilder;
import ai2.org.apache.poi.poifs.crypt.binaryrc4.BinaryRC4EncryptionVerifier;
import ai2.org.apache.poi.poifs.crypt.standard.EncryptionRecord;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.util.LittleEndianByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public class BinaryRC4Encryptor
extends Encryptor {
    private final BinaryRC4EncryptionInfoBuilder builder;

    protected BinaryRC4Encryptor(BinaryRC4EncryptionInfoBuilder binaryRC4EncryptionInfoBuilder) {
        this.builder = binaryRC4EncryptionInfoBuilder;
    }

    public void confirmPassword(String string) {
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[16];
        byte[] byArray2 = new byte[16];
        ((Random)secureRandom).nextBytes(byArray);
        ((Random)secureRandom).nextBytes(byArray2);
        this.confirmPassword(string, null, null, byArray2, byArray, null);
    }

    public void confirmPassword(String string, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5) {
        BinaryRC4EncryptionVerifier binaryRC4EncryptionVerifier = this.builder.getVerifier();
        binaryRC4EncryptionVerifier.setSalt(byArray4);
        SecretKey secretKey = BinaryRC4Decryptor.generateSecretKey(string, binaryRC4EncryptionVerifier);
        this.setSecretKey(secretKey);
        try {
            Cipher cipher = BinaryRC4Decryptor.initCipherForBlock(null, 0, this.builder, secretKey, 1);
            byte[] byArray6 = new byte[16];
            cipher.update(byArray3, 0, 16, byArray6);
            binaryRC4EncryptionVerifier.setEncryptedVerifier(byArray6);
            HashAlgorithm hashAlgorithm = binaryRC4EncryptionVerifier.getHashAlgorithm();
            MessageDigest messageDigest = CryptoFunctions.getMessageDigest(hashAlgorithm);
            byte[] byArray7 = messageDigest.digest(byArray3);
            byte[] byArray8 = cipher.doFinal(byArray7);
            binaryRC4EncryptionVerifier.setEncryptedVerifierHash(byArray8);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new EncryptedDocumentException("Password confirmation failed", generalSecurityException);
        }
    }

    public OutputStream getDataStream(DirectoryNode directoryNode) throws IOException, GeneralSecurityException {
        BinaryRC4CipherOutputStream binaryRC4CipherOutputStream = new BinaryRC4CipherOutputStream(directoryNode);
        return binaryRC4CipherOutputStream;
    }

    protected int getKeySizeInBytes() {
        return this.builder.getHeader().getKeySize() / 8;
    }

    protected void createEncryptionInfoEntry(DirectoryNode directoryNode) throws IOException {
        DataSpaceMapUtils.addDefaultDataSpace(directoryNode);
        final EncryptionInfo encryptionInfo = this.builder.getEncryptionInfo();
        final BinaryRC4EncryptionHeader binaryRC4EncryptionHeader = this.builder.getHeader();
        final BinaryRC4EncryptionVerifier binaryRC4EncryptionVerifier = this.builder.getVerifier();
        EncryptionRecord encryptionRecord = new EncryptionRecord(){

            public void write(LittleEndianByteArrayOutputStream littleEndianByteArrayOutputStream) {
                littleEndianByteArrayOutputStream.writeShort(encryptionInfo.getVersionMajor());
                littleEndianByteArrayOutputStream.writeShort(encryptionInfo.getVersionMinor());
                binaryRC4EncryptionHeader.write(littleEndianByteArrayOutputStream);
                binaryRC4EncryptionVerifier.write(littleEndianByteArrayOutputStream);
            }
        };
        DataSpaceMapUtils.createEncryptionEntry(directoryNode, "EncryptionInfo", encryptionRecord);
    }

    protected class BinaryRC4CipherOutputStream
    extends ChunkedCipherOutputStream {
        protected Cipher initCipherForBlock(Cipher cipher, int n, boolean bl) throws GeneralSecurityException {
            return BinaryRC4Decryptor.initCipherForBlock(cipher, n, BinaryRC4Encryptor.this.builder, BinaryRC4Encryptor.this.getSecretKey(), 1);
        }

        protected void calculateChecksum(File file, int n) {
        }

        protected void createEncryptionInfoEntry(DirectoryNode directoryNode, File file) throws IOException, GeneralSecurityException {
            BinaryRC4Encryptor.this.createEncryptionInfoEntry(directoryNode);
        }

        public BinaryRC4CipherOutputStream(DirectoryNode directoryNode) throws IOException, GeneralSecurityException {
            super(directoryNode, 512);
        }
    }
}

