/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.crypt.binaryrc4;

import ai2.org.apache.poi.EncryptedDocumentException;
import ai2.org.apache.poi.poifs.crypt.CipherAlgorithm;
import ai2.org.apache.poi.poifs.crypt.EncryptionVerifier;
import ai2.org.apache.poi.poifs.crypt.HashAlgorithm;
import ai2.org.apache.poi.poifs.crypt.standard.EncryptionRecord;
import ai2.org.apache.poi.util.LittleEndianByteArrayOutputStream;
import ai2.org.apache.poi.util.LittleEndianInput;

public class BinaryRC4EncryptionVerifier
extends EncryptionVerifier
implements EncryptionRecord {
    protected BinaryRC4EncryptionVerifier() {
        this.setSpinCount(-1);
        this.setCipherAlgorithm(CipherAlgorithm.rc4);
        this.setChainingMode(null);
        this.setEncryptedKey(null);
        this.setHashAlgorithm(HashAlgorithm.md5);
    }

    protected BinaryRC4EncryptionVerifier(LittleEndianInput littleEndianInput) {
        byte[] byArray = new byte[16];
        littleEndianInput.readFully(byArray);
        this.setSalt(byArray);
        byte[] byArray2 = new byte[16];
        littleEndianInput.readFully(byArray2);
        this.setEncryptedVerifier(byArray2);
        byte[] byArray3 = new byte[16];
        littleEndianInput.readFully(byArray3);
        this.setEncryptedVerifierHash(byArray3);
        this.setSpinCount(-1);
        this.setCipherAlgorithm(CipherAlgorithm.rc4);
        this.setChainingMode(null);
        this.setEncryptedKey(null);
        this.setHashAlgorithm(HashAlgorithm.md5);
    }

    protected void setSalt(byte[] byArray) {
        if (byArray == null || byArray.length != 16) {
            throw new EncryptedDocumentException("invalid verifier salt");
        }
        super.setSalt(byArray);
    }

    protected void setEncryptedVerifier(byte[] byArray) {
        super.setEncryptedVerifier(byArray);
    }

    protected void setEncryptedVerifierHash(byte[] byArray) {
        super.setEncryptedVerifierHash(byArray);
    }

    public void write(LittleEndianByteArrayOutputStream littleEndianByteArrayOutputStream) {
        byte[] byArray = this.getSalt();
        assert (byArray.length == 16);
        littleEndianByteArrayOutputStream.write(byArray);
        byte[] byArray2 = this.getEncryptedVerifier();
        assert (byArray2.length == 16);
        littleEndianByteArrayOutputStream.write(byArray2);
        byte[] byArray3 = this.getEncryptedVerifierHash();
        assert (byArray3.length == 16);
        littleEndianByteArrayOutputStream.write(byArray3);
    }
}

