/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.crypt.binaryrc4;

import ai2.org.apache.poi.poifs.crypt.ChainingMode;
import ai2.org.apache.poi.poifs.crypt.CipherAlgorithm;
import ai2.org.apache.poi.poifs.crypt.EncryptionInfo;
import ai2.org.apache.poi.poifs.crypt.EncryptionInfoBuilder;
import ai2.org.apache.poi.poifs.crypt.HashAlgorithm;
import ai2.org.apache.poi.poifs.crypt.binaryrc4.BinaryRC4Decryptor;
import ai2.org.apache.poi.poifs.crypt.binaryrc4.BinaryRC4EncryptionHeader;
import ai2.org.apache.poi.poifs.crypt.binaryrc4.BinaryRC4EncryptionVerifier;
import ai2.org.apache.poi.poifs.crypt.binaryrc4.BinaryRC4Encryptor;
import ai2.org.apache.poi.util.LittleEndianInput;
import java.io.IOException;

public class BinaryRC4EncryptionInfoBuilder
implements EncryptionInfoBuilder {
    EncryptionInfo info;
    BinaryRC4EncryptionHeader header;
    BinaryRC4EncryptionVerifier verifier;
    BinaryRC4Decryptor decryptor;
    BinaryRC4Encryptor encryptor;

    public void initialize(EncryptionInfo encryptionInfo, LittleEndianInput littleEndianInput) throws IOException {
        this.info = encryptionInfo;
        int n = encryptionInfo.getVersionMajor();
        int n2 = encryptionInfo.getVersionMinor();
        assert (n == 1 && n2 == 1);
        this.header = new BinaryRC4EncryptionHeader();
        this.verifier = new BinaryRC4EncryptionVerifier(littleEndianInput);
        this.decryptor = new BinaryRC4Decryptor(this);
        this.encryptor = new BinaryRC4Encryptor(this);
    }

    public void initialize(EncryptionInfo encryptionInfo, CipherAlgorithm cipherAlgorithm, HashAlgorithm hashAlgorithm, int n, int n2, ChainingMode chainingMode) {
        this.info = encryptionInfo;
        this.header = new BinaryRC4EncryptionHeader();
        this.verifier = new BinaryRC4EncryptionVerifier();
        this.decryptor = new BinaryRC4Decryptor(this);
        this.encryptor = new BinaryRC4Encryptor(this);
    }

    public BinaryRC4EncryptionHeader getHeader() {
        return this.header;
    }

    public BinaryRC4EncryptionVerifier getVerifier() {
        return this.verifier;
    }

    public BinaryRC4Decryptor getDecryptor() {
        return this.decryptor;
    }

    public BinaryRC4Encryptor getEncryptor() {
        return this.encryptor;
    }

    public EncryptionInfo getEncryptionInfo() {
        return this.info;
    }
}

