/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.crypt.agile;

import ai2.org.apache.poi.EncryptedDocumentException;
import ai2.org.apache.poi.poifs.crypt.ChunkedCipherOutputStream;
import ai2.org.apache.poi.poifs.crypt.CryptoFunctions;
import ai2.org.apache.poi.poifs.crypt.DataSpaceMapUtils;
import ai2.org.apache.poi.poifs.crypt.EncryptionInfo;
import ai2.org.apache.poi.poifs.crypt.Encryptor;
import ai2.org.apache.poi.poifs.crypt.HashAlgorithm;
import ai2.org.apache.poi.poifs.crypt.agile.AgileDecryptor;
import ai2.org.apache.poi.poifs.crypt.agile.AgileEncryptionHeader;
import ai2.org.apache.poi.poifs.crypt.agile.AgileEncryptionInfoBuilder;
import ai2.org.apache.poi.poifs.crypt.agile.AgileEncryptionVerifier;
import ai2.org.apache.poi.poifs.crypt.standard.EncryptionRecord;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.LittleEndianByteArrayOutputStream;
import com.microsoft.schemas.office.x2006.encryption.CTDataIntegrity;
import com.microsoft.schemas.office.x2006.encryption.CTEncryption;
import com.microsoft.schemas.office.x2006.encryption.CTKeyData;
import com.microsoft.schemas.office.x2006.encryption.CTKeyEncryptor;
import com.microsoft.schemas.office.x2006.encryption.CTKeyEncryptors;
import com.microsoft.schemas.office.x2006.encryption.EncryptionDocument;
import com.microsoft.schemas.office.x2006.encryption.STCipherAlgorithm;
import com.microsoft.schemas.office.x2006.encryption.STCipherChaining;
import com.microsoft.schemas.office.x2006.encryption.STHashAlgorithm;
import com.microsoft.schemas.office.x2006.keyEncryptor.certificate.CTCertificateKeyEncryptor;
import com.microsoft.schemas.office.x2006.keyEncryptor.password.CTPasswordKeyEncryptor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.util.HashMap;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.xmlbeans.XmlOptions;

public class AgileEncryptor
extends Encryptor {
    private final AgileEncryptionInfoBuilder builder;
    private byte[] integritySalt;
    private byte[] pwHash;
    private final CTKeyEncryptor.Uri.Enum passwordUri = CTKeyEncryptor.Uri.HTTP_SCHEMAS_MICROSOFT_COM_OFFICE_2006_KEY_ENCRYPTOR_PASSWORD;
    private final CTKeyEncryptor.Uri.Enum certificateUri = CTKeyEncryptor.Uri.HTTP_SCHEMAS_MICROSOFT_COM_OFFICE_2006_KEY_ENCRYPTOR_CERTIFICATE;

    protected AgileEncryptor(AgileEncryptionInfoBuilder agileEncryptionInfoBuilder) {
        this.builder = agileEncryptionInfoBuilder;
    }

    public void confirmPassword(String string) {
        SecureRandom secureRandom = new SecureRandom();
        int n = this.builder.getHeader().getBlockSize();
        int n2 = this.builder.getHeader().getKeySize() / 8;
        int n3 = this.builder.getHeader().getHashAlgorithmEx().hashSize;
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        byte[] byArray4 = new byte[n2];
        byte[] byArray5 = new byte[n3];
        ((Random)secureRandom).nextBytes(byArray);
        ((Random)secureRandom).nextBytes(byArray2);
        ((Random)secureRandom).nextBytes(byArray3);
        ((Random)secureRandom).nextBytes(byArray4);
        ((Random)secureRandom).nextBytes(byArray5);
        this.confirmPassword(string, byArray4, byArray3, byArray, byArray2, byArray5);
    }

    public void confirmPassword(String string, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5) {
        AgileEncryptionVerifier agileEncryptionVerifier = this.builder.getVerifier();
        agileEncryptionVerifier.setSalt(byArray4);
        AgileEncryptionHeader agileEncryptionHeader = this.builder.getHeader();
        agileEncryptionHeader.setKeySalt(byArray2);
        HashAlgorithm hashAlgorithm = agileEncryptionVerifier.getHashAlgorithm();
        int n = agileEncryptionHeader.getBlockSize();
        this.pwHash = CryptoFunctions.hashPassword(string, hashAlgorithm, byArray4, agileEncryptionVerifier.getSpinCount());
        byte[] byArray6 = AgileDecryptor.hashInput(this.builder, this.pwHash, AgileDecryptor.kVerifierInputBlock, byArray3, 1);
        agileEncryptionVerifier.setEncryptedVerifier(byArray6);
        MessageDigest messageDigest = CryptoFunctions.getMessageDigest(hashAlgorithm);
        byte[] byArray7 = messageDigest.digest(byArray3);
        byte[] byArray8 = AgileDecryptor.hashInput(this.builder, this.pwHash, AgileDecryptor.kHashedVerifierBlock, byArray7, 1);
        agileEncryptionVerifier.setEncryptedVerifierHash(byArray8);
        byte[] byArray9 = AgileDecryptor.hashInput(this.builder, this.pwHash, AgileDecryptor.kCryptoKeyBlock, byArray, 1);
        agileEncryptionVerifier.setEncryptedKey(byArray9);
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, agileEncryptionVerifier.getCipherAlgorithm().jceId);
        this.setSecretKey(secretKeySpec);
        this.integritySalt = byArray5;
        try {
            byte[] byArray10 = CryptoFunctions.generateIv(hashAlgorithm, agileEncryptionHeader.getKeySalt(), AgileDecryptor.kIntegrityKeyBlock, agileEncryptionHeader.getBlockSize());
            Cipher cipher = CryptoFunctions.getCipher(secretKeySpec, agileEncryptionVerifier.getCipherAlgorithm(), agileEncryptionVerifier.getChainingMode(), byArray10, 1);
            byte[] byArray11 = CryptoFunctions.getBlock0(byArray5, AgileDecryptor.getNextBlockSize(byArray5.length, n));
            byte[] byArray12 = cipher.doFinal(byArray11);
            agileEncryptionHeader.setEncryptedHmacKey(byArray12);
            cipher = Cipher.getInstance("RSA");
            for (AgileEncryptionVerifier.AgileCertificateEntry agileCertificateEntry : agileEncryptionVerifier.getCertificates()) {
                cipher.init(1, agileCertificateEntry.x509.getPublicKey());
                agileCertificateEntry.encryptedKey = cipher.doFinal(this.getSecretKey().getEncoded());
                Mac mac = CryptoFunctions.getMac(hashAlgorithm);
                mac.init(this.getSecretKey());
                agileCertificateEntry.certVerifier = mac.doFinal(agileCertificateEntry.x509.getEncoded());
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new EncryptedDocumentException(generalSecurityException);
        }
    }

    public OutputStream getDataStream(DirectoryNode directoryNode) throws IOException, GeneralSecurityException {
        AgileCipherOutputStream agileCipherOutputStream = new AgileCipherOutputStream(directoryNode);
        return agileCipherOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateIntegrityHMAC(File file, int n) throws GeneralSecurityException, IOException {
        AgileEncryptionVerifier agileEncryptionVerifier = this.builder.getVerifier();
        HashAlgorithm hashAlgorithm = agileEncryptionVerifier.getHashAlgorithm();
        Mac mac = CryptoFunctions.getMac(hashAlgorithm);
        mac.init(new SecretKeySpec(this.integritySalt, hashAlgorithm.jceHmacId));
        byte[] byArray = new byte[1024];
        LittleEndian.putLong(byArray, 0, n);
        mac.update(byArray, 0, 8);
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            int n2;
            while ((n2 = ((InputStream)fileInputStream).read(byArray)) != -1) {
                mac.update(byArray, 0, n2);
            }
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
        byte[] byArray2 = mac.doFinal();
        AgileEncryptionHeader agileEncryptionHeader = this.builder.getHeader();
        int n3 = agileEncryptionHeader.getBlockSize();
        byte[] byArray3 = CryptoFunctions.generateIv(agileEncryptionHeader.getHashAlgorithmEx(), agileEncryptionHeader.getKeySalt(), AgileDecryptor.kIntegrityValueBlock, n3);
        Cipher cipher = CryptoFunctions.getCipher(this.getSecretKey(), agileEncryptionHeader.getCipherAlgorithm(), agileEncryptionHeader.getChainingMode(), byArray3, 1);
        byte[] byArray4 = CryptoFunctions.getBlock0(byArray2, AgileDecryptor.getNextBlockSize(byArray2.length, n3));
        byte[] byArray5 = cipher.doFinal(byArray4);
        agileEncryptionHeader.setEncryptedHmacValue(byArray5);
    }

    protected EncryptionDocument createEncryptionDocument() {
        AgileEncryptionVerifier agileEncryptionVerifier = this.builder.getVerifier();
        AgileEncryptionHeader agileEncryptionHeader = this.builder.getHeader();
        EncryptionDocument encryptionDocument = EncryptionDocument.Factory.newInstance();
        CTEncryption cTEncryption = encryptionDocument.addNewEncryption();
        CTKeyData cTKeyData = cTEncryption.addNewKeyData();
        CTKeyEncryptors cTKeyEncryptors = cTEncryption.addNewKeyEncryptors();
        CTKeyEncryptor cTKeyEncryptor = cTKeyEncryptors.addNewKeyEncryptor();
        cTKeyEncryptor.setUri(this.passwordUri);
        CTPasswordKeyEncryptor cTPasswordKeyEncryptor = cTKeyEncryptor.addNewEncryptedPasswordKey();
        cTPasswordKeyEncryptor.setSpinCount(agileEncryptionVerifier.getSpinCount());
        cTKeyData.setSaltSize(agileEncryptionHeader.getBlockSize());
        cTPasswordKeyEncryptor.setSaltSize(agileEncryptionHeader.getBlockSize());
        cTKeyData.setBlockSize(agileEncryptionHeader.getBlockSize());
        cTPasswordKeyEncryptor.setBlockSize(agileEncryptionHeader.getBlockSize());
        cTKeyData.setKeyBits((long)agileEncryptionHeader.getKeySize());
        cTPasswordKeyEncryptor.setKeyBits((long)agileEncryptionHeader.getKeySize());
        HashAlgorithm hashAlgorithm = agileEncryptionHeader.getHashAlgorithmEx();
        cTKeyData.setHashSize(hashAlgorithm.hashSize);
        cTPasswordKeyEncryptor.setHashSize(hashAlgorithm.hashSize);
        STCipherAlgorithm.Enum enum_ = STCipherAlgorithm.Enum.forString((String)agileEncryptionHeader.getCipherAlgorithm().xmlId);
        if (enum_ == null) {
            throw new EncryptedDocumentException("CipherAlgorithm " + (Object)((Object)agileEncryptionHeader.getCipherAlgorithm()) + " not supported.");
        }
        cTKeyData.setCipherAlgorithm(enum_);
        cTPasswordKeyEncryptor.setCipherAlgorithm(enum_);
        switch (agileEncryptionHeader.getChainingMode()) {
            case cbc: {
                cTKeyData.setCipherChaining(STCipherChaining.CHAINING_MODE_CBC);
                cTPasswordKeyEncryptor.setCipherChaining(STCipherChaining.CHAINING_MODE_CBC);
                break;
            }
            case cfb: {
                cTKeyData.setCipherChaining(STCipherChaining.CHAINING_MODE_CFB);
                cTPasswordKeyEncryptor.setCipherChaining(STCipherChaining.CHAINING_MODE_CFB);
                break;
            }
            default: {
                throw new EncryptedDocumentException("ChainingMode " + (Object)((Object)agileEncryptionHeader.getChainingMode()) + " not supported.");
            }
        }
        STHashAlgorithm.Enum enum_2 = STHashAlgorithm.Enum.forString((String)hashAlgorithm.ecmaString);
        if (enum_2 == null) {
            throw new EncryptedDocumentException("HashAlgorithm " + (Object)((Object)hashAlgorithm) + " not supported.");
        }
        cTKeyData.setHashAlgorithm(enum_2);
        cTPasswordKeyEncryptor.setHashAlgorithm(enum_2);
        cTKeyData.setSaltValue(agileEncryptionHeader.getKeySalt());
        cTPasswordKeyEncryptor.setSaltValue(agileEncryptionVerifier.getSalt());
        cTPasswordKeyEncryptor.setEncryptedVerifierHashInput(agileEncryptionVerifier.getEncryptedVerifier());
        cTPasswordKeyEncryptor.setEncryptedVerifierHashValue(agileEncryptionVerifier.getEncryptedVerifierHash());
        cTPasswordKeyEncryptor.setEncryptedKeyValue(agileEncryptionVerifier.getEncryptedKey());
        CTDataIntegrity cTDataIntegrity = cTEncryption.addNewDataIntegrity();
        cTDataIntegrity.setEncryptedHmacKey(agileEncryptionHeader.getEncryptedHmacKey());
        cTDataIntegrity.setEncryptedHmacValue(agileEncryptionHeader.getEncryptedHmacValue());
        for (AgileEncryptionVerifier.AgileCertificateEntry agileCertificateEntry : agileEncryptionVerifier.getCertificates()) {
            cTKeyEncryptor = cTKeyEncryptors.addNewKeyEncryptor();
            cTKeyEncryptor.setUri(this.certificateUri);
            CTCertificateKeyEncryptor cTCertificateKeyEncryptor = cTKeyEncryptor.addNewEncryptedCertificateKey();
            try {
                cTCertificateKeyEncryptor.setX509Certificate(agileCertificateEntry.x509.getEncoded());
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new EncryptedDocumentException(certificateEncodingException);
            }
            cTCertificateKeyEncryptor.setEncryptedKeyValue(agileCertificateEntry.encryptedKey);
            cTCertificateKeyEncryptor.setCertVerifier(agileCertificateEntry.certVerifier);
        }
        return encryptionDocument;
    }

    protected void marshallEncryptionDocument(EncryptionDocument encryptionDocument, LittleEndianByteArrayOutputStream littleEndianByteArrayOutputStream) {
        XmlOptions xmlOptions = new XmlOptions();
        xmlOptions.setCharacterEncoding("UTF-8");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(this.passwordUri.toString(), "p");
        hashMap.put(this.certificateUri.toString(), "c");
        xmlOptions.setUseDefaultNamespace();
        xmlOptions.setSaveSuggestedPrefixes(hashMap);
        xmlOptions.setSaveNamespacesFirst();
        xmlOptions.setSaveAggressiveNamespaces();
        xmlOptions.setSaveNoXmlDecl();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\r\n".getBytes("UTF-8"));
            encryptionDocument.save((OutputStream)byteArrayOutputStream, xmlOptions);
            littleEndianByteArrayOutputStream.write(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new EncryptedDocumentException("error marshalling encryption info document", iOException);
        }
    }

    protected void createEncryptionInfoEntry(DirectoryNode directoryNode, File file) throws IOException, GeneralSecurityException {
        DataSpaceMapUtils.addDefaultDataSpace(directoryNode);
        final EncryptionInfo encryptionInfo = this.builder.getInfo();
        EncryptionRecord encryptionRecord = new EncryptionRecord(){

            public void write(LittleEndianByteArrayOutputStream littleEndianByteArrayOutputStream) {
                littleEndianByteArrayOutputStream.writeShort(encryptionInfo.getVersionMajor());
                littleEndianByteArrayOutputStream.writeShort(encryptionInfo.getVersionMinor());
                littleEndianByteArrayOutputStream.writeInt(encryptionInfo.getEncryptionFlags());
                EncryptionDocument encryptionDocument = AgileEncryptor.this.createEncryptionDocument();
                AgileEncryptor.this.marshallEncryptionDocument(encryptionDocument, littleEndianByteArrayOutputStream);
            }
        };
        DataSpaceMapUtils.createEncryptionEntry(directoryNode, "EncryptionInfo", encryptionRecord);
    }

    private class AgileCipherOutputStream
    extends ChunkedCipherOutputStream {
        public AgileCipherOutputStream(DirectoryNode directoryNode) throws IOException, GeneralSecurityException {
            super(directoryNode, 4096);
        }

        protected Cipher initCipherForBlock(Cipher cipher, int n, boolean bl) throws GeneralSecurityException {
            return AgileDecryptor.initCipherForBlock(cipher, n, bl, AgileEncryptor.this.builder, AgileEncryptor.this.getSecretKey(), 1);
        }

        protected void calculateChecksum(File file, int n) throws GeneralSecurityException, IOException {
            AgileEncryptor.this.updateIntegrityHMAC(file, n);
        }

        protected void createEncryptionInfoEntry(DirectoryNode directoryNode, File file) throws IOException, GeneralSecurityException {
            AgileEncryptor.this.createEncryptionInfoEntry(directoryNode, file);
        }
    }
}

