/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.crypt.agile;

import ai2.org.apache.poi.EncryptedDocumentException;
import ai2.org.apache.poi.poifs.crypt.ChainingMode;
import ai2.org.apache.poi.poifs.crypt.CipherAlgorithm;
import ai2.org.apache.poi.poifs.crypt.EncryptionVerifier;
import ai2.org.apache.poi.poifs.crypt.HashAlgorithm;
import ai2.org.apache.poi.poifs.crypt.agile.AgileEncryptionInfoBuilder;
import com.microsoft.schemas.office.x2006.encryption.CTKeyEncryptor;
import com.microsoft.schemas.office.x2006.encryption.EncryptionDocument;
import com.microsoft.schemas.office.x2006.keyEncryptor.certificate.CTCertificateKeyEncryptor;
import com.microsoft.schemas.office.x2006.keyEncryptor.password.CTPasswordKeyEncryptor;
import java.io.ByteArrayInputStream;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgileEncryptionVerifier
extends EncryptionVerifier {
    private List<AgileCertificateEntry> certList = new ArrayList<AgileCertificateEntry>();

    public AgileEncryptionVerifier(String string) {
        this(AgileEncryptionInfoBuilder.parseDescriptor(string));
    }

    protected AgileEncryptionVerifier(EncryptionDocument encryptionDocument) {
        CTPasswordKeyEncryptor cTPasswordKeyEncryptor;
        Iterator iterator = encryptionDocument.getEncryption().getKeyEncryptors().getKeyEncryptorList().iterator();
        try {
            cTPasswordKeyEncryptor = ((CTKeyEncryptor)iterator.next()).getEncryptedPasswordKey();
            if (cTPasswordKeyEncryptor == null) {
                throw new NullPointerException("encryptedKey not set");
            }
        }
        catch (Exception exception) {
            throw new EncryptedDocumentException("Unable to parse keyData", exception);
        }
        int n = (int)cTPasswordKeyEncryptor.getKeyBits();
        CipherAlgorithm cipherAlgorithm = CipherAlgorithm.fromXmlId(cTPasswordKeyEncryptor.getCipherAlgorithm().toString(), n);
        this.setCipherAlgorithm(cipherAlgorithm);
        int n2 = cTPasswordKeyEncryptor.getHashSize();
        HashAlgorithm hashAlgorithm = HashAlgorithm.fromEcmaId(cTPasswordKeyEncryptor.getHashAlgorithm().toString());
        this.setHashAlgorithm(hashAlgorithm);
        if (this.getHashAlgorithm().hashSize != n2) {
            throw new EncryptedDocumentException("Unsupported hash algorithm: " + cTPasswordKeyEncryptor.getHashAlgorithm() + " @ " + n2 + " bytes");
        }
        this.setSpinCount(cTPasswordKeyEncryptor.getSpinCount());
        this.setEncryptedVerifier(cTPasswordKeyEncryptor.getEncryptedVerifierHashInput());
        this.setSalt(cTPasswordKeyEncryptor.getSaltValue());
        this.setEncryptedKey(cTPasswordKeyEncryptor.getEncryptedKeyValue());
        this.setEncryptedVerifierHash(cTPasswordKeyEncryptor.getEncryptedVerifierHashValue());
        int n3 = cTPasswordKeyEncryptor.getSaltSize();
        if (n3 != this.getSalt().length) {
            throw new EncryptedDocumentException("Invalid salt size");
        }
        switch (cTPasswordKeyEncryptor.getCipherChaining().intValue()) {
            case 1: {
                this.setChainingMode(ChainingMode.cbc);
                break;
            }
            case 2: {
                this.setChainingMode(ChainingMode.cfb);
                break;
            }
            default: {
                throw new EncryptedDocumentException("Unsupported chaining mode - " + cTPasswordKeyEncryptor.getCipherChaining().toString());
            }
        }
        if (!iterator.hasNext()) {
            return;
        }
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            while (iterator.hasNext()) {
                CTCertificateKeyEncryptor cTCertificateKeyEncryptor = ((CTKeyEncryptor)iterator.next()).getEncryptedCertificateKey();
                AgileCertificateEntry agileCertificateEntry = new AgileCertificateEntry();
                agileCertificateEntry.certVerifier = cTCertificateKeyEncryptor.getCertVerifier();
                agileCertificateEntry.encryptedKey = cTCertificateKeyEncryptor.getEncryptedKeyValue();
                agileCertificateEntry.x509 = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(cTCertificateKeyEncryptor.getX509Certificate()));
                this.certList.add(agileCertificateEntry);
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new EncryptedDocumentException("can't parse X509 certificate", generalSecurityException);
        }
    }

    public AgileEncryptionVerifier(CipherAlgorithm cipherAlgorithm, HashAlgorithm hashAlgorithm, int n, int n2, ChainingMode chainingMode) {
        this.setCipherAlgorithm(cipherAlgorithm);
        this.setHashAlgorithm(hashAlgorithm);
        this.setChainingMode(chainingMode);
        this.setSpinCount(100000);
    }

    @Override
    protected void setSalt(byte[] byArray) {
        if (byArray == null || byArray.length != this.getCipherAlgorithm().blockSize) {
            throw new EncryptedDocumentException("invalid verifier salt");
        }
        super.setSalt(byArray);
    }

    @Override
    protected void setEncryptedVerifier(byte[] byArray) {
        super.setEncryptedVerifier(byArray);
    }

    @Override
    protected void setEncryptedVerifierHash(byte[] byArray) {
        super.setEncryptedVerifierHash(byArray);
    }

    @Override
    protected void setEncryptedKey(byte[] byArray) {
        super.setEncryptedKey(byArray);
    }

    public void addCertificate(X509Certificate x509Certificate) {
        AgileCertificateEntry agileCertificateEntry = new AgileCertificateEntry();
        agileCertificateEntry.x509 = x509Certificate;
        this.certList.add(agileCertificateEntry);
    }

    public List<AgileCertificateEntry> getCertificates() {
        return this.certList;
    }

    public static class AgileCertificateEntry {
        X509Certificate x509;
        byte[] encryptedKey;
        byte[] certVerifier;
    }
}

